/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import java.awt.Color;
import java.awt.Paint;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.indicator.MACDChartRenderer;
import leaseLineQuote.candle.graph.indicator.MACDDataSource;
import leaseLineQuote.candle.graph.indicator.TechnicalIndicator;

public class MACDIndicator
extends TechnicalIndicator {
    private MACDChartRenderer renderer;
    private MACDDataSource macdDS;
    private Color[] colors;
    private int fastPeriod;
    private int slowPeriod;
    private int signalPeriod;

    public MACDIndicator(StockDataSource stockDS, Color[] colors, int fastPeriod, int slowPeriod, int signalPeriod, boolean divergence) {
        super(stockDS);
        this.colors = colors;
        this.macdDS = new MACDDataSource(fastPeriod, slowPeriod, signalPeriod, divergence);
        this.fastPeriod = fastPeriod;
        this.slowPeriod = slowPeriod;
        this.signalPeriod = signalPeriod;
    }

    @Override
    public void attach(IlvChart chart) {
        super.attach(chart);
        this.renderer = new MACDChartRenderer(this.colors[0], this.colors[1], this.colors[2]);
        this.refresh();
        this.renderer.setDataSource(this.macdDS);
        chart.addRenderer(this.renderer);
    }

    @Override
    public void setColor(Color[] colors) {
        this.colors = colors;
        IlvChartRenderer r2 = this.renderer.getChild(0);
        if (r2 != null) {
            r2.setStyle(0, new IlvStyle(this.colors[2], (Paint)this.colors[2]));
            r2 = this.renderer.getChild(1);
            r2.setStyle(0, new IlvStyle(this.colors[0], (Paint)this.colors[0]));
            r2 = this.renderer.getChild(2);
            r2.setStyle(0, new IlvStyle(this.colors[1], (Paint)this.colors[1]));
        }
    }

    @Override
    public void setCfg(Object cfg) {
        int[] cfgs = (int[])cfg;
        this.macdDS.fastPeriod = cfgs[0];
        this.macdDS.slowPeriod = cfgs[1];
        this.macdDS.signalPeriod = cfgs[2];
        this.refresh();
    }

    @Override
    public void detach() {
        if (this.chart != null) {
            this.chart.removeRenderer(this.renderer);
        }
        this.renderer = null;
        super.detach();
    }

    @Override
    public void refresh() {
        this.macdDS.setPriceDataSet(this.stockDS.getCloseDataSet());
    }

    @Override
    public IlvDisplayPoint getHighlightedPoint(int dataIdx) {
        IlvDataSet dataSet = this.getMainDataSet();
        if (this.renderer != null && dataSet != null && dataSet.getDataCount() > 0) {
            return this.renderer.getDisplayPoint(dataSet, dataIdx);
        }
        return null;
    }

    @Override
    public String getName() {
        return "MACD";
    }

    public static TechnicalIndicator createMACD(StockDataSource stockDS, Color[] colors, int[] vals) {
        MACDIndicator indicator = new MACDIndicator(stockDS, colors, vals[0], vals[1], vals[2], true);
        return indicator;
    }

    @Override
    public IlvDataSet getMainDataSet() {
        return this.macdDS.getDataSet(1);
    }
}

