/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custindicator.freehand;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDefaultDataSet;
import ilog.views.chart.renderer.IlvSinglePolylineRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import leaseLineQuote.candle.graph.custindicator.freehand.PolylineTracer;

public class FreeHandInteractor
extends IlvChartInteractor {
    private PolylineTracer ploylineTracer;
    private IlvStyle style;
    private IlvSinglePolylineRenderer render;
    private IlvDefaultDataSet dataSet;

    public FreeHandInteractor() {
        super(-1, 1024);
        this.enableEvents(48L);
        this.dataSet = new IlvDefaultDataSet("FreeHand");
        this.render = new IlvSinglePolylineRenderer();
    }

    @Override
    public void chartConnected(IlvChart oldChart, IlvChart newChart) {
        newChart.addRenderer((IlvChartRenderer)this.render, this.dataSet);
        this.ploylineTracer = new PolylineTracer(this.dataSet, newChart.getXScale(), newChart.getYScale(0));
    }

    public void clearData() {
        this.ploylineTracer.clearData();
    }

    public void setColor(Color color, int thickness) {
        this.style = new IlvStyle(new BasicStroke(thickness), (Paint)color);
        this.render.setStyle(this.style);
    }

    @Override
    public void processMouseEvent(MouseEvent evt) {
        try {
            switch (evt.getID()) {
                case 501: {
                    if (evt.getButton() != 1) break;
                    this.startOperation(evt);
                    this.ploylineTracer.press(evt.getPoint());
                    evt.consume();
                    break;
                }
                case 502: {
                    if (!this.isInOperation()) break;
                    this.endOperation(evt);
                    evt.consume();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }

    @Override
    public void processMouseMotionEvent(MouseEvent evt) {
        try {
            if (evt.getID() == 506 && this.isInOperation()) {
                this.ploylineTracer.dragged(evt.getPoint());
                evt.consume();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }
}

