/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.control;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.datasource.histrecord.HistRecordReader;

public class UpdateCandle {
    private static UpdateCandle uc;
    private String stockCode;
    private int monthIndex = 0;
    private int frequency = 0;
    private int period = 0;
    private long lastUpdate = 0L;
    private long check = 60000L;
    private long sleepTime = 5000L;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean isAutoRefresh = true;
    private static final SimpleDateFormat sdf;
    private static final SimpleDateFormat sdf1;
    private long check1 = 0L;
    private String currTimer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpdateCandle getInstance() {
        if (uc != null) return uc;
        Class<UpdateCandle> clazz = UpdateCandle.class;
        synchronized (UpdateCandle.class) {
            if (uc != null) return uc;
            uc = new UpdateCandle();
            // ** MonitorExit[var0] (shouldn't be in output)
            return uc;
        }
    }

    private UpdateCandle() {
        this.requestUpdate();
    }

    public void setAutoRefresh(boolean isAutoRefresh) {
        this.isAutoRefresh = isAutoRefresh;
    }

    public void setUpdateTime(long check, long sleepTime) {
        this.check = check <= 0L ? 60000L : check;
        this.sleepTime = sleepTime <= 0L ? 5000L : sleepTime;
    }

    public void setCurrentTime(String inTime) {
        this.currTimer = inTime;
    }

    public void checkTimer(int sec) {
        String tmpCurrentTimer = this.currTimer;
        try {
            if (sec < 10) {
                sec = 10;
            }
            this.check1 = 0L;
            Calendar c2 = Calendar.getInstance();
            c2.setTime(sdf.parse(tmpCurrentTimer));
            if (c2.get(13) <= sec) {
                this.check1 = sec * 1000;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String stockCode, int monthIndex, int period, int frequency) {
        try {
            this.lock.lock();
            this.stockCode = stockCode;
            this.monthIndex = monthIndex;
            this.frequency = frequency;
            this.period = period;
            this.lastUpdate = System.currentTimeMillis();
            System.out.println(sdf1.format(new Date()) + ": UpdateCandle--setData[" + stockCode + "][" + monthIndex + "][" + frequency + "][" + period + "]");
            this.checkTimer(10);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void requestUpdate() {
        Thread t2 = new Thread("UpdateCandle"){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(UpdateCandle.this.sleepTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    UpdateCandle.this.isAutoRefresh = CandleNewFrame.getInstance().isFrameVisible();
                    if (!UpdateCandle.this.isAutoRefresh) continue;
                    try {
                        UpdateCandle.this.lock.lock();
                        long now = System.currentTimeMillis();
                        if (!HistRecordReader.isMinChart(UpdateCandle.this.period)) continue;
                        if (UpdateCandle.this.check1 > 0L) {
                            if (UpdateCandle.this.lastUpdate <= 0L || now - UpdateCandle.this.lastUpdate < UpdateCandle.this.check1) continue;
                            UpdateCandle.this.sendUpdateCandle();
                            UpdateCandle.this.check1 = 0L;
                            continue;
                        }
                        if (UpdateCandle.this.lastUpdate <= 0L || now - UpdateCandle.this.lastUpdate < UpdateCandle.this.check) continue;
                        UpdateCandle.this.sendUpdateCandle();
                        UpdateCandle.this.checkTimer(10);
                        continue;
                    }
                    finally {
                        UpdateCandle.this.lock.unlock();
                        continue;
                    }
                    break;
                }
            }
        };
        t2.setDaemon(true);
        t2.setPriority(1);
        t2.start();
    }

    private void sendUpdateCandle() {
        this.debug("requestUpdate() : " + this.toString());
        CandleNewFrame.getControlInterface().loadQuote(this.stockCode, this.monthIndex, this.period, this.frequency);
    }

    private void debug(String msg) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(sdf1.format(new Date())).append(": [UpdateCandle] : ").append(msg);
        System.out.println(sb.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append('[').append(this.stockCode).append(']');
        sb.append('[').append(this.monthIndex).append(']');
        sb.append('[').append(this.frequency).append(']');
        sb.append('[').append(this.period).append(']');
        return sb.toString();
    }

    static {
        sdf = new SimpleDateFormat("HH:mm:ss");
        sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

