/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.control;

import hk.com.realink.histnews.typeimple.HistRecordRes;
import ilog.views.chart.IlvChart;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import leaseLineQuote.StyledFont;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.control.HKIndexCode;
import leaseLineQuote.candle.graph.ControlInterface;
import leaseLineQuote.candle.graph.core.CandlePanel;
import leaseLineQuote.candle.print.PrintFlowFrame;
import leaseLineQuote.candle.testpart.IntegerTextField;

public class ControlPanel {
    private static final String PERIDO_TYPE_SECURITIES_DAILY = "Securities Daily";
    private static final String PERIDO_TYPE_SECURITIES_WEEKLY = "Securities Weekly";
    private static final String PERIDO_TYPE_SECURITIES_MONTHLY = "Securities Monthly";
    private static final String PERIDO_TYPE_SECURITIES_INTERDAY = "Securities Interday";
    private static final String PERIDO_TYPE_INTRA_DAY_HSF = "HSF intra-day";
    private static final String PERIDO_TYPE_INTRA_DAY_MHI = "MHI intra-day";
    private static final String PERIDO_TYPE_INTRA_DAY_HHI = "HHI intra-day";
    private static ControlPanel controlPanelTest;
    private JPanel panelTop = new JPanel();
    public JButton btnConfig = new JButton();
    public JButton btnPrevPage = new JButton();
    public JButton btnBackPage = new JButton();
    public JButton btnFitPage = new JButton();
    public JButton btnPrint = new JButton();
    private final JComboBox stockIndexComboBox = new JComboBox();
    private final JButton stockIndexSubmitButton = new JButton();
    public JToggleButton togBtnZoom = new JToggleButton();
    public JToggleButton togBtnLine = new JToggleButton();
    public JToggleButton togBtnEditLine = new JToggleButton();
    public JToggleButton togBtnClear = new JToggleButton();
    public ButtonGroup togGroup = new ButtonGroup();
    private boolean isJFrame = false;
    private IntegerTextField sctyCodeInputField;
    private final JComboBox periodTypeComboBox = new JComboBox();
    public JComboBox comboBoxFuturePeriod = new JComboBox<String>(new String[]{"Current", "Next", "Quarter"});
    public JComboBox comboBoxMinPeriod = new JComboBox<String>(new String[]{"1  MINS", "5 MINS", "15 MINS", "60 MINS"});
    public boolean isChinese = false;
    public CandlePanel candlePanel = CandlePanel.getInstance();
    private boolean isChgCode = true;
    private PrintFlowFrame printFlowFrame = new PrintFlowFrame();
    private static final String[] STOCK_CHART_ITEM_LIST;
    private static final String[] FUTURE_CHART_ITEM_LIST;
    private boolean isStockChartVisible = true;
    private boolean isFutureMinChartVisible = false;
    private boolean isStockMinChartVisible = false;
    private static String prevStock;
    private boolean isInitListener = false;

    private static final boolean haveObejct(Object[] ol, Object v) {
        for (Object o2 : ol) {
            if (o2 != v) continue;
            return true;
        }
        return false;
    }

    public static ControlPanel getInstance() {
        if (controlPanelTest == null) {
            controlPanelTest = new ControlPanel();
        }
        return controlPanelTest;
    }

    public int getFrequency() {
        Object periodTypeObj = this.periodTypeComboBox.getSelectedItem();
        if (periodTypeObj == PERIDO_TYPE_SECURITIES_DAILY) {
            return 0;
        }
        if (periodTypeObj == PERIDO_TYPE_SECURITIES_WEEKLY) {
            return 1;
        }
        if (periodTypeObj == PERIDO_TYPE_SECURITIES_MONTHLY) {
            return 2;
        }
        if (periodTypeObj == PERIDO_TYPE_INTRA_DAY_HSF || periodTypeObj == PERIDO_TYPE_INTRA_DAY_MHI || periodTypeObj == PERIDO_TYPE_INTRA_DAY_HHI || periodTypeObj == PERIDO_TYPE_SECURITIES_INTERDAY) {
            return 3;
        }
        return 0;
    }

    private ControlPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }

    private void jbInit() throws Exception {
        this.periodTypeComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object finalValue = value;
                if (ControlPanel.this.isChinese) {
                    if (value == ControlPanel.PERIDO_TYPE_SECURITIES_DAILY) {
                        finalValue = "\u80a1\u7968\u65e5\u5716";
                    } else if (value == ControlPanel.PERIDO_TYPE_SECURITIES_WEEKLY) {
                        finalValue = "\u80a1\u7968\u9031\u5716";
                    } else if (value == ControlPanel.PERIDO_TYPE_SECURITIES_MONTHLY) {
                        finalValue = "\u80a1\u7968\u6708\u5716";
                    } else if (value == ControlPanel.PERIDO_TYPE_SECURITIES_INTERDAY) {
                        finalValue = "\u80a1\u7968\u5206\u9418";
                    } else if (value == ControlPanel.PERIDO_TYPE_INTRA_DAY_HSF) {
                        finalValue = "\u671f\u6307\u5373\u65e5";
                    } else if (value == ControlPanel.PERIDO_TYPE_INTRA_DAY_MHI) {
                        finalValue = "\u5c0f\u671f\u5373\u65e5";
                    } else if (value == ControlPanel.PERIDO_TYPE_INTRA_DAY_HHI) {
                        finalValue = "\u570b\u4f01\u5373\u65e5";
                    }
                } else if (value == ControlPanel.PERIDO_TYPE_SECURITIES_DAILY) {
                    finalValue = ControlPanel.PERIDO_TYPE_SECURITIES_DAILY;
                } else if (value == ControlPanel.PERIDO_TYPE_SECURITIES_WEEKLY) {
                    finalValue = ControlPanel.PERIDO_TYPE_SECURITIES_WEEKLY;
                } else if (value == ControlPanel.PERIDO_TYPE_SECURITIES_MONTHLY) {
                    finalValue = ControlPanel.PERIDO_TYPE_SECURITIES_MONTHLY;
                } else if (value == ControlPanel.PERIDO_TYPE_SECURITIES_INTERDAY) {
                    finalValue = ControlPanel.PERIDO_TYPE_SECURITIES_INTERDAY;
                } else if (value == ControlPanel.PERIDO_TYPE_INTRA_DAY_HSF) {
                    finalValue = ControlPanel.PERIDO_TYPE_INTRA_DAY_HSF;
                } else if (value == ControlPanel.PERIDO_TYPE_INTRA_DAY_MHI) {
                    finalValue = ControlPanel.PERIDO_TYPE_INTRA_DAY_MHI;
                } else if (value == ControlPanel.PERIDO_TYPE_INTRA_DAY_HHI) {
                    finalValue = ControlPanel.PERIDO_TYPE_INTRA_DAY_HHI;
                }
                return super.getListCellRendererComponent((JList<?>)list, finalValue, index, isSelected, cellHasFocus);
            }
        });
        this.updatePeridoTypeComboBox();
    }

    public JPanel getTopPanel(boolean isJFrame) {
        this.isJFrame = isJFrame;
        this.panelTop.setLayout(new BorderLayout());
        this.panelTop.add((Component)this.getLeftPanel(), "West");
        this.panelTop.setBackground(Color.WHITE);
        return this.panelTop;
    }

    public boolean isChgCode() {
        return this.isChgCode;
    }

    public void setIsChgCode(boolean isChgCode) {
        this.isChgCode = isChgCode;
    }

    private void initListener() {
        if (!this.isInitListener) {
            this.isInitListener = true;
            this.periodTypeComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e2) {
                    if (e2.getStateChange() == 1) {
                        CandleNewFrame candleNewFrame = CandleNewFrame.getInstance();
                        JComboBox cb = (JComboBox)e2.getSource();
                        Object periodTypeObj = cb.getSelectedItem();
                        if (ControlPanel.this.isStockChartVisible && ControlPanel.haveObejct(STOCK_CHART_ITEM_LIST, periodTypeObj)) {
                            if (ControlPanel.this.sctyCodeInputField != null) {
                                ControlPanel.this.sctyCodeInputField.setEnabled(true);
                            }
                            ControlPanel.this.comboBoxFuturePeriod.setEnabled(false);
                            ControlPanel.this.comboBoxMinPeriod.setEnabled(false);
                            if (candleNewFrame.isIterdayPeriod()) {
                                candleNewFrame.setIterdayPeriod(-1);
                                if (ControlPanel.this.sctyCodeInputField != null) {
                                    String scty_code = ControlPanel.this.sctyCodeInputField.getText();
                                    if (scty_code != null && scty_code.trim().length() > 0) {
                                        CandleNewFrame.getControlInterface().loadQuote(scty_code, -1, ControlPanel.this.getFrequency(), 1);
                                    } else {
                                        ControlPanel.this.sctyCodeInputField.setText(prevStock);
                                        CandleNewFrame.getControlInterface().loadQuote(prevStock, -1, ControlPanel.this.getFrequency(), 1);
                                    }
                                } else {
                                    ControlPanel.this.sctyCodeInputField.setText(prevStock);
                                    CandleNewFrame.getControlInterface().loadQuote(prevStock, -1, ControlPanel.this.getFrequency(), 1);
                                }
                            } else {
                                candleNewFrame.setIterdayPeriod(-1);
                                ControlPanel.this.setIsChgCode(false);
                                if (periodTypeObj == ControlPanel.PERIDO_TYPE_SECURITIES_DAILY) {
                                    CandleNewFrame.ctrInf.setStockDataSourcePeriod(ControlPanel.this.getFrequency(), 1);
                                } else if (periodTypeObj == ControlPanel.PERIDO_TYPE_SECURITIES_WEEKLY) {
                                    CandleNewFrame.ctrInf.setStockDataSourcePeriod(ControlPanel.this.getFrequency(), 1);
                                } else if (periodTypeObj == ControlPanel.PERIDO_TYPE_SECURITIES_MONTHLY) {
                                    CandleNewFrame.ctrInf.setStockDataSourcePeriod(ControlPanel.this.getFrequency(), 1);
                                }
                            }
                        } else if (ControlPanel.this.isFutureMinChartVisible && ControlPanel.haveObejct(FUTURE_CHART_ITEM_LIST, periodTypeObj)) {
                            if (ControlPanel.this.sctyCodeInputField != null) {
                                ControlPanel.this.sctyCodeInputField.setText("");
                                ControlPanel.this.sctyCodeInputField.setEnabled(false);
                            }
                            ControlPanel.this.comboBoxFuturePeriod.setEnabled(true);
                            ControlPanel.this.comboBoxMinPeriod.setEnabled(true);
                            ControlPanel.this.interdayRefresh();
                        } else if (ControlPanel.this.isStockMinChartVisible && ControlPanel.PERIDO_TYPE_SECURITIES_INTERDAY == periodTypeObj) {
                            if (ControlPanel.this.sctyCodeInputField != null) {
                                ControlPanel.this.sctyCodeInputField.setEnabled(true);
                            }
                            ControlPanel.this.comboBoxMinPeriod.setEnabled(true);
                            ControlPanel.this.comboBoxFuturePeriod.setEnabled(false);
                            ControlPanel.this.comboBoxMinPeriod.setSelectedIndex(0);
                            if (candleNewFrame.isIterdayPeriod()) {
                                candleNewFrame.setIterdayPeriod(-1);
                                if (ControlPanel.this.sctyCodeInputField != null) {
                                    String scty_code = ControlPanel.this.sctyCodeInputField.getText();
                                    if (scty_code != null && scty_code.trim().length() > 0) {
                                        candleNewFrame.getControlInterface().loadQuote(scty_code, -1, ControlPanel.this.getFrequency(), 1);
                                    } else {
                                        ControlPanel.this.sctyCodeInputField.setText("2");
                                        candleNewFrame.getControlInterface().loadQuote("2", -1, ControlPanel.this.getFrequency(), 1);
                                    }
                                } else {
                                    candleNewFrame.getControlInterface().loadQuote("2", -1, ControlPanel.this.getFrequency(), 1);
                                }
                            } else {
                                candleNewFrame.setIterdayPeriod(-1);
                                ControlPanel.this.setIsChgCode(false);
                                CandleNewFrame.ctrInf.setStockDataSourcePeriod(ControlPanel.this.getFrequency(), 1);
                            }
                        }
                        ControlPanel.this.panelTop.updateUI();
                    }
                }
            });
        }
    }

    private JPanel getLeftPanel() {
        this.initListener();
        this.togGroup.add(this.togBtnZoom);
        this.togGroup.add(this.togBtnLine);
        this.togGroup.add(this.togBtnEditLine);
        this.togGroup.add(this.togBtnClear);
        this.togBtnZoom.setSelected(true);
        this.togBtnZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ControlPanel.this.candlePanel.setInteractorHighlightEnable(true);
                ControlPanel.this.candlePanel.setInteractorAutoYZoomEnable(true);
                ControlPanel.this.candlePanel.setInteractorPanEnable(true);
                ControlPanel.this.candlePanel.setInteractorXScrollEnable(true);
                ControlPanel.this.candlePanel.setInteractorFreeHandEnable(false);
                ControlPanel.this.candlePanel.setInteractorEditPointEnable(false);
            }
        });
        this.togBtnLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ControlPanel.this.candlePanel.setInteractorHighlightEnable(true);
                ControlPanel.this.candlePanel.setInteractorAutoYZoomEnable(false);
                ControlPanel.this.candlePanel.setInteractorPanEnable(true);
                ControlPanel.this.candlePanel.setInteractorXScrollEnable(true);
                ControlPanel.this.candlePanel.setInteractorFreeHandEnable(true);
                ControlPanel.this.candlePanel.setInteractorEditPointEnable(false);
            }
        });
        this.togBtnEditLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ControlPanel.this.candlePanel.setInteractorHighlightEnable(true);
                ControlPanel.this.candlePanel.setInteractorAutoYZoomEnable(false);
                ControlPanel.this.candlePanel.setInteractorPanEnable(true);
                ControlPanel.this.candlePanel.setInteractorXScrollEnable(true);
                ControlPanel.this.candlePanel.setInteractorFreeHandEnable(false);
                ControlPanel.this.candlePanel.setInteractorEditPointEnable(true);
            }
        });
        this.togBtnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ControlPanel.this.candlePanel.freeHandInterator.clearData();
            }
        });
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (ControlPanel.this.printFlowFrame != null) {
                    ControlPanel.this.printFlowFrame.close();
                }
                ControlPanel.this.printFlowFrame = new PrintFlowFrame();
                ControlPanel.this.printFlowFrame.addCharts(ControlPanel.this.candlePanel.getMainChart(), 98, 0.34f);
                IlvChart[] charts = ControlPanel.this.candlePanel.getLowerCharts();
                for (int i2 = 0; i2 < charts.length; ++i2) {
                    ControlPanel.this.printFlowFrame.addCharts(charts[i2], 98, 0.12f);
                }
                ControlPanel.this.printFlowFrame.printPreview();
            }
        });
        JPanel leftPanel = new JPanel();
        leftPanel.setBackground(Color.WHITE);
        if (this.isJFrame) {
            this.sctyCodeInputField = new IntegerTextField(5);
            this.sctyCodeInputField.setPreferredSize(new Dimension(28, 25));
            this.sctyCodeInputField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        String scty_code = ControlPanel.this.sctyCodeInputField.getText();
                        if (scty_code != null) {
                            scty_code = scty_code.trim();
                        }
                        if (scty_code != null && scty_code.length() > 0) {
                            if (!HKIndexCode.isCode(scty_code)) {
                                try {
                                    int i2 = Integer.parseInt(scty_code);
                                    if (i2 <= 0) {
                                        System.out.println("controlPanel -- Skip -- Value not in Index Range : " + i2);
                                        return;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            prevStock = scty_code;
                            ControlPanel.this.requestHistory(scty_code);
                        }
                    }
                }
            });
            leftPanel.add(this.sctyCodeInputField);
        }
        this.stockIndexSubmitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    String s2 = (String)ControlPanel.this.stockIndexComboBox.getSelectedItem();
                    String code = HKIndexCode.nameToCode(s2);
                    if (code != null) {
                        prevStock = code;
                        ControlPanel.this.requestHistory(code);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        leftPanel.add((Component)this.periodTypeComboBox, null);
        leftPanel.add(this.comboBoxFuturePeriod);
        leftPanel.add(this.comboBoxMinPeriod);
        JPanel g2Panel = new JPanel();
        g2Panel.setBackground(Color.LIGHT_GRAY);
        g2Panel.setBorder(BorderFactory.createEtchedBorder(0, Color.GRAY, Color.WHITE));
        g2Panel.add((Component)this.btnFitPage, null);
        g2Panel.add((Component)this.btnPrevPage, null);
        g2Panel.add((Component)this.btnBackPage, null);
        leftPanel.add(g2Panel);
        JPanel gPanel = new JPanel();
        gPanel.setBackground(Color.LIGHT_GRAY);
        gPanel.setBorder(BorderFactory.createEtchedBorder(0, Color.GRAY, Color.WHITE));
        leftPanel.add(gPanel);
        gPanel.add((Component)this.togBtnZoom, null);
        gPanel.add((Component)this.togBtnLine, null);
        gPanel.add((Component)this.togBtnEditLine, null);
        gPanel.add((Component)this.togBtnClear, null);
        JPanel g3Panel = new JPanel();
        g3Panel.setBackground(Color.LIGHT_GRAY);
        g3Panel.setBorder(BorderFactory.createEtchedBorder(0, Color.GRAY, Color.WHITE));
        leftPanel.add(g3Panel);
        g3Panel.add((Component)this.btnConfig, null);
        g3Panel.add((Component)this.btnPrint, null);
        this.comboBoxFuturePeriod.setEnabled(false);
        this.comboBoxMinPeriod.setEnabled(false);
        JPanel g4Panel = new JPanel();
        g4Panel.setBackground(Color.LIGHT_GRAY);
        g4Panel.setBorder(BorderFactory.createEtchedBorder(0, Color.GRAY, Color.WHITE));
        g4Panel.add(this.stockIndexComboBox);
        g4Panel.add(this.stockIndexSubmitButton);
        leftPanel.add(g4Panel);
        return leftPanel;
    }

    public void requestHistory(String inputStockCode) {
        System.out.println("controlPanel -- requestHistory()");
        if (this.isStockChartVisible || this.isStockMinChartVisible) {
            CandleNewFrame candleNewFrame = CandleNewFrame.getInstance();
            ControlInterface ctrInf = candleNewFrame.getControlInterface();
            if (candleNewFrame.isIterdayPeriod()) {
                ControlPanel controlPanel = ControlPanel.getInstance();
                controlPanel.comboBoxFuturePeriod.setEnabled(false);
                controlPanel.comboBoxMinPeriod.setEnabled(false);
                controlPanel.periodTypeComboBox.setSelectedIndex(0);
                candleNewFrame.setIterdayPeriod(-1);
                ctrInf.loadQuote(inputStockCode, -1, controlPanel.getFrequency(), 1);
            } else {
                ControlPanel controlPanel = ControlPanel.getInstance();
                ctrInf.loadQuote(inputStockCode, -1, controlPanel.getFrequency(), 1);
            }
            if (this.isJFrame) {
                this.sctyCodeInputField.setText(inputStockCode);
                this.sctyCodeInputField.selectAll();
            }
        } else {
            this.interdayRefresh();
        }
    }

    public void interdayRefresh() {
        System.out.println("interdayRefresh");
        CandleNewFrame candleNewFrame = CandleNewFrame.getInstance();
        Object periodTypeObj = this.periodTypeComboBox.getSelectedItem();
        String code = "";
        if (periodTypeObj == PERIDO_TYPE_INTRA_DAY_HSF) {
            code = "HSI";
        } else if (periodTypeObj == PERIDO_TYPE_INTRA_DAY_MHI) {
            code = "MHI";
        } else if (periodTypeObj == PERIDO_TYPE_INTRA_DAY_HHI) {
            code = "HHI";
        } else {
            return;
        }
        int period = this.comboBoxFuturePeriod.getSelectedIndex();
        switch (period) {
            case 0: {
                candleNewFrame.setIterdayPeriod(HistRecordRes.PERIOD_CURR_MONTH);
                this.candlePanel.loadQuote(code, HistRecordRes.PERIOD_CURR_MONTH, this.getFrequency(), this.getMinute());
                break;
            }
            case 1: {
                candleNewFrame.setIterdayPeriod(HistRecordRes.PERIOD_NEXT_MONTH);
                this.candlePanel.loadQuote(code, HistRecordRes.PERIOD_NEXT_MONTH, this.getFrequency(), this.getMinute());
                break;
            }
            case 2: {
                candleNewFrame.setIterdayPeriod(HistRecordRes.PERIOD_QUAT_MONTH);
                this.candlePanel.loadQuote(code, HistRecordRes.PERIOD_QUAT_MONTH, this.getFrequency(), this.getMinute());
                break;
            }
        }
    }

    public void setChinese() {
        this.isChinese = true;
        this.setBtnSize(this.togBtnZoom, "img/c_zoom.gif", "img/c_p_zoom.gif", 21, 21);
        this.setBtnSize(this.togBtnLine, "img/c_drawline.gif", "img/c_p_drawline.gif", 21, 21);
        this.setBtnSize(this.togBtnEditLine, "img/c_moveline.gif", "img/c_p_moveline.gif", 21, 21);
        this.setBtnSize(this.togBtnClear, "img/c_deleteline.gif", "img/c_p_deleteline.gif", 21, 21);
        this.setBtnSize(this.btnConfig, "img/c_setting.gif", "img/c_p_setting.gif", 21, 21);
        this.setBtnSize(this.btnPrevPage, "img/c_previous.gif", "img/c_p_previous.gif", 21, 21);
        this.setBtnSize(this.btnBackPage, "img/c_next.gif", "img/c_p_next.gif", 21, 21);
        this.setBtnSize(this.btnFitPage, "img/c_fullpage.gif", "img/c_p_fullpage.gif", 21, 21);
        this.setBtnSize(this.btnPrint, "img/c_print.gif", "img/c_p_print.gif", 21, 21);
        this.togBtnZoom.setToolTipText("\u7e2e\u653e");
        this.togBtnLine.setToolTipText("\u7e6a\u5716");
        this.togBtnEditLine.setToolTipText("\u79fb\u7dda");
        this.togBtnClear.setToolTipText("\u522a\u9664");
        this.btnConfig.setToolTipText("\u8a2d\u5b9a");
        this.btnPrevPage.setToolTipText("\u524d\u9801");
        this.btnBackPage.setToolTipText("\u5f8c\u9801");
        this.btnFitPage.setToolTipText("\u5168\u8996");
        this.btnPrint.setToolTipText("\u5217\u5370");
        this.comboBoxFuturePeriod.removeAllItems();
        this.comboBoxFuturePeriod.addItem("\u73fe\u6708");
        this.comboBoxFuturePeriod.addItem("\u4e0b\u6708");
        this.comboBoxFuturePeriod.addItem("\u5b63\u6708");
        this.comboBoxFuturePeriod.setFont(StyledFont.PLAIN_CHINESE);
        this.comboBoxMinPeriod.removeAllItems();
        this.comboBoxMinPeriod.addItem("1  \u5206\u9418");
        this.comboBoxMinPeriod.addItem("5 \u5206\u9418");
        this.comboBoxMinPeriod.addItem("15 \u5206\u9418");
        this.comboBoxMinPeriod.addItem("60 \u5206\u9418");
        this.comboBoxMinPeriod.setFont(StyledFont.PLAIN_CHINESE);
        this.stockIndexComboBox.removeAllItems();
        for (String s2 : HKIndexCode.getChiNameList()) {
            this.stockIndexComboBox.addItem(s2);
        }
        this.stockIndexComboBox.setFont(StyledFont.PLAIN_CHINESE);
        this.stockIndexSubmitButton.setText("\u78ba\u5b9a");
        this.periodTypeComboBox.setFont(StyledFont.PLAIN_CHINESE);
        this.periodTypeComboBox.repaint();
    }

    private void setBtnSize(AbstractButton button, String gifName) {
        this.setBtnSize(button, gifName, null, 65, 21);
    }

    private void setBtnSize(AbstractButton button, String gifName, String pressGifName, int width, int height) {
        button.setMaximumSize(new Dimension(width, height));
        button.setMinimumSize(new Dimension(width, height));
        button.setOpaque(false);
        try {
            button.setIcon(new ImageIcon(this.getClass().getResource(gifName)));
            if (pressGifName != null) {
                button.setPressedIcon(new ImageIcon(this.getClass().getResource(pressGifName)));
                button.setSelectedIcon(new ImageIcon(this.getClass().getResource(pressGifName)));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
        button.setPreferredSize(new Dimension(width, height));
        button.setRequestFocusEnabled(false);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void setBtnSize(AbstractButton button, String gifName, String pressGifName) {
        button.setMaximumSize(new Dimension(65, 21));
        button.setMinimumSize(new Dimension(65, 21));
        button.setOpaque(false);
        try {
            button.setIcon(new ImageIcon(this.getClass().getResource(gifName)));
            if (pressGifName != null) {
                button.setPressedIcon(new ImageIcon(this.getClass().getResource(pressGifName)));
                button.setSelectedIcon(new ImageIcon(this.getClass().getResource(pressGifName)));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
        button.setPreferredSize(new Dimension(65, 21));
        button.setRequestFocusEnabled(false);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void setEnglish() {
        this.isChinese = false;
        this.setBtnSize(this.togBtnZoom, "img/e_zoom.gif", "img/e_p_zoom.gif", 21, 21);
        this.setBtnSize(this.togBtnLine, "img/e_drawline.gif", "img/e_p_drawline.gif", 21, 21);
        this.setBtnSize(this.togBtnEditLine, "img/e_moveline.gif", "img/e_p_moveline.gif", 21, 21);
        this.setBtnSize(this.togBtnClear, "img/e_deleteline.gif", "img/e_p_deleteline.gif", 21, 21);
        this.setBtnSize(this.btnConfig, "img/e_setting.gif", "img/e_p_setting.gif", 21, 21);
        this.setBtnSize(this.btnPrevPage, "img/e_previous.gif", "img/e_p_previous.gif", 21, 21);
        this.setBtnSize(this.btnBackPage, "img/e_next.gif", "img/e_p_next.gif", 21, 21);
        this.setBtnSize(this.btnFitPage, "img/e_fullpage.gif", "img/e_p_fullpage.gif", 21, 21);
        this.setBtnSize(this.btnPrint, "img/e_print.gif", "img/e_p_print.gif", 21, 21);
        this.togBtnZoom.setToolTipText("Zoom");
        this.togBtnLine.setToolTipText("Draw Line");
        this.togBtnEditLine.setToolTipText("Move Line");
        this.togBtnClear.setToolTipText("Delete Line");
        this.btnConfig.setToolTipText("Config");
        this.btnPrevPage.setToolTipText("Previous");
        this.btnBackPage.setToolTipText("Next");
        this.btnFitPage.setToolTipText("Lastest View");
        this.btnPrint.setToolTipText("Print ...");
        this.comboBoxFuturePeriod.removeAllItems();
        this.comboBoxFuturePeriod.addItem("Current");
        this.comboBoxFuturePeriod.addItem("Next");
        this.comboBoxFuturePeriod.addItem("Quarter");
        this.comboBoxFuturePeriod.setFont(StyledFont.PLAIN_CHINESE);
        this.comboBoxMinPeriod.removeAllItems();
        this.comboBoxMinPeriod.addItem("1  MINS");
        this.comboBoxMinPeriod.addItem("5 MINS");
        this.comboBoxMinPeriod.addItem("15 MINS");
        this.comboBoxMinPeriod.addItem("60 MINS");
        this.comboBoxMinPeriod.setFont(StyledFont.PLAIN_CHINESE);
        this.stockIndexComboBox.removeAllItems();
        for (String s2 : HKIndexCode.getEngNameList()) {
            this.stockIndexComboBox.addItem(s2);
        }
        this.stockIndexComboBox.setFont(StyledFont.PLAIN_CHINESE);
        this.stockIndexSubmitButton.setText("Submit");
        this.periodTypeComboBox.setFont(StyledFont.PLAIN_CHINESE);
        this.periodTypeComboBox.repaint();
    }

    public void setStockChartVisible(boolean visible) {
        System.out.println("setStockChartVisible : " + visible);
        this.isStockChartVisible = visible;
        if (this.sctyCodeInputField != null) {
            this.sctyCodeInputField.setEnabled(visible);
        }
        this.updatePeridoTypeComboBox();
    }

    public void setFutureMinChartVisible(boolean visible) {
        this.isFutureMinChartVisible = visible;
        this.updatePeridoTypeComboBox();
    }

    public void setStockMinChartVisible(boolean visible) {
        this.isStockMinChartVisible = visible;
        if (this.sctyCodeInputField != null) {
            this.sctyCodeInputField.setEnabled(visible);
        }
        this.updatePeridoTypeComboBox();
    }

    private void updatePeridoTypeComboBox() {
        this.periodTypeComboBox.removeAllItems();
        if (this.isStockChartVisible) {
            this.periodTypeComboBox.addItem(PERIDO_TYPE_SECURITIES_DAILY);
            this.periodTypeComboBox.addItem(PERIDO_TYPE_SECURITIES_WEEKLY);
            this.periodTypeComboBox.addItem(PERIDO_TYPE_SECURITIES_MONTHLY);
        }
        if (this.isStockMinChartVisible) {
            this.periodTypeComboBox.addItem(PERIDO_TYPE_SECURITIES_INTERDAY);
        }
        if (this.isFutureMinChartVisible) {
            this.periodTypeComboBox.addItem(PERIDO_TYPE_INTRA_DAY_HSF);
            this.periodTypeComboBox.addItem(PERIDO_TYPE_INTRA_DAY_MHI);
            this.periodTypeComboBox.addItem(PERIDO_TYPE_INTRA_DAY_HHI);
        }
        if (this.isChinese) {
            this.setChinese();
        } else {
            this.setEnglish();
        }
    }

    public int getMinute() {
        int selectedIdx = this.comboBoxMinPeriod.getSelectedIndex();
        int amount = 1;
        switch (selectedIdx) {
            case 0: {
                amount = 1;
                break;
            }
            case 1: {
                amount = 5;
                break;
            }
            case 2: {
                amount = 15;
                break;
            }
            case 3: {
                amount = 60;
                break;
            }
        }
        return amount;
    }

    public static void main(String[] args) {
        ControlPanel cpt = ControlPanel.getInstance();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("HelloWorldSwing");
        frame.setDefaultCloseOperation(3);
        boolean isJFrame = false;
        JPanel topPanel = cpt.getTopPanel(isJFrame);
        frame.getContentPane().add(topPanel);
        frame.pack();
        frame.setVisible(true);
        cpt.setChinese();
    }

    static {
        STOCK_CHART_ITEM_LIST = new String[]{PERIDO_TYPE_SECURITIES_DAILY, PERIDO_TYPE_SECURITIES_WEEKLY, PERIDO_TYPE_SECURITIES_MONTHLY};
        FUTURE_CHART_ITEM_LIST = new String[]{PERIDO_TYPE_INTRA_DAY_HSF, PERIDO_TYPE_INTRA_DAY_MHI, PERIDO_TYPE_INTRA_DAY_HHI};
        prevStock = "2";
    }
}

