/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.cfgpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import leaseLineQuote.ColorButton;
import leaseLineQuote.StyledFont;
import leaseLineQuote.UserProfile;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.cfgpanel.CandleConfigFrame;
import leaseLineQuote.candle.graph.ControlInterface;

public class HiLoCfgPanel
extends JPanel {
    private static HiLoCfgPanel hiLoCfgPanel;
    private CandleConfigFrame parentFrame;
    private ColorButton colorPosCandle;
    private ColorButton colorNegCandle;
    private ColorButton colorCandleBar;
    private JLabel lblCandleMode;
    private JLabel lblTransparent;
    private JLabel lblTransValue;
    private JLabel lblColorH;
    private JLabel lblColorI;
    private JLabel lblColorJ;
    private JComboBox comboMode;
    private JSlider transSlider;
    public static Color colorPos;
    public static Color colorNeg;
    public static Color colorBar;
    private Integer transValue;
    private Integer candleMode;

    private HiLoCfgPanel(CandleConfigFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.createHiLoPanel();
    }

    public static HiLoCfgPanel getInstance(CandleConfigFrame parentFrame) {
        if (hiLoCfgPanel == null) {
            hiLoCfgPanel = new HiLoCfgPanel(parentFrame);
        }
        return hiLoCfgPanel;
    }

    public void setChinese() {
        this.lblCandleMode.setText("\u9670\u967d\u71ed\u5716\u986f\u793a\u6a21\u5f0f: ");
        this.lblCandleMode.setFont(StyledFont.PLAIN_CHINESE);
        this.lblColorH.setText("\u967d\u71ed\u8272\u5f69: ");
        this.lblColorH.setFont(StyledFont.PLAIN_CHINESE);
        this.lblColorI.setText("\u9670\u71ed\u8272\u5f69: ");
        this.lblColorI.setFont(StyledFont.PLAIN_CHINESE);
        this.lblColorJ.setText("\u68d2\u5f62\u5716\u8272\u5f69: ");
        this.lblColorJ.setFont(StyledFont.PLAIN_CHINESE);
        this.lblTransparent.setText("\u900f\u660e\u5ea6: ");
        this.lblTransparent.setFont(StyledFont.PLAIN_CHINESE);
        this.comboMode.removeAllItems();
        this.comboMode.addItem("\u9670\u967d\u71ed\u5716");
        this.comboMode.addItem("\u68d2\u5f62\u5716");
        this.comboMode.setFont(StyledFont.PLAIN_CHINESE);
    }

    public void setEnglish() {
        this.lblCandleMode.setText("Candle Stick Mode: ");
        this.lblCandleMode.setFont(StyledFont.PLAINFONT);
        this.lblColorH.setText("Positive Color: ");
        this.lblColorH.setFont(StyledFont.PLAINFONT);
        this.lblColorI.setText("Negative Color: ");
        this.lblColorI.setFont(StyledFont.PLAINFONT);
        this.lblColorJ.setText("Bar Line Color: ");
        this.lblColorJ.setFont(StyledFont.PLAINFONT);
        this.lblTransparent.setText("Transparency: ");
        this.lblTransparent.setFont(StyledFont.PLAINFONT);
        this.comboMode.removeAllItems();
        this.comboMode.addItem("Candle Stick");
        this.comboMode.addItem("Bar Chart");
        this.comboMode.setFont(StyledFont.PLAINFONT);
    }

    public void createHiLoPanel() {
        this.setLayout(null);
        Color colorPos = Color.red;
        Color colorNeg = Color.blue;
        Color colorBar = Color.black;
        this.comboMode = new JComboBox<String>(new String[]{"Candle Stick", "Bar Chart"});
        this.comboMode.setBounds(new Rectangle(130, 6, 120, 25));
        this.comboMode.setForeground(Color.black);
        this.comboMode.setBackground(Color.white);
        this.lblCandleMode = new JLabel("Candle Stick Mode: ");
        this.lblCandleMode.setBounds(new Rectangle(6, 6, 120, 23));
        this.lblCandleMode.setForeground(Color.black);
        this.colorPosCandle = new ColorButton(colorPos, (JFrame)this.parentFrame);
        this.colorPosCandle.setBounds(new Rectangle(130, 37, 10, 10));
        this.lblColorH = new JLabel("Positive Candle Color: ");
        this.lblColorH.setBounds(new Rectangle(6, 34, 126, 19));
        this.lblColorH.setForeground(Color.black);
        this.colorNegCandle = new ColorButton(colorNeg, (JFrame)this.parentFrame);
        this.colorNegCandle.setBounds(new Rectangle(130, 64, 10, 10));
        this.lblColorI = new JLabel("Negative Candle Color: ");
        this.lblColorI.setBounds(new Rectangle(6, 61, 130, 19));
        this.lblColorI.setForeground(Color.black);
        this.colorCandleBar = new ColorButton(colorBar, (JFrame)this.parentFrame);
        this.colorCandleBar.setBounds(new Rectangle(130, 90, 10, 10));
        this.lblColorJ = new JLabel("Bar Line Color: ");
        this.lblColorJ.setBounds(new Rectangle(6, 87, 86, 19));
        this.lblColorJ.setForeground(Color.black);
        this.lblTransparent = new JLabel("Transparency: ");
        this.lblTransparent.setBounds(new Rectangle(6, 113, 86, 13));
        this.lblTransparent.setForeground(Color.black);
        this.lblTransValue = new JLabel("100%");
        this.lblTransValue.setBounds(new Rectangle(230, 113, 50, 20));
        this.lblTransValue.setForeground(Color.black);
        this.transSlider = new JSlider(0, 0, 255, 255);
        this.transSlider.setBounds(new Rectangle(130, 113, 90, 20));
        this.transSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int tempTransValue = Math.round((float)HiLoCfgPanel.this.transSlider.getValue() / (float)HiLoCfgPanel.this.transSlider.getMaximum() * 100.0f);
                HiLoCfgPanel.this.lblTransValue.setText(tempTransValue + "%");
            }
        });
        this.add((Component)this.colorCandleBar);
        this.add(this.lblCandleMode);
        this.add(this.comboMode);
        this.add(this.lblColorH);
        this.add(this.lblColorI);
        this.add((Component)this.colorPosCandle);
        this.add((Component)this.colorNegCandle);
        this.add(this.lblColorJ);
        this.add(this.lblTransparent);
        this.add(this.transSlider);
        this.add(this.lblTransValue);
    }

    public void processConfirm() {
        this.processSetting();
        this.storeSetting();
    }

    private void processSetting() {
        ControlInterface ctrInf = CandleNewFrame.getControlInterface();
        this.transValue = new Integer(this.transSlider.getValue());
        colorPos = new Color(this.colorPosCandle.getBackground().getRed(), this.colorPosCandle.getBackground().getGreen(), this.colorPosCandle.getBackground().getBlue(), this.transValue);
        colorNeg = new Color(this.colorNegCandle.getBackground().getRed(), this.colorNegCandle.getBackground().getGreen(), this.colorNegCandle.getBackground().getBlue(), this.transValue);
        colorBar = new Color(this.colorCandleBar.getBackground().getRed(), this.colorCandleBar.getBackground().getGreen(), this.colorCandleBar.getBackground().getBlue(), this.transValue);
        this.candleMode = new Integer(this.comboMode.getSelectedIndex());
        if (this.comboMode.getSelectedIndex() == 0) {
            ctrInf.setUpperIndicatorsColor("MAIN_GRAPH", 5, new Color[]{colorBar, colorPos, colorNeg});
        } else {
            ctrInf.setUpperIndicatorsColor("MAIN_GRAPH", 4, new Color[]{colorBar, colorPos, colorNeg});
        }
    }

    private void storeSetting() {
        UserProfile.put((Object)"HiLoCfgPanel:candleMode", (Object)this.candleMode);
        UserProfile.put((Object)"HiLoCfgPanel:transValue", (Object)this.transValue);
        UserProfile.put((Object)"HiLoCfgPanel:colorPos", (Object)colorPos);
        UserProfile.put((Object)"HiLoCfgPanel:colorNeg", (Object)colorNeg);
        UserProfile.put((Object)"HiLoCfgPanel:colorBar", (Object)colorBar);
    }

    public void loadSetting() {
        Integer candleMode = (Integer)UserProfile.get((Object)"HiLoCfgPanel:candleMode");
        Integer transValue = (Integer)UserProfile.get((Object)"HiLoCfgPanel:transValue");
        Color colorPos = (Color)UserProfile.get((Object)"HiLoCfgPanel:colorPos");
        Color colorNeg = (Color)UserProfile.get((Object)"HiLoCfgPanel:colorNeg");
        Color colorBar = (Color)UserProfile.get((Object)"HiLoCfgPanel:colorBar");
        if (candleMode != null && transValue != null && colorPos != null && colorNeg != null && colorBar != null) {
            try {
                this.comboMode.setSelectedIndex(candleMode);
                this.transSlider.setValue(transValue);
                this.colorPosCandle.setBackground(colorPos);
                this.colorNegCandle.setBackground(colorNeg);
                this.colorCandleBar.setBackground(colorBar);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.processSetting();
    }
}

