/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.cfgpanel;

import java.text.DecimalFormat;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FloatStyledDocument
extends PlainDocument {
    private int limit;
    private boolean isInteger;
    private static DecimalFormat df = new DecimalFormat("0");

    public FloatStyledDocument(int limit, boolean isInteger) {
        this.limit = limit;
        this.isInteger = isInteger;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null || str.equals("+") || str.equals("-")) {
            return;
        }
        if (this.getLength() + str.length() <= this.limit) {
            if (str == null || str.length() == 0) {
                return;
            }
            if (this.isInteger) {
                try {
                    str = df.format(Float.parseFloat(str));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int i2 = str.length();
                while (--i2 >= 0) {
                    if (Character.isDigit(str.charAt(i2))) continue;
                    throw new BadLocationException(str, offset);
                }
            } else {
                int i3 = str.length();
                while (--i3 >= 0) {
                    if (Character.isDigit(str.charAt(i3)) || str.charAt(i3) == '.') continue;
                    throw new BadLocationException(str, offset);
                }
            }
            super.insertString(offset, str, attr);
        }
    }
}

