/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class IlvMultipleGradientPaint
implements Paint,
Serializable {
    private int a = 1;
    float[] b;
    Color[] c;
    transient AffineTransform d;
    short e;
    short f;
    boolean g;
    public static final short SPREAD_PAD = 1;
    public static final short SPREAD_REFLECT = 2;
    public static final short SPREAD_REPEAT = 3;
    public static final short SRGB = 0;
    public static final short LINEAR_RGB = 1;

    IlvMultipleGradientPaint(float[] fArray, Color[] colorArray, short s2, short s3, AffineTransform affineTransform, boolean bl) {
        if (colorArray.length < 2) {
            throw new IllegalArgumentException("User must specify at least 2 colors");
        }
        if (s3 != 1 && s3 != 0) {
            throw new IllegalArgumentException("Invalid colorspace for interpolation");
        }
        if (s2 != 1 && s2 != 2 && s2 != 3) {
            throw new IllegalArgumentException("Invalid spread method");
        }
        this.b = new float[fArray.length];
        System.arraycopy(fArray, 0, this.b, 0, fArray.length);
        this.c = new Color[colorArray.length];
        System.arraycopy(colorArray, 0, this.c, 0, colorArray.length);
        this.f = s3;
        this.e = s2;
        this.d = affineTransform == null ? null : (AffineTransform)affineTransform.clone();
        this.g = bl;
        this.initTransparency();
    }

    protected final void initTransparency() {
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            if (this.c[i2].getAlpha() == 255) continue;
            this.a = 3;
            break;
        }
    }

    public final Color[] getColors() {
        Color[] colorArray = new Color[this.c.length];
        System.arraycopy(this.c, 0, colorArray, 0, this.c.length);
        return colorArray;
    }

    public final float[] getStops() {
        float[] fArray = new float[this.b.length];
        System.arraycopy(this.b, 0, fArray, 0, this.b.length);
        return fArray;
    }

    public final int getTransparency() {
        return this.a;
    }

    public final boolean isAdapting() {
        return this.g;
    }

    public final short getSpreadMethod() {
        return this.e;
    }

    public final short getColorSpace() {
        return this.f;
    }

    public final AffineTransform getTransform() {
        if (this.d != null) {
            return new AffineTransform(this.d);
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AffineTransform affineTransform = this.d;
        boolean bl = affineTransform != null;
        objectOutputStream.writeBoolean(bl);
        if (bl) {
            objectOutputStream.writeDouble(affineTransform.getScaleX());
            objectOutputStream.writeDouble(affineTransform.getShearY());
            objectOutputStream.writeDouble(affineTransform.getShearX());
            objectOutputStream.writeDouble(affineTransform.getScaleY());
            objectOutputStream.writeDouble(affineTransform.getTranslateX());
            objectOutputStream.writeDouble(affineTransform.getTranslateY());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            double d2 = objectInputStream.readDouble();
            double d3 = objectInputStream.readDouble();
            double d4 = objectInputStream.readDouble();
            double d5 = objectInputStream.readDouble();
            double d6 = objectInputStream.readDouble();
            double d7 = objectInputStream.readDouble();
            this.d = new AffineTransform(d2, d3, d4, d5, d6, d7);
        } else {
            this.d = null;
        }
    }
}

