/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.view3d.Ilv3DVector;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.chart.view3d.IlvChart3DScene;
import ilog.views.chart.view3d.IlvPolyhedron;
import java.awt.Dimension;
import java.awt.Point;

public class IlvChart3DArea
extends IlvChart3DObject {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    private boolean a;

    public IlvChart3DArea(IlvChart3DScene ilvChart3DScene, double[] dArray, double[] dArray2, double[] dArray3, IlvSingleChartRenderer ilvSingleChartRenderer, int n2) {
        super(ilvChart3DScene, ilvSingleChartRenderer, n2);
        double d2 = dArray3[0];
        double d3 = dArray3[1];
        Ilv3DVector[] ilv3DVectorArray = new Ilv3DVector[]{new Ilv3DVector(dArray[0], dArray2[0], d2), new Ilv3DVector(dArray[1], dArray2[1], d2), new Ilv3DVector(dArray[2], dArray2[2], d2), new Ilv3DVector(dArray[3], dArray2[3], d2), new Ilv3DVector(dArray[0], dArray2[0], d3), new Ilv3DVector(dArray[1], dArray2[1], d3), new Ilv3DVector(dArray[2], dArray2[2], d3), new Ilv3DVector(dArray[3], dArray2[3], d3)};
        this.setVertices(ilv3DVectorArray, null);
        IlvPolyhedron.Face[] faceArray = new IlvPolyhedron.Face[]{new IlvPolyhedron.Face(this, new int[]{0, 4, 5, 1}), new IlvPolyhedron.Face(this, new int[]{2, 6, 7, 3}), new IlvPolyhedron.Face(this, new int[]{2, 1, 5, 6}), new IlvPolyhedron.Face(this, new int[]{3, 0, 4, 7}), new IlvPolyhedron.Face(this, new int[]{0, 1, 2, 3})};
        this.setFaces(faceArray);
    }

    public void setFaceMask(int n2) {
        this.e().e = (n2 & 1) == 0;
        this.f().e = (n2 & 2) == 0;
    }

    public final IlvChart3DArea setGeometry(double[] dArray, double[] dArray2, double[] dArray3, int n2) {
        this.dataIdx = n2;
        Ilv3DVector[] ilv3DVectorArray = this.getVertices();
        double d2 = dArray3[0];
        double d3 = dArray3[1];
        ilv3DVectorArray[0].set(dArray[0], dArray2[0], d2);
        ilv3DVectorArray[1].set(dArray[1], dArray2[1], d2);
        ilv3DVectorArray[2].set(dArray[2], dArray2[2], d2);
        ilv3DVectorArray[3].set(dArray[3], dArray2[3], d2);
        ilv3DVectorArray[4].set(dArray[0], dArray2[0], d3);
        ilv3DVectorArray[5].set(dArray[1], dArray2[1], d3);
        ilv3DVectorArray[6].set(dArray[2], dArray2[2], d3);
        ilv3DVectorArray[7].set(dArray[3], dArray2[3], d3);
        this.updateGeometry();
        this.applyTransform(this.getScene().getTransform(), 1);
        return this;
    }

    protected void computeCenter() {
        super.computeCenter();
        Ilv3DVector[] ilv3DVectorArray = this.getVertices();
        this.a = this.vtx[0].equals(this.vtx[3]) && this.vtx[1].equals(this.vtx[2]) || this.vtx[0].equals(this.vtx[1]) && this.vtx[2].equals(this.vtx[3]);
    }

    protected Ilv3DVector computeFaceNormal(IlvPolyhedron.Face face) {
        if (this.a) {
            return this.a(face, null);
        }
        return super.computeFaceNormal(face);
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        Ilv3DVector ilv3DVector = this.a();
        return new Point(IlvGraphicUtil.toInt(ilv3DVector.x), IlvGraphicUtil.toInt(ilv3DVector.y));
    }

    final Ilv3DVector a() {
        return this.d().getCenter(true);
    }

    final IlvPolyhedron.Face b() {
        return this.getFace(2);
    }

    final IlvPolyhedron.Face c() {
        return this.getFace(3);
    }

    final IlvPolyhedron.Face d() {
        return this.getFace(4);
    }

    final IlvPolyhedron.Face e() {
        return this.getFace(0);
    }

    final IlvPolyhedron.Face f() {
        return this.getFace(1);
    }
}

