/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.util;

import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.util.internal.IlvIntArrayPool;
import ilog.views.chart.util.internal.IlvMathUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public final class IlvGraphicUtil {
    private static final FontRenderContext a = new FontRenderContext(null, false, false);
    private static final FontRenderContext b = new FontRenderContext(null, true, false);
    private static final FontRenderContext c = new FontRenderContext(null, false, true);
    private static final FontRenderContext d = new FontRenderContext(null, true, true);
    private static final double e = 1.0E-6;
    private static Rectangle f = new Rectangle();
    private static Rectangle g = new Rectangle();
    private static Rectangle h = new Rectangle();
    private static Insets i = new Insets(0, 0, 0, 0);

    private IlvGraphicUtil() {
    }

    public static boolean startAntiAliasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (object == RenderingHints.VALUE_ANTIALIAS_OFF) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            return false;
        }
        return true;
    }

    public static void stopAntiAliasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static boolean startTextAntiAliasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        if (object == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            return false;
        }
        return true;
    }

    public static void stopTextAntiAliasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public static Rectangle applyInsets(Rectangle rectangle, Insets insets) {
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static int compareInsets(Insets insets, Insets insets2) {
        if (insets.left > insets2.left || insets.right > insets2.right || insets.top > insets2.top || insets.bottom > insets2.bottom) {
            return 1;
        }
        if (insets.equals(insets2)) {
            return 0;
        }
        return -1;
    }

    public static boolean isEmpty(Insets insets) {
        return insets.left == 0 && insets.right == 0 && insets.top == 0 && insets.bottom == 0;
    }

    public static Insets mergeInsets(Insets insets, Insets insets2) {
        if (insets.left < insets2.left) {
            insets.left = insets2.left;
        }
        if (insets.right < insets2.right) {
            insets.right = insets2.right;
        }
        if (insets.top < insets2.top) {
            insets.top = insets2.top;
        }
        if (insets.bottom < insets2.bottom) {
            insets.bottom = insets2.bottom;
        }
        return insets;
    }

    public static final double pointAngle(double d2, double d3, double d4, double d5) {
        if (d2 == d4) {
            return d3 < d5 ? 4.71238898038469 : 1.5707963267948966;
        }
        if (d3 == d5) {
            return d2 < d4 ? 0.0 : Math.PI;
        }
        return Math.atan2(d3 - d5, d4 - d2);
    }

    public static final double pointAngleDeg(double d2, double d3, double d4, double d5) {
        if (d2 == d4) {
            return d3 < d5 ? 270.0 : 90.0;
        }
        if (d3 == d5) {
            return d2 < d4 ? 0.0 : 180.0;
        }
        double d6 = Math.toDegrees(Math.atan2(d3 - d5, d4 - d2));
        if (d6 < 0.0) {
            d6 += 360.0;
        }
        return d6;
    }

    public static final void addToRect(Rectangle rectangle, int n2, int n3) {
        if (rectangle.isEmpty()) {
            rectangle.x = n2;
            rectangle.y = n3;
            rectangle.height = 1;
            rectangle.width = 1;
        } else {
            rectangle.add(n2, n3);
        }
    }

    public static final void addToRect(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.isEmpty()) {
            return;
        }
        if (rectangle.isEmpty()) {
            rectangle.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        } else {
            rectangle.add(rectangle2);
        }
    }

    public static final Rectangle2D addToRect(Rectangle2D rectangle2D, double d2, double d3) {
        if (rectangle2D.isEmpty()) {
            rectangle2D.setRect(d2, d3, 1.0, 1.0);
        } else {
            rectangle2D.add(d2, d3);
        }
        return rectangle2D;
    }

    public static final Rectangle2D addToRect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (!rectangle2D2.isEmpty()) {
            if (rectangle2D.isEmpty()) {
                rectangle2D.setRect(rectangle2D2);
            } else {
                rectangle2D.add(rectangle2D2);
            }
        }
        return rectangle2D;
    }

    public static final Rectangle toRectangle(Rectangle2D rectangle2D, Rectangle rectangle) {
        if (rectangle2D instanceof Rectangle) {
            return (Rectangle)rectangle2D;
        }
        if (rectangle == null) {
            rectangle = rectangle2D.getBounds();
        } else if (rectangle2D.isEmpty()) {
            rectangle.height = 0;
            rectangle.width = 0;
        } else {
            double d2 = Math.floor(rectangle2D.getX());
            double d3 = Math.floor(rectangle2D.getY());
            double d4 = Math.ceil(rectangle2D.getX() + rectangle2D.getWidth());
            double d5 = Math.ceil(rectangle2D.getY() + rectangle2D.getHeight());
            rectangle.setBounds((int)d2, (int)d3, (int)(d4 - d2), (int)(d5 - d3));
        }
        return rectangle;
    }

    public static Rectangle2D grow(Rectangle2D rectangle2D, double d2, double d3) {
        rectangle2D.setRect(rectangle2D.getX() - d2, rectangle2D.getY() - d3, rectangle2D.getWidth() + d2 * 2.0, rectangle2D.getHeight() + d3 * 2.0);
        return rectangle2D;
    }

    public static int doubleToInts(int n2, double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, boolean bl) {
        if (bl) {
            int n3 = 1;
            nArray[0] = IlvGraphicUtil.toInt(dArray[0]);
            nArray2[0] = IlvGraphicUtil.toInt(dArray2[0]);
            for (int i2 = 1; i2 < n2; ++i2) {
                int n4 = IlvGraphicUtil.toInt(dArray[i2]);
                int n5 = IlvGraphicUtil.toInt(dArray2[i2]);
                if (n4 == nArray[n3 - 1] && n5 == nArray2[n3 - 1]) continue;
                nArray[n3] = n4;
                nArray2[n3++] = n5;
            }
            return n3;
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            nArray[i3] = IlvGraphicUtil.toInt(dArray[i3]);
            nArray2[i3] = IlvGraphicUtil.toInt(dArray2[i3]);
        }
        return n2;
    }

    public static final int toInt(double d2) {
        return (int)(d2 < 0.0 ? Math.floor(d2 - 1.0E-6) : (double)((int)(d2 + 1.0E-6)));
    }

    public static Polygon createPolygon(double[] dArray, double[] dArray2, int n2) {
        int[] nArray = IlvIntArrayPool.take(n2);
        int[] nArray2 = IlvIntArrayPool.take(n2);
        n2 = IlvGraphicUtil.doubleToInts(n2, dArray, dArray2, nArray, nArray2, true);
        Polygon polygon = new Polygon(nArray, nArray2, n2);
        IlvIntArrayPool.release(nArray);
        IlvIntArrayPool.release(nArray2);
        return polygon;
    }

    public static Rectangle transform(Rectangle rectangle, AffineTransform affineTransform) {
        return IlvGraphicUtil.toRectangle(IlvGraphicUtil.transform(rectangle, affineTransform), rectangle);
    }

    public static Rectangle2D transform(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        double[] dArray;
        dArray = new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY(), dArray[2], rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D.getX(), dArray[5]};
        affineTransform.transform(dArray, 0, dArray, 0, 4);
        rectangle2D.setRect(0.0, 0.0, 0.0, 0.0);
        IlvGraphicUtil.addToRect(rectangle2D, dArray[0], dArray[1]);
        IlvGraphicUtil.addToRect(rectangle2D, dArray[2], dArray[3]);
        IlvGraphicUtil.addToRect(rectangle2D, dArray[4], dArray[5]);
        IlvGraphicUtil.addToRect(rectangle2D, dArray[6], dArray[7]);
        return rectangle2D;
    }

    IlvDoublePoint a(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, IlvDoublePoint ilvDoublePoint) {
        double d10 = ((d3 - d7) * (d8 - d6) - (d2 - d6) * (d9 - d7)) / ((d4 - d2) * (d9 - d7) - (d5 - d3) * (d8 - d6));
        if (ilvDoublePoint == null) {
            ilvDoublePoint = new IlvDoublePoint(d2 + d10 * (d4 - d2), d3 + d10 * (d5 - d3));
        } else {
            ilvDoublePoint.x = d2 + d10 * (d4 - d2);
            ilvDoublePoint.y = d3 + d10 * (d5 - d3);
        }
        return ilvDoublePoint;
    }

    public static double computeYSeg(double d2, double d3, double d4, double d5, double d6) {
        if (d2 == d4) {
            return d3;
        }
        double d7 = (d5 - d3) / (d4 - d2);
        return d7 * (d6 - d4) + d5;
    }

    public static double computeXSeg(double d2, double d3, double d4, double d5, double d6) {
        if (d3 == d5) {
            return d2;
        }
        double d7 = (d4 - d2) / (d5 - d3);
        return d7 * (d6 - d5) + d4;
    }

    public static IlvDoublePoint computeTextLocation(IlvDoublePoint ilvDoublePoint, double d2, int n2, double d3, double d4) {
        if (Math.abs(d2 = IlvMathUtil.mod360(d2)) < 5.0 || Math.abs(d2 - 360.0) < 5.0) {
            ilvDoublePoint.x += d3 / 2.0 + (double)n2;
        } else if (Math.abs(d2 - 90.0) < 5.0) {
            ilvDoublePoint.y -= d4 / 2.0 + (double)n2;
        } else if (Math.abs(d2 - 180.0) < 5.0) {
            ilvDoublePoint.x -= d3 / 2.0 + (double)n2;
        } else if (Math.abs(d2 - 270.0) < 5.0) {
            ilvDoublePoint.y += d4 / 2.0 + (double)n2;
        } else {
            double d5 = IlvMathUtil.toRadians(d2);
            double d6 = Math.cos(d5);
            double d7 = Math.sin(d5);
            if (d2 < 90.0) {
                ilvDoublePoint.x += d3 / 2.0 + d6 * (double)n2;
                ilvDoublePoint.y -= (d4 / 2.0 + (double)n2) * d7;
            } else if (d2 < 180.0) {
                ilvDoublePoint.x -= d3 / 2.0 - d6 * (double)n2;
                ilvDoublePoint.y -= (d4 / 2.0 + (double)n2) * d7;
            } else if (d2 < 270.0) {
                ilvDoublePoint.x -= d3 / 2.0 - d6 * (double)n2;
                ilvDoublePoint.y -= (d4 / 2.0 + (double)n2) * d7;
            } else {
                ilvDoublePoint.x += d3 / 2.0 + d6 * (double)n2;
                ilvDoublePoint.y -= (d4 / 2.0 + (double)n2) * d7;
            }
        }
        return ilvDoublePoint;
    }

    public static final FontRenderContext getFRC(boolean bl, boolean bl2) {
        return bl ? (bl2 ? d : b) : (bl2 ? c : a);
    }

    public static void paintJLabel(Graphics graphics, JLabel jLabel, Rectangle rectangle) {
        Icon icon;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jLabel.getInsets(i);
        IlvGraphicUtil.h.x = insets.left + rectangle.x;
        IlvGraphicUtil.h.y = insets.top + rectangle.y;
        IlvGraphicUtil.h.width = rectangle.width - (insets.left + insets.right);
        IlvGraphicUtil.h.height = rectangle.height - (insets.top + insets.bottom);
        IlvGraphicUtil.f.height = 0;
        IlvGraphicUtil.f.width = 0;
        IlvGraphicUtil.f.y = 0;
        IlvGraphicUtil.f.x = 0;
        IlvGraphicUtil.g.height = 0;
        IlvGraphicUtil.g.width = 0;
        IlvGraphicUtil.g.y = 0;
        IlvGraphicUtil.g.x = 0;
        String string2 = SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), h, f, g, jLabel.getIconTextGap());
        if (icon != null) {
            icon.paintIcon(jLabel, graphics, IlvGraphicUtil.f.x, IlvGraphicUtil.f.y);
        }
        if (string != null) {
            View view = (View)jLabel.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, g);
            } else {
                int n2 = IlvGraphicUtil.g.x;
                int n3 = IlvGraphicUtil.g.y + fontMetrics.getAscent();
                if (jLabel.isEnabled()) {
                    IlvGraphicUtil.paintEnabledText(jLabel, graphics, string2, n2, n3);
                } else {
                    IlvGraphicUtil.paintDisabledText(jLabel, graphics, string2, n2, n3);
                }
            }
        }
    }

    protected static void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n2, int n3) {
        int n4 = jLabel.getDisplayedMnemonicIndex();
        graphics.setColor(jLabel.getForeground());
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, n2, n3);
    }

    protected static void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n2, int n3) {
        int n4 = jLabel.getDisplayedMnemonicIndex();
        Color color = jLabel.getBackground();
        graphics.setColor(color.brighter());
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, n2 + 1, n3 + 1);
        graphics.setColor(color.darker());
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, n2, n3);
    }
}

