/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.event.DataSetContentsEvent;
import ilog.views.chart.event.DataSetPropertyEvent;
import ilog.views.chart.renderer.IlvVirtualDataSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;

class IlvSumDataSet
extends IlvVirtualDataSet
implements Serializable {
    transient IlvDataPoints a = null;

    public IlvSumDataSet(IlvDataSet ilvDataSet, IlvDataSet ilvDataSet2) {
        this.setMaxDataSetCount(2);
        this.addDataSet(ilvDataSet);
        this.addDataSet(ilvDataSet2);
        this.h();
    }

    public String getName() {
        return this.getDataSetCount() > 0 ? this.getDataSet(this.getDataSetCount() - 1).getName() : null;
    }

    public boolean isXValuesSorted() {
        return true;
    }

    public Double getUndefValue() {
        if (this.getDataSetCount() > 0) {
            return this.getDataSet(this.getDataSetCount() - 1).getUndefValue();
        }
        return null;
    }

    public void map(IlvDataSetPoint ilvDataSetPoint) {
        ilvDataSetPoint.dataSet = this;
        ilvDataSetPoint.index = -1;
    }

    public void unmap(IlvDataSetPoint ilvDataSetPoint) {
        ilvDataSetPoint.dataSet = this.getDataSet(this.getDataSetCount() - 1);
        ilvDataSetPoint.index = this.a == null ? -1 : this.a.getDataIndex(ilvDataSetPoint.index);
    }

    public void unmap(IlvDataSetPoint ilvDataSetPoint, IlvDoublePoint ilvDoublePoint) {
        this.unmap(ilvDataSetPoint);
    }

    protected void dataSetContentsChanged(DataSetContentsEvent dataSetContentsEvent) {
        if (dataSetContentsEvent.getType() != 1 && dataSetContentsEvent.getType() != 5) {
            this.h();
            this.fireDataSetContentsEvent(new DataSetContentsEvent(this));
        }
    }

    protected void dataSetPropertyChanged(DataSetPropertyEvent dataSetPropertyEvent) {
        if (dataSetPropertyEvent.getDataSet() == this.getDataSet(this.getDataSetCount() - 1)) {
            this.fireDataSetPropertyEvent(new DataSetPropertyEvent(this, dataSetPropertyEvent));
        }
    }

    public double getXData(int n2) {
        return this.a.getX(n2);
    }

    public double getYData(int n2) {
        return this.a.getY(n2);
    }

    private void h() {
        if (this.getDataSetCount() == 2) {
            IlvDataSet ilvDataSet = this.getDataSet(0);
            IlvDataSet ilvDataSet2 = this.getDataSet(1);
            this.a = !ilvDataSet.isXValuesSorted() || !ilvDataSet2.isXValuesSorted() ? null : this.a(ilvDataSet.getData(), ilvDataSet2.getData());
        } else {
            this.a = this.getDataSetCount() == 1 ? this.getDataSet(0).getData() : null;
        }
        this.setLimitsValid(false);
        this.updateDataCount();
    }

    private IlvDataPoints a(IlvDataPoints ilvDataPoints, IlvDataPoints ilvDataPoints2) {
        int n2 = ilvDataPoints == null ? 0 : ilvDataPoints.size();
        int n3 = ilvDataPoints2 == null ? 0 : ilvDataPoints2.size();
        int n4 = n2 + n3;
        int n5 = 0;
        int n6 = 0;
        IlvDataPoints ilvDataPoints3 = new IlvDataPoints(this, n2 + n3);
        while (n5 < n2 && n6 < n3) {
            if (ilvDataPoints.getX(n5) == ilvDataPoints2.getX(n6)) {
                ilvDataPoints3.add(ilvDataPoints2.getX(n6), this.computeYValue(ilvDataPoints2.getX(n6), ilvDataPoints2.getY(n6), ilvDataPoints, ++n5), n6);
                ++n6;
                continue;
            }
            if (ilvDataPoints.getX(n5) < ilvDataPoints2.getX(n6)) {
                ilvDataPoints3.add(ilvDataPoints.getX(n5), this.computeYValue(ilvDataPoints.getX(n5), ilvDataPoints.getY(n5), ilvDataPoints2, n6), n6 - 1);
                ++n5;
                continue;
            }
            ilvDataPoints3.add(ilvDataPoints2.getX(n6), this.computeYValue(ilvDataPoints2.getX(n6), ilvDataPoints2.getY(n6), ilvDataPoints, n5), n6);
            ++n6;
        }
        while (n5 < n2) {
            ilvDataPoints3.add(ilvDataPoints.getX(n5), ilvDataPoints.getY(n5), n6 - 1);
            ++n5;
        }
        while (n6 < n3) {
            ilvDataPoints3.add(ilvDataPoints2.getX(n6), ilvDataPoints2.getY(n6), n6);
            ++n6;
        }
        return ilvDataPoints3;
    }

    protected double computeYValue(double d2, double d3, IlvDoublePoints ilvDoublePoints, int n2) {
        return n2 > 0 ? d3 + ilvDoublePoints.getY(n2 - 1) : d3;
    }

    protected int computeDataCount() {
        return this.a != null ? this.a.size() : 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.registerValidation(new ObjectInputValidation(){

            public void validateObject() {
                IlvSumDataSet.this.h();
            }
        }, 0);
    }
}

