/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.interactor;

import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.util.IlvChartUtil;
import ilog.views.util.IlvImageUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;

public class IlvChartZoomInteractor
extends IlvChartInteractor {
    static final int a = 5;
    private static Cursor b;
    private static Cursor c;
    private transient IlvDoublePoints d;
    private transient IlvDoublePoints e;
    private transient int f;
    private transient int g;
    private transient boolean h;
    private transient boolean i;
    private transient IlvDataWindow j;
    private transient Rectangle k;
    private int l;
    private int m = 10;
    private boolean n = true;
    private boolean o = false;
    private boolean p = true;

    public IlvChartZoomInteractor() {
        this(0, 16, 17);
    }

    public IlvChartZoomInteractor(int n2, int n3) {
        this(0, n2, n3);
    }

    public IlvChartZoomInteractor(int n2, int n3, int n4) {
        super(n2, n3);
        this.b();
        this.enableEvents(56L);
        this.l = n4;
        this.setXORGhost(true);
        this.c();
    }

    private void b() {
        this.d = new IlvDoublePoints(0.0, 0.0);
        this.e = new IlvDoublePoints(0.0, 0.0);
        this.f = 0;
        this.g = 0;
        this.h = false;
        this.i = false;
        this.j = null;
        this.k = null;
    }

    private void c() {
        if (b == null || c == null) {
            Image image;
            String string;
            Dimension dimension = null;
            try {
                dimension = Toolkit.getDefaultToolkit().getBestCursorSize(32, 32);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dimension == null || (dimension.width != 32 || dimension.height != 32) && (dimension.width != 64 || dimension.height != 64)) {
                b = Cursor.getPredefinedCursor(1);
                c = Cursor.getPredefinedCursor(1);
                return;
            }
            try {
                string = "zoomin_" + dimension.width + ".gif";
                image = IlvImageUtil.loadImageFromFile(IlvChartZoomInteractor.class, string);
                b = IlvChartUtil.createCursor(image, new Point(4, 5), "ZoomIn", 1);
            }
            catch (IOException iOException) {
                b = Cursor.getPredefinedCursor(1);
            }
            try {
                string = "zoomout_" + dimension.width + ".gif";
                image = IlvImageUtil.loadImageFromFile(IlvChartZoomInteractor.class, string);
                c = IlvChartUtil.createCursor(image, new Point(4, 5), "ZoomOut", 1);
            }
            catch (IOException iOException) {
                c = Cursor.getPredefinedCursor(1);
            }
        }
    }

    public void setZoomOutEventMask(int n2) {
        this.l = n2;
    }

    public final int getZoomOutEventMask() {
        return this.l;
    }

    public void setZoomInEventMask(int n2) {
        this.setEventMask(n2);
    }

    public int getZoomInEventMask() {
        return this.getEventMask();
    }

    public final int getAnimationStep() {
        return this.m;
    }

    public void setAnimationStep(int n2) {
        this.m = n2;
    }

    public final boolean isXZoomAllowed() {
        return this.n;
    }

    public void setXZoomAllowed(boolean bl) {
        this.n = bl;
    }

    public final boolean isYZoomAllowed() {
        return this.o;
    }

    public void setYZoomAllowed(boolean bl) {
        this.o = bl;
    }

    public void setZoomOutAllowed(boolean bl) {
        this.p = bl;
    }

    public boolean isZoomOutAllowed() {
        return this.p;
    }

    protected final IlvDataWindow getDraggedWindow() {
        return new IlvDataWindow(this.j);
    }

    protected IlvDataWindow getZoomedDataWindow() {
        IlvDataWindow ilvDataWindow = this.getDraggedWindow();
        if (this.i) {
            IlvDataInterval ilvDataInterval = this.getXAxis().getVisibleRange();
            IlvDataInterval ilvDataInterval2 = this.getYAxis().getVisibleRange();
            double d2 = this.j.getXMin();
            double d3 = this.j.getXMax();
            double d4 = this.j.getYMin();
            double d5 = this.j.getYMax();
            IlvDataInterval ilvDataInterval3 = ilvDataWindow.xRange;
            IlvDataInterval ilvDataInterval4 = ilvDataWindow.yRange;
            double d6 = ilvDataInterval.getLength() / (d3 - d2);
            double d7 = ilvDataInterval.max - (d3 - ilvDataInterval.min) * d6;
            double d8 = ilvDataInterval.min + (ilvDataInterval.max - d2) * d6;
            ilvDataInterval3.set(d7, d8);
            ilvDataInterval3.intersection(this.getXAxis().getDataRange());
            d6 = ilvDataInterval2.getLength() / (d5 - d4);
            d7 = ilvDataInterval2.max - (d5 - ilvDataInterval2.min) * d6;
            d8 = ilvDataInterval2.min + (ilvDataInterval2.max - d4) * d6;
            ilvDataInterval4.set(d7, d8);
            ilvDataInterval4.intersection(this.getYAxis().getDataRange());
        }
        return ilvDataWindow;
    }

    private boolean a(int n2) {
        int n3 = this.getZoomInEventMask();
        return n3 != 0 && (n2 & n3) == n3 && (n2 & ~n3) == 0;
    }

    private boolean b(int n2) {
        int n3 = this.getZoomOutEventMask();
        return n3 != 0 && (n2 & n3) == n3 && (n2 & ~n3) == 0;
    }

    protected boolean isValid(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiers();
        return this.a(n2) || this.b(n2) && this.isZoomOutAllowed();
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.isInOperation() || !this.isValid(mouseEvent)) break;
                if (this.b(mouseEvent.getModifiers())) {
                    this.i = true;
                }
                this.f = mouseEvent.getX();
                this.g = mouseEvent.getY();
                this.d.set(0, mouseEvent.getX(), mouseEvent.getY());
                this.getChart().toData(this.d, this.getYAxisIndex());
                this.e.set(0, mouseEvent.getX(), mouseEvent.getY());
                this.getChart().toData(this.e, this.getYAxisIndex());
                if (!this.isValidStartPoint(this.d.getX(0), this.d.getY(0))) break;
                this.startOperation(mouseEvent);
                this.d();
                this.a(this.j);
                this.drawGhost();
                mouseEvent.consume();
                break;
            }
            case 502: {
                if (!this.isInOperation()) break;
                this.e.set(0, mouseEvent.getX(), mouseEvent.getY());
                this.getChart().toData(this.e, this.getYAxisIndex());
                this.d();
                this.a(this.j);
                this.drawGhost();
                if (Math.abs(mouseEvent.getX() - this.f) > 5 || Math.abs(mouseEvent.getY() - this.g) > 5) {
                    this.doIt();
                }
                this.endOperation(mouseEvent);
                mouseEvent.consume();
                break;
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506 && this.isInOperation()) {
            this.drawGhost();
            this.e.set(0, mouseEvent.getX(), mouseEvent.getY());
            this.getChart().toData(this.e, this.getYAxisIndex());
            this.d();
            this.a(this.j);
            this.drawGhost();
            mouseEvent.consume();
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            if (this.isInOperation()) {
                this.drawGhost();
            }
            this.abort();
            keyEvent.consume();
        }
    }

    protected void abort() {
        super.abort();
        this.setAllowDrawGhost(false);
        this.i = false;
        this.j.xRange.empty();
        this.j.yRange.empty();
        this.setCursor(null);
    }

    protected void startOperation(MouseEvent mouseEvent) {
        super.startOperation(mouseEvent);
        this.setAllowDrawGhost(true);
        if (this.i) {
            this.setCursor(this.getZoomOutCursor());
        } else {
            this.setCursor(this.getZoomInCursor());
        }
    }

    protected void endOperation(MouseEvent mouseEvent) {
        super.endOperation(mouseEvent);
        this.setAllowDrawGhost(false);
        this.i = false;
        this.j.xRange.empty();
        this.j.yRange.empty();
        this.setCursor(null);
    }

    protected boolean isValidStartPoint(double d2, double d3) {
        return true;
    }

    private void a(IlvDataWindow ilvDataWindow) {
        IlvDataWindow ilvDataWindow2 = this.getCoordinateSystem().getVisibleWindow();
        if (!this.o && !ilvDataWindow2.yRange.equals(ilvDataWindow.yRange)) {
            ilvDataWindow.yRange.min = ilvDataWindow2.getYMin();
            ilvDataWindow.yRange.max = ilvDataWindow2.getYMax();
        }
        if (!this.n && !ilvDataWindow2.xRange.equals(ilvDataWindow.xRange)) {
            ilvDataWindow.xRange.min = ilvDataWindow2.getXMin();
            ilvDataWindow.xRange.max = ilvDataWindow2.getXMax();
        }
        this.validate(ilvDataWindow);
    }

    protected void validate(IlvDataWindow ilvDataWindow) {
    }

    protected boolean isZoomingOut() {
        return this.i;
    }

    private void d() {
        if (this.j == null) {
            this.j = new IlvDataWindow();
        }
        double d2 = Math.min(this.d.getX(0), this.e.getX(0));
        double d3 = Math.max(this.d.getX(0), this.e.getX(0));
        double d4 = Math.min(this.d.getY(0), this.e.getY(0));
        double d5 = Math.max(this.d.getY(0), this.e.getY(0));
        this.j.xRange.set(d2, d3);
        this.j.yRange.set(d4, d5);
    }

    private Shape e() {
        IlvDataWindow ilvDataWindow = this.getCoordinateSystem().getVisibleWindow();
        this.j.intersection(ilvDataWindow);
        Shape shape = this.getChart().getProjector().getShape(this.j, this.getChart().getProjectorRect(), this.getCoordinateSystem());
        return shape;
    }

    protected Rectangle getGhostBounds() {
        Rectangle rectangle = this.e().getBounds();
        return rectangle;
    }

    protected void drawGhost(Graphics graphics) {
        if (this.j.isEmpty()) {
            return;
        }
        Shape shape = this.e();
        this.k = shape.getBounds();
        IlvStyle ilvStyle = null;
        ilvStyle = this.i ? new IlvStyle(1.0f, (Paint)this.getGhostColor()) : new IlvStyle(this.getGhostColor());
        ilvStyle.renderShape(graphics, shape);
    }

    protected void doIt() {
        IlvDataWindow ilvDataWindow = this.getZoomedDataWindow();
        IlvDataInterval ilvDataInterval = this.getXAxis().getVisibleRange();
        IlvDataInterval ilvDataInterval2 = this.getYAxis().getVisibleRange();
        IlvDataInterval ilvDataInterval3 = ilvDataWindow.xRange;
        IlvDataInterval ilvDataInterval4 = ilvDataWindow.yRange;
        if (this.m != 0) {
            Cursor cursor = this.setCursor(null);
            this.getChart().getChartArea().setDirectRedrawEnabled(true);
            this.getXAxis().setAdjusting(true);
            this.getYAxis().setAdjusting(true);
            this.setAllowDrawGhost(false);
            int n2 = this.m + 1;
            double d2 = (ilvDataInterval3.min - ilvDataInterval.min) / (double)n2;
            double d3 = (ilvDataInterval3.max - ilvDataInterval.max) / (double)n2;
            double d4 = (ilvDataInterval4.min - ilvDataInterval2.min) / (double)n2;
            double d5 = (ilvDataInterval4.max - ilvDataInterval2.max) / (double)n2;
            IlvDataWindow ilvDataWindow2 = new IlvDataWindow(ilvDataInterval, ilvDataInterval2);
            float f2 = 10.0f;
            int n3 = (int)(1.0 / (double)f2 * 1000.0);
            for (int i2 = 0; i2 < n2; ++i2) {
                ilvDataWindow2.xRange.setMin(ilvDataWindow2.getXMin() + d2);
                ilvDataWindow2.xRange.setMax(ilvDataWindow2.getXMax() + d3);
                ilvDataWindow2.yRange.setMin(ilvDataWindow2.getYMin() + d4);
                ilvDataWindow2.yRange.setMax(ilvDataWindow2.getYMax() + d5);
                this.getChart().zoom(ilvDataWindow2, this.getYAxisIndex());
            }
            this.setAllowDrawGhost(true);
            this.getChart().getChartArea().setDirectRedrawEnabled(false);
            this.getChart().zoom(ilvDataWindow, this.getYAxisIndex());
            this.getXAxis().setAdjusting(false);
            this.getYAxis().setAdjusting(false);
            this.setCursor(cursor);
        } else {
            this.getChart().zoom(ilvDataWindow, this.getYAxisIndex());
        }
    }

    protected Cursor getZoomOutCursor() {
        return c;
    }

    protected Cursor getZoomInCursor() {
        return b;
    }

    public boolean has3DSupport() {
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.b();
    }

    static {
        IlvChartInteractor.register("Zoom", IlvChartZoomInteractor.class);
        b = null;
        c = null;
    }
}

