/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.interactor;

import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.event.ChartInteractionEvent;
import ilog.views.chart.interactor.IlvChartDataInteractor;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class IlvChartPickInteractor
extends IlvChartDataInteractor {
    private transient IlvDisplayPoint a;

    public IlvChartPickInteractor() {
        this(0, 16);
    }

    public IlvChartPickInteractor(int n2, int n3) {
        super(n2, n3);
        this.enableEvents(24L);
        this.setPickingMode(1);
    }

    protected boolean isPickingEvent(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 502;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && (mouseEvent.getModifiers() & this.getEventMask()) == this.getEventMask() && (mouseEvent.getModifiers() & ~this.getEventMask()) == 0) {
            this.a = this.pickData(this.createDataPicker(mouseEvent));
            if (this.a != null) {
                this.startOperation(mouseEvent);
                if (this.isPickingEvent(mouseEvent)) {
                    this.pick(this.a);
                    this.endOperation(mouseEvent);
                }
                mouseEvent.consume();
            }
        } else if (this.a != null && this.isPickingEvent(mouseEvent)) {
            this.pick(this.a);
            this.endOperation(mouseEvent);
            mouseEvent.consume();
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            this.abort();
            keyEvent.consume();
        }
    }

    protected void pick(IlvDisplayPoint ilvDisplayPoint) {
        IlvDisplayPoint ilvDisplayPoint2 = new IlvDisplayPoint(ilvDisplayPoint.getRenderer(), ilvDisplayPoint.getDataSet(), ilvDisplayPoint.getIndex(), ilvDisplayPoint.getXCoord(), ilvDisplayPoint.getYCoord());
        this.fireChartInteractionEvent(new ChartInteractionEvent(this, ilvDisplayPoint2));
    }

    protected void abort() {
        super.abort();
        this.a = null;
        this.setCursor(null);
    }

    protected void endOperation(MouseEvent mouseEvent) {
        super.endOperation(mouseEvent);
        this.a = null;
        this.setCursor(null);
    }

    protected void startOperation(MouseEvent mouseEvent) {
        super.startOperation(mouseEvent);
        this.setCursor(this.getCursor());
    }

    protected Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    static {
        IlvChartInteractor.register("Pick", IlvChartPickInteractor.class);
    }
}

