/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.interactor;

import ilog.views.chart.IlvChart3DView;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.util.IlvChartUtil;
import ilog.views.util.IlvImageUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;

public class IlvChart3DViewInteractor
extends IlvChartInteractor {
    public static final int NONE = 0;
    public static final int ROTATE = 1;
    public static final int ZOOM = 2;
    private static Cursor a;
    private static Cursor b;
    private transient Point c;
    private transient Point d;
    private transient int e;
    private int f;

    public IlvChart3DViewInteractor() {
        this(18, 17);
    }

    public IlvChart3DViewInteractor(int n2, int n3) {
        super(0, n2);
        this.c();
        this.enableEvents(56L);
        this.f = n3;
        this.setXORGhost(false);
        this.b();
    }

    private void b() {
        if (a == null || b == null) {
            Image image;
            String string;
            Dimension dimension = null;
            try {
                dimension = Toolkit.getDefaultToolkit().getBestCursorSize(32, 32);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dimension == null) {
                a = Cursor.getPredefinedCursor(13);
                b = Cursor.getPredefinedCursor(8);
                return;
            }
            Point point = dimension.height == 16 ? new Point(8, 8) : new Point(11, 11);
            try {
                string = "rotate3d_" + dimension.width + ".gif";
                image = IlvImageUtil.loadImageFromFile(this.getClass(), string);
                a = IlvChartUtil.createCursor(image, point, "Rotate3D", 13);
            }
            catch (IOException iOException) {
                a = Cursor.getPredefinedCursor(13);
            }
            try {
                string = "zoom3d_" + dimension.width + ".gif";
                image = IlvImageUtil.loadImageFromFile(this.getClass(), string);
                b = IlvChartUtil.createCursor(image, point, "Zoom3D", 8);
            }
            catch (IOException iOException) {
                b = Cursor.getPredefinedCursor(8);
            }
        }
    }

    private void c() {
        this.c = new Point();
        this.d = new Point();
    }

    public void setZoomEventMask(int n2) {
        this.f = n2;
    }

    public final int getZoomEventMask() {
        return this.f;
    }

    public void setAngleEventMask(int n2) {
        this.setEventMask(n2);
    }

    public final int getAngleEventMask() {
        return this.getEventMask();
    }

    private boolean a(int n2) {
        int n3 = this.getAngleEventMask();
        return n3 != 0 && (n2 & n3) == n3 && (n2 & ~n3) == 0;
    }

    private boolean b(int n2) {
        int n3 = this.getZoomEventMask();
        return n3 != 0 && (n2 & n3) == n3 && (n2 & ~n3) == 0;
    }

    public boolean isHandling(int n2, int n3) {
        if (this.getChart() != null && this.getChart().is3D()) {
            return this.getChart().getChartArea().getDrawRect().contains(n2, n3);
        }
        return false;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.a(mouseEvent.getModifiers())) {
                    this.e = 1;
                } else if (this.b(mouseEvent.getModifiers())) {
                    this.e = 2;
                } else {
                    return;
                }
                this.c.setLocation(mouseEvent.getX(), mouseEvent.getY());
                this.d.setLocation(mouseEvent.getX(), mouseEvent.getY());
                this.startOperation(mouseEvent);
                mouseEvent.consume();
                break;
            }
            case 502: {
                if (!this.isInOperation()) break;
                this.endOperation(mouseEvent);
                mouseEvent.consume();
                break;
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.isInOperation()) {
            switch (mouseEvent.getID()) {
                case 506: {
                    this.d.setLocation(mouseEvent.getX(), mouseEvent.getY());
                    this.adjustView(this.c, this.d, this.e);
                    this.c.setLocation(this.d);
                    mouseEvent.consume();
                    break;
                }
            }
        }
    }

    protected void adjustView(Point point, Point point2, int n2) {
        int n3 = point2.x - point.x;
        int n4 = point2.y - point.y;
        IlvChart3DView ilvChart3DView = this.getChart().get3DView();
        if (n2 == 1) {
            double d2 = ilvChart3DView.getElevation();
            double d3 = ilvChart3DView.getRotation();
            double d4 = (double)n4 / 4.0;
            double d5 = (double)n3 / 4.0;
            ilvChart3DView.setElevation(d2 - d4);
            ilvChart3DView.setRotation(d3 + d5);
        } else if (n2 == 2) {
            double d6 = (double)n4 / 1000.0;
            ilvChart3DView.setZoom(ilvChart3DView.getZoom() + d6);
        }
    }

    protected Cursor getCursor() {
        switch (this.getAction()) {
            case 1: {
                return a;
            }
            case 2: {
                return b;
            }
        }
        return null;
    }

    protected int getAction() {
        return this.e;
    }

    protected void startOperation(MouseEvent mouseEvent) {
        super.startOperation(mouseEvent);
        this.setCursor(this.getCursor());
    }

    protected void endOperation(MouseEvent mouseEvent) {
        super.endOperation(mouseEvent);
        this.setCursor(null);
    }

    protected void abort() {
        super.abort();
        this.setCursor(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.c();
    }

    static {
        IlvChartInteractor.register("3DView", IlvChart3DViewInteractor.class);
        a = null;
        b = null;
    }
}

