/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.graphic;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDecoration;
import ilog.views.chart.event.ChartAreaEvent;
import ilog.views.chart.event.ChartListener;
import ilog.views.util.IlvImageUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.net.URL;
import javax.swing.SwingConstants;

public class IlvImageDecoration
extends IlvChartDecoration
implements SwingConstants {
    public static final int ANCHORED = 0;
    public static final int TILED = 1;
    public static final int SCALED = 2;
    private transient Image a;
    private transient Point b;
    private transient TexturePaint c = null;
    private URL d = null;
    private int e;
    private int f;
    private ChartListener g = new AreaListener();

    public IlvImageDecoration(Image image) {
        this(image, 0, 0);
    }

    public IlvImageDecoration(Image image, int n2, int n3) {
        this.a(image, n2, n3);
    }

    public IlvImageDecoration(URL uRL, int n2, int n3) {
        this.d = uRL;
        Image image = IlvImageUtil.loadImage(uRL);
        IlvImageDecoration.a(image);
        this.a(image, n2, n3);
    }

    private void a(Image image, int n2, int n3) {
        IlvImageDecoration.a(n2);
        this.f = n2;
        if (n2 == 0) {
            IlvImageDecoration.b(n3);
        }
        this.e = n3;
        this.a = image;
        this.a();
    }

    private void a() {
        this.b = new Point(0, 0);
        if (this.a == null && this.d != null) {
            Image image = IlvImageUtil.loadImage(this.d);
            IlvImageDecoration.a(image);
            this.a = image;
        }
    }

    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
        super.chartConnected(ilvChart, ilvChart2);
        if (ilvChart != null) {
            ilvChart.removeChartListener(this.g);
        }
        if (ilvChart2 != null) {
            ilvChart2.addChartListener(this.g);
            this.c();
        }
    }

    private void b() {
        this.c();
    }

    public final URL getImageURL() {
        return this.d;
    }

    public int getMode() {
        return this.f;
    }

    public void setMode(int n2) {
        if (this.f == n2) {
            return;
        }
        IlvImageDecoration.a(n2);
        this.f = n2;
        this.c();
    }

    public int getAnchor() {
        return this.e;
    }

    public void setAnchor(int n2) {
        if (this.e == n2) {
            return;
        }
        IlvImageDecoration.b(n2);
        this.e = n2;
        this.c();
    }

    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        switch (this.f) {
            case 0: {
                graphics2D.drawImage(this.a, this.b.x, this.b.y, null);
                break;
            }
            case 1: 
            case 2: {
                Rectangle rectangle = this.getChart().getChartArea().getPlotRect();
                Paint paint = graphics2D.getPaint();
                graphics2D.setPaint(this.c);
                graphics2D.fillRect(this.b.x, this.b.y, rectangle.width, rectangle.height);
                graphics2D.setPaint(paint);
            }
        }
    }

    public Rectangle2D getBounds(Rectangle2D rectangle2D) {
        if (this.getChart() != null) {
            if (rectangle2D == null) {
                rectangle2D = new Rectangle();
            }
            switch (this.f) {
                case 0: {
                    rectangle2D.setRect(this.b.x, this.b.y, this.a.getWidth(null), this.a.getHeight(null));
                    break;
                }
                case 1: 
                case 2: {
                    rectangle2D.setRect(this.getChart().getChartArea().getPlotRect());
                }
            }
        } else {
            rectangle2D = super.getBounds(rectangle2D);
        }
        return rectangle2D;
    }

    private void c() {
        if (this.getChart() == null) {
            this.b.setLocation(0, 0);
            return;
        }
        int n2 = this.a.getWidth(null);
        int n3 = this.a.getHeight(null);
        Rectangle rectangle = this.getChart().getChartArea().getPlotRect();
        block0 : switch (this.f) {
            case 0: {
                switch (this.e) {
                    case 1: {
                        this.b.setLocation(rectangle.x + (rectangle.width - n2) / 2, rectangle.y);
                        break block0;
                    }
                    case 8: {
                        this.b.setLocation(rectangle.x, rectangle.y);
                        break block0;
                    }
                    case 7: {
                        this.b.setLocation(rectangle.x, rectangle.y + (rectangle.height - n3) / 2);
                        break block0;
                    }
                    case 6: {
                        this.b.setLocation(rectangle.x, rectangle.y + rectangle.height - n3);
                        break block0;
                    }
                    case 5: {
                        this.b.setLocation(rectangle.x + (rectangle.width - n2) / 2, rectangle.y + rectangle.height - n3);
                        break block0;
                    }
                    case 4: {
                        this.b.setLocation(rectangle.x + rectangle.width - n2, rectangle.y + rectangle.height - n3);
                        break block0;
                    }
                    case 3: {
                        this.b.setLocation(rectangle.x + rectangle.width - n2, rectangle.y + (rectangle.height - n3) / 2);
                        break block0;
                    }
                    case 2: {
                        this.b.setLocation(rectangle.x + rectangle.width - n2, rectangle.y);
                        break block0;
                    }
                }
                this.b.setLocation(rectangle.x + (rectangle.width - n2) / 2, rectangle.y + (rectangle.height - n3) / 2);
                break;
            }
            case 1: {
                this.b.setLocation(rectangle.x, rectangle.y);
                BufferedImage bufferedImage = new BufferedImage(this.a.getWidth(null), this.a.getHeight(null), 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.drawImage(this.a, 0, 0, null);
                graphics2D.dispose();
                this.c = new TexturePaint(bufferedImage, new Rectangle(this.b.x, this.b.y, bufferedImage.getWidth(), bufferedImage.getHeight()));
                break;
            }
            case 2: {
                this.b.setLocation(rectangle.x, rectangle.y);
                BufferedImage bufferedImage = new BufferedImage(this.a.getWidth(null), this.a.getHeight(null), 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.drawImage(this.a, 0, 0, null);
                graphics2D.dispose();
                this.c = new TexturePaint(bufferedImage, new Rectangle(this.b.x, this.b.y, rectangle.width, rectangle.height));
            }
        }
    }

    private static void a(Image image) {
        if (image == null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            throw new IllegalArgumentException("Invalid image");
        }
    }

    private static void a(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode: " + n2);
            }
        }
    }

    private static void b(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown anchor: " + n2);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.registerValidation(new ObjectInputValidation(){

            public void validateObject() throws InvalidObjectException {
                IlvImageDecoration.this.a();
                IlvImageDecoration.this.c();
            }
        }, 0);
        objectInputStream.defaultReadObject();
    }

    private class AreaListener
    implements ChartListener,
    Serializable {
        private AreaListener() {
        }

        public void chartAreaChanged(ChartAreaEvent chartAreaEvent) {
            IlvImageDecoration.this.b();
        }
    }
}

