/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.data;

import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.DataSetContentsEvent;
import ilog.views.chart.event.DataSetListener;
import ilog.views.chart.event.DataSetPropertyEvent;
import ilog.views.chart.event.IlvListenerList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class IlvAbstractDataSet
implements IlvDataSet,
Serializable {
    public static final Double DEFAULT_UNDEF_VALUE = new Double(Double.MIN_VALUE);
    private static final String a = "name";
    private transient IlvDataInterval b;
    private transient IlvDataInterval c;
    private IlvListenerList d = new IlvListenerList();
    private Double e;
    private Map f;
    private transient boolean g;
    private transient Batch h;

    protected IlvAbstractDataSet() {
        this.h();
    }

    private void h() {
        this.b = new IlvDataInterval();
        this.c = new IlvDataInterval();
        this.g = false;
    }

    public IlvDataInterval getXRange() {
        return this.getXRange(null);
    }

    public IlvDataInterval getYRange() {
        return this.getYRange(null);
    }

    public IlvDataInterval getXRange(IlvDataInterval ilvDataInterval) {
        if (ilvDataInterval == null) {
            return new IlvDataInterval(this.e());
        }
        IlvDataInterval ilvDataInterval2 = this.e();
        ilvDataInterval.setMin(ilvDataInterval2.getMin());
        ilvDataInterval.setMax(ilvDataInterval2.getMax());
        return ilvDataInterval;
    }

    public IlvDataInterval getYRange(IlvDataInterval ilvDataInterval) {
        if (ilvDataInterval == null) {
            return new IlvDataInterval(this.f());
        }
        IlvDataInterval ilvDataInterval2 = this.f();
        ilvDataInterval.setMin(ilvDataInterval2.getMin());
        ilvDataInterval.setMax(ilvDataInterval2.getMax());
        return ilvDataInterval;
    }

    final double a() {
        return this.e().getMin();
    }

    final double b() {
        return this.e().getMax();
    }

    final double c() {
        return this.f().getMin();
    }

    final double d() {
        return this.f().getMax();
    }

    IlvDataInterval e() {
        if (!this.g) {
            this.i();
        }
        return this.b;
    }

    IlvDataInterval f() {
        if (!this.g) {
            this.i();
        }
        return this.c;
    }

    protected void setLimitsValid(boolean bl) {
        this.g = bl;
    }

    final void g() {
        this.setLimitsValid(false);
    }

    private final void i() {
        this.setLimitsValid(true);
        this.computeLimits(this.b, this.c);
    }

    protected void computeLimits(IlvDataInterval ilvDataInterval, IlvDataInterval ilvDataInterval2) {
        int n2 = this.getDataCount();
        ilvDataInterval.empty();
        ilvDataInterval2.empty();
        Double d2 = this.getUndefValue();
        if (d2 != null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.getYData(i2) == d2.doubleValue()) continue;
                ilvDataInterval.add(this.getXData(i2));
                ilvDataInterval2.add(this.getYData(i2));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                ilvDataInterval.add(this.getXData(i3));
                ilvDataInterval2.add(this.getYData(i3));
            }
        }
    }

    public boolean isXValuesSorted() {
        return false;
    }

    public abstract int getDataCount();

    public abstract double getXData(int var1);

    public abstract double getYData(int var1);

    public void addData(double d2, double d3) {
    }

    public void setData(int n2, double d2, double d3) {
    }

    public boolean isEditable() {
        return false;
    }

    public void setUndefValue(Double d2) {
        Double d3 = this.e;
        this.e = d2;
        this.fireDataSetPropertyEvent(new DataSetPropertyEvent(this, "undefValue", (Object)d3, (Object)d2));
    }

    public Double getUndefValue() {
        return this.e;
    }

    public void startBatch() {
        if (this.h == null) {
            this.h = new Batch();
        }
    }

    public void endBatch() {
        if (this.h == null) {
            return;
        }
        if (this.h.a()) {
            this.fireDataSetContentsEvent(new DataSetContentsEvent(this, this.h.c, this.h.a, this.h.b));
        }
        this.h = null;
    }

    public final boolean isBatched() {
        return this.h != null;
    }

    protected void dataChanged(int n2, int n3, int n4) {
        if (n4 != 1) {
            this.setLimitsValid(false);
        }
        if (this.isBatched()) {
            this.a(n4, n2, n3);
        } else {
            this.fireDataChangedEvent(n2, n3, n4);
        }
    }

    protected void dataAdded(int n2) {
        if (this.g) {
            this.b.add(this.getXData(n2));
            this.c.add(this.getYData(n2));
        }
        if (this.isBatched()) {
            this.a(4, n2, n2);
        } else {
            this.fireDataAddedEvent(n2, n2);
        }
    }

    void a(int n2, int n3, int n4) {
        this.h.a(n2, n3, n4);
    }

    public void addDataSetListener(DataSetListener dataSetListener) {
        this.d.add(dataSetListener);
    }

    public void removeDataSetListener(DataSetListener dataSetListener) {
        this.d.remove(dataSetListener);
    }

    public void fireDataSetContentsEvent(DataSetContentsEvent dataSetContentsEvent) {
        Object[] objectArray = this.d.getListenerList();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((DataSetListener)objectArray[i2]).dataSetContentsChanged(dataSetContentsEvent);
        }
    }

    public void fireDataSetPropertyEvent(DataSetPropertyEvent dataSetPropertyEvent) {
        Object[] objectArray = this.d.getListenerList();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((DataSetListener)objectArray[i2]).dataSetPropertyChanged(dataSetPropertyEvent);
        }
    }

    public void fireDataAddedEvent(int n2, int n3) {
        this.fireDataSetContentsEvent(new DataSetContentsEvent(this, 4, n2, n3));
    }

    public void fireDataChangedEvent(int n2, int n3, int n4) {
        this.fireDataSetContentsEvent(new DataSetContentsEvent(this, n4, n2, n3));
    }

    public IlvDataPoints getData() {
        return this.getDataBetween(0, this.getDataCount() - 1);
    }

    public IlvDataPoints getDataBetween(int n2, int n3) {
        int n4 = this.getDataCount();
        IlvDataPoints ilvDataPoints = null;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= n4) {
            n3 = n4 - 1;
        }
        if (n2 <= n3) {
            int n5 = n3 - n2 + 1;
            ilvDataPoints = new IlvDataPoints(this, n5);
            this.a(ilvDataPoints, n2, n3);
            int[] nArray = ilvDataPoints.getIndices();
            for (int i2 = 0; i2 < n5; ++i2) {
                nArray[i2] = n2++;
            }
        }
        return ilvDataPoints;
    }

    public IlvDataPoints getDataInside(IlvDataWindow ilvDataWindow, int n2, boolean bl) {
        IlvDataPoints ilvDataPoints;
        int n3;
        int n4;
        int n5 = this.getDataCount();
        if (n5 == 0 || !ilvDataWindow.xRange.intersects(this.e())) {
            return null;
        }
        if (this.isXValuesSorted()) {
            n4 = ilvDataWindow.getXMin() <= this.a() ? 0 : this.a(ilvDataWindow.xRange);
            n3 = ilvDataWindow.getXMax() >= this.b() ? n5 - 1 : this.b(ilvDataWindow.xRange);
        } else {
            for (n3 = n5 - 1; n3 != 0 && !(this.getXData(n3) <= ilvDataWindow.xRange.getMax()); --n3) {
            }
            for (n4 = 0; n4 < n5 && !(this.getXData(n4) >= ilvDataWindow.xRange.getMin()); ++n4) {
            }
        }
        if (n2 > 0) {
            n4 = Math.max(n4 - n2, 0);
            n3 = Math.min(this.getDataCount() - 1, n3 + n2);
        }
        if ((ilvDataPoints = this.getDataBetween(n4, n3)) != null && !bl) {
            if (this.isXValuesSorted()) {
                IlvAbstractDataSet.a(ilvDataPoints, n4, ilvDataWindow.yRange);
            } else {
                IlvAbstractDataSet.a(ilvDataPoints, n4, ilvDataWindow.xRange, ilvDataWindow.yRange);
            }
        }
        return ilvDataPoints;
    }

    private static void a(IlvDataPoints ilvDataPoints, int n2, IlvDataInterval ilvDataInterval) {
        int n3;
        int n4 = ilvDataPoints.size();
        int[] nArray = ilvDataPoints.getIndices();
        double[] dArray = ilvDataPoints.getXValues();
        double[] dArray2 = ilvDataPoints.getYValues();
        for (n3 = 0; n3 < n4 && ilvDataInterval.isInside(dArray2[n3]); ++n3) {
        }
        int n5 = n3;
        while (n3 < n4) {
            if (ilvDataInterval.isInside(dArray2[n3])) {
                dArray[n5] = dArray[n3];
                dArray2[n5] = dArray2[n3];
                nArray[n5++] = n2 + n3;
            }
            ++n3;
        }
        ilvDataPoints.setSize(n5);
    }

    private static void a(IlvDataPoints ilvDataPoints, int n2, IlvDataInterval ilvDataInterval, IlvDataInterval ilvDataInterval2) {
        int n3;
        int n4 = ilvDataPoints.size();
        int[] nArray = ilvDataPoints.getIndices();
        double[] dArray = ilvDataPoints.getXValues();
        double[] dArray2 = ilvDataPoints.getYValues();
        for (n3 = 0; n3 < n4 && ilvDataInterval2.isInside(dArray2[n3]) && ilvDataInterval.isInside(dArray[n3]); ++n3) {
        }
        int n5 = n3;
        while (n3 < n4) {
            if (ilvDataInterval2.isInside(dArray2[n3]) && ilvDataInterval.isInside(dArray[n3])) {
                dArray[n5] = dArray[n3];
                dArray2[n5] = dArray2[n3];
                nArray[n5++] = n2 + n3;
            }
            ++n3;
        }
        ilvDataPoints.setSize(n5);
    }

    int a(IlvDataInterval ilvDataInterval) {
        int n2 = this.a(ilvDataInterval.getMin());
        if (n2 < 0) {
            return -n2 - 1;
        }
        while (--n2 > 0 && this.getXData(n2) == ilvDataInterval.getMin()) {
        }
        return n2 + 1;
    }

    int b(IlvDataInterval ilvDataInterval) {
        int n2 = this.a(ilvDataInterval.getMax());
        if (n2 < 0) {
            return -n2 - 2;
        }
        int n3 = this.getDataCount();
        while (++n2 < n3 && this.getXData(n2) == ilvDataInterval.getMax()) {
        }
        return n2 - 1;
    }

    int a(double d2) {
        int n2 = this.getDataCount() - 1;
        int n3 = 0;
        while (n3 <= n2) {
            int n4 = (n2 + n3) / 2;
            double d3 = this.getXData(n4);
            if (d3 < d2) {
                n3 = n4 + 1;
                continue;
            }
            if (d3 > d2) {
                n2 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n3 + 1);
    }

    void a(IlvDataPoints ilvDataPoints, int n2, int n3) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            ilvDataPoints.add(this.getXData(i2), this.getYData(i2), i2);
        }
    }

    private final Map j() {
        if (this.f == null) {
            this.f = new HashMap(2);
        }
        return this.f;
    }

    public synchronized void putProperty(Object object, Object object2, boolean bl) {
        Object object3 = null;
        if (bl) {
            object3 = this.getProperty(object);
        }
        if (object2 != null) {
            this.j().put(object, object2);
        } else if (this.f != null) {
            this.f.remove(object);
        }
        if (bl && (object3 == null && object2 != null || !object3.equals(object2))) {
            this.fireDataSetPropertyEvent(new DataSetPropertyEvent(this, object.toString(), object3, object2));
        }
    }

    public synchronized Object getProperty(Object object) {
        return this.f == null ? null : this.f.get(object);
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getName() + " " + this.e() + " / " + this.f();
    }

    public String getName() {
        return (String)this.getProperty(a);
    }

    public void setName(String string) {
        this.putProperty(a, string, true);
    }

    public String getDataLabel(int n2) {
        return "";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.h();
    }

    private static class Batch {
        int a = Integer.MAX_VALUE;
        int b = Integer.MIN_VALUE;
        int c = -1;

        private Batch() {
        }

        void a(int n2, int n3, int n4) {
            if (this.c == -1) {
                this.c = n2;
                this.a = n3;
                this.b = n4;
            } else {
                if (this.c == 6) {
                    return;
                }
                if (n2 != 4) {
                    this.c = 6;
                    this.a = 0;
                    this.b = 0;
                } else {
                    if (n3 < this.a) {
                        this.a = n3;
                    }
                    if (n4 > this.b) {
                        this.b = n4;
                    }
                }
            }
        }

        final boolean a() {
            return this.b >= this.a;
        }
    }
}

