/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.util.IlvChartUtil;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvMathUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import javax.swing.UIManager;

class IlvTextRenderer
implements Serializable {
    private static final boolean a = IlvChartUtil.compareToJavaVersion(1, 4, 0) >= 0;
    private String b;
    private double c;
    private boolean d = false;
    private float e = 0.0f;
    private boolean f;
    private int g = 2;
    private Font h;
    private transient boolean i = false;
    private transient boolean j = false;
    private transient Rectangle2D k;
    private transient Rectangle2D l;
    private transient String[] m;
    private transient TextLayout[] n;

    public IlvTextRenderer() {
        this("");
    }

    public IlvTextRenderer(String string) {
        this(string, 0.0);
    }

    public IlvTextRenderer(String string, double d2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.b = string;
        this.c = d2;
    }

    public void draw(Graphics graphics, double d2, double d3) {
        this.c();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        graphics2D.setFont(this.getFont());
        AffineTransform affineTransform = this.getRotation() != 0.0 ? AffineTransform.getRotateInstance(Math.toRadians(this.getRotation()), d2, d3) : null;
        AffineTransform affineTransform2 = null;
        if (affineTransform != null) {
            affineTransform2 = graphics2D.getTransform();
            graphics2D.transform(affineTransform);
        }
        if (this.m.length > 1) {
            this.b(graphics2D, d2, d3);
        } else {
            this.a(graphics2D, d2, d3);
        }
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform2);
        }
        graphics2D.setFont(font);
    }

    private void a(Graphics2D graphics2D, double d2, double d3) {
        TextLayout textLayout = this.n[0];
        if (textLayout == null) {
            return;
        }
        if (a) {
            d2 -= (double)textLayout.getAdvance() / 2.0;
            d3 += (double)((textLayout.getAscent() - textLayout.getDescent()) / 2.0f);
        } else {
            d2 = Math.floor(d2 - Math.floor((double)textLayout.getAdvance() / 2.0));
            d3 = Math.floor(d3 + (double)((textLayout.getAscent() - textLayout.getDescent()) / 2.0f));
        }
        textLayout.draw(graphics2D, (float)d2, (float)d3);
    }

    private void b(Graphics2D graphics2D, double d2, double d3) {
        Rectangle2D rectangle2D = this.getBounds(false);
        int n2 = this.m.length;
        double d4 = rectangle2D.getWidth();
        double d5 = 0.0;
        d2 -= d4 / 2.0;
        d3 -= rectangle2D.getHeight() / 2.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextLayout textLayout = this.n[i2];
            if (textLayout == null) continue;
            d3 += (double)textLayout.getAscent();
            switch (this.g) {
                case 2: {
                    d5 = textLayout.isLeftToRight() ? 0.0 : d4 - (double)textLayout.getAdvance();
                    break;
                }
                case 0: {
                    d5 = (d4 - (double)textLayout.getAdvance()) / 2.0;
                    break;
                }
                case 4: {
                    d5 = textLayout.isLeftToRight() ? d4 - (double)textLayout.getAdvance() : 0.0;
                }
            }
            textLayout.draw(graphics2D, (float)(d2 + d5), (float)d3);
            d3 += (double)(textLayout.getDescent() + textLayout.getLeading());
        }
    }

    private void c(Graphics2D graphics2D, double d2, double d3) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.green);
        int n2 = IlvGraphicUtil.toInt(d2);
        int n3 = IlvGraphicUtil.toInt(d3);
        graphics2D.fillRect(n2 - 1, n3 - 1, 3, 3);
        graphics2D.setColor(new Color(0, 255, 0, 100));
        Rectangle2D rectangle2D = this.getBounds(true);
        rectangle2D.setRect(d2 - rectangle2D.getWidth() / 2.0, d3 - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        graphics2D.draw(rectangle2D);
        graphics2D.setColor(color);
    }

    public final Rectangle2D getBounds(boolean bl) {
        this.c();
        this.a();
        return bl ? this.l : this.k;
    }

    public final double getWidth() {
        return this.getBounds(true).getWidth();
    }

    public final double getHeight() {
        return this.getBounds(true).getHeight();
    }

    private void a() {
        if (this.i) {
            return;
        }
        TextLayout textLayout = this.n[0];
        float f2 = textLayout == null ? 0.0f : textLayout.getAdvance();
        float f3 = textLayout == null ? 0.0f : textLayout.getAscent() + textLayout.getDescent();
        int n2 = this.m.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            textLayout = this.n[i2];
            if (textLayout == null) continue;
            f2 = Math.max(f2, textLayout.getAdvance());
            f3 += textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        }
        if (this.k == null) {
            this.k = new Rectangle2D.Double(0.0, 0.0, f2, f3);
        } else {
            this.k.setRect(0.0, 0.0, f2, f3);
        }
        if (this.c != 0.0) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(IlvMathUtil.toRadians(this.c));
            this.l = IlvGraphicUtil.transform((Rectangle2D)this.k.clone(), affineTransform);
        } else {
            this.l = this.k;
        }
        this.i = true;
    }

    private final FontRenderContext b() {
        return IlvGraphicUtil.getFRC(this.isAntiAliased(), false);
    }

    private void c() {
        if (this.j) {
            return;
        }
        String[] stringArray = IlvTextRenderer.a(this.getText());
        int n2 = stringArray.length;
        FontRenderContext fontRenderContext = this.b();
        Font font = this.getFont();
        float f2 = this.e;
        if (f2 > 0.0f && this.isAutoWrapping()) {
            ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            BreakIterator breakIterator = BreakIterator.getLineInstance();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray[i2];
                if (string.length() > 0) {
                    AttributedString attributedString = new AttributedString(string);
                    attributedString.addAttribute(TextAttribute.FONT, this.getFont());
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), breakIterator, fontRenderContext);
                    int n3 = string.length();
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5;
                        int n6 = lineBreakMeasurer.nextOffset(f2, n3, true);
                        if (n6 == n4) {
                            n6 = n5 = breakIterator.following(n4);
                        }
                        n5 = n6;
                        while (--n5 > n4 && Character.isSpaceChar(string.charAt(n5))) {
                        }
                        String string2 = string.substring(n4, n5 + 1);
                        arrayList2.add(string2);
                        arrayList.add(new TextLayout(string2, font, fontRenderContext));
                        lineBreakMeasurer.setPosition(n6);
                        n4 = n6;
                    }
                    continue;
                }
                arrayList2.add(string);
                arrayList.add(null);
            }
            this.m = arrayList2.toArray(new String[arrayList2.size()]);
            this.n = arrayList.toArray(new TextLayout[arrayList.size()]);
        } else {
            this.m = stringArray;
            this.n = new TextLayout[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                String string = this.m[i3];
                this.n[i3] = string.length() > 0 ? new TextLayout(string, font, fontRenderContext) : null;
            }
        }
        this.j = true;
        this.i = false;
    }

    private static String[] a(String string) {
        int n2;
        int n3 = string.length();
        int n4 = 1;
        for (n2 = 0; n2 < n3; ++n2) {
            if (string.charAt(n2) != '\n') continue;
            ++n4;
        }
        String[] stringArray = new String[n4];
        if (n4 == 1) {
            stringArray[0] = string;
        } else {
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = string.indexOf(10, n5);
                if (n6 == -1) {
                    n6 = n3;
                }
                stringArray[n2] = n6 == n5 ? " " : string.substring(n5, n6);
                n5 = n6 + 1;
            }
        }
        return stringArray;
    }

    public Font getFont() {
        return this.h == null ? UIManager.getFont("Label.font") : this.h;
    }

    public final boolean setFont(Font font) {
        if (this.h != null && this.h.equals(font)) {
            return false;
        }
        this.h = font;
        this.j = false;
        return true;
    }

    public double getRotation() {
        return this.c;
    }

    public final void setRotation(double d2) {
        if (this.c == d2) {
            return;
        }
        this.c = d2;
        this.i = false;
    }

    public final String getText() {
        return this.b;
    }

    public void setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.b.equals(string)) {
            return;
        }
        this.b = string;
        this.j = false;
    }

    public final boolean isAntiAliased() {
        return this.f;
    }

    public void setAntiAliased(boolean bl) {
        if (this.f == bl) {
            return;
        }
        this.f = bl;
        this.j = false;
    }

    public final int getAlignment() {
        return this.g;
    }

    public void setAlignment(int n2) {
        if (n2 != 2 && n2 != 0 && n2 != 4) {
            throw new IllegalArgumentException("Invalid Alignment");
        }
        this.g = n2;
    }

    public final boolean isAutoWrapping() {
        return this.d;
    }

    public void setAutoWrapping(boolean bl) {
        if (this.d == bl) {
            return;
        }
        this.d = bl;
        this.j = false;
    }

    public final float getWrappingWidth() {
        return this.e;
    }

    public void setWrappingWidth(float f2) {
        if (this.e == f2) {
            return;
        }
        this.e = f2;
        if (this.isAutoWrapping()) {
            this.j = false;
        }
    }
}

