/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.util.internal.IlvMathUtil;
import java.io.Serializable;

public final class IlvDataInterval
implements Cloneable,
Serializable {
    public double min;
    public double max;

    public IlvDataInterval() {
        this(1.0, -1.0);
    }

    public IlvDataInterval(double d2, double d3) {
        this.min = d2;
        this.max = d3;
    }

    public IlvDataInterval(IlvDataInterval ilvDataInterval) {
        this(ilvDataInterval.getMin(), ilvDataInterval.getMax());
    }

    public void empty() {
        this.min = 1.0;
        this.max = -1.0;
    }

    public boolean isEmpty() {
        return this.max < this.min;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double d2) {
        this.min = d2;
    }

    public void setMax(double d2) {
        this.max = d2;
    }

    public void set(double d2, double d3) {
        this.min = d2;
        this.max = d3;
    }

    public boolean isBefore(double d2) {
        return this.isEmpty() ? false : d2 <= this.min;
    }

    public boolean isStrictlyBefore(double d2) {
        return this.isEmpty() ? false : d2 < this.min;
    }

    public boolean isAfter(double d2) {
        return this.isEmpty() ? false : d2 >= this.max;
    }

    public boolean isStrictlyAfter(double d2) {
        return this.isEmpty() ? false : d2 > this.max;
    }

    public boolean isInside(double d2) {
        return this.isEmpty() ? false : !this.isStrictlyBefore(d2) && !this.isStrictlyAfter(d2);
    }

    public boolean isStrictlyInside(double d2) {
        return this.isEmpty() ? false : !this.isBefore(d2) && !this.isAfter(d2);
    }

    public boolean isOutside(double d2) {
        return this.isBefore(d2) || this.isAfter(d2);
    }

    public boolean isStrictlyOutside(double d2) {
        return this.isStrictlyBefore(d2) || this.isStrictlyAfter(d2);
    }

    public boolean contains(IlvDataInterval ilvDataInterval) {
        return this.isInside(ilvDataInterval.getMin()) && this.isInside(ilvDataInterval.getMax());
    }

    public void translate(double d2) {
        this.min += d2;
        this.max += d2;
    }

    public void expand(double d2) {
        if (!this.isEmpty()) {
            this.min -= d2;
            this.max += d2;
        }
    }

    public boolean intersects(IlvDataInterval ilvDataInterval) {
        return this.isEmpty() ? false : !this.isStrictlyBefore(ilvDataInterval.getMax()) && !this.isStrictlyAfter(ilvDataInterval.getMin());
    }

    public boolean add(double d2) {
        if (this.isEmpty()) {
            this.min = this.max = d2;
            return true;
        }
        if (this.isStrictlyBefore(d2)) {
            this.setMin(d2);
            return true;
        }
        if (this.isStrictlyAfter(d2)) {
            this.setMax(d2);
            return true;
        }
        return false;
    }

    public boolean add(IlvDataInterval ilvDataInterval) {
        if (ilvDataInterval.isEmpty()) {
            return false;
        }
        if (this.isEmpty()) {
            this.min = ilvDataInterval.getMin();
            this.max = ilvDataInterval.getMax();
            return true;
        }
        boolean bl = this.add(ilvDataInterval.getMin());
        return this.add(ilvDataInterval.getMax()) || bl;
    }

    public void substract(IlvDataInterval ilvDataInterval) {
        this.subtract(ilvDataInterval);
    }

    public void subtract(IlvDataInterval ilvDataInterval) {
        if (ilvDataInterval.isEmpty()) {
            return;
        }
        if (ilvDataInterval.contains(this)) {
            this.empty();
        } else if (this.intersects(ilvDataInterval)) {
            if (ilvDataInterval.getMin() <= this.min) {
                this.min = ilvDataInterval.getMax();
            } else if (ilvDataInterval.getMax() >= this.max) {
                this.max = ilvDataInterval.getMin();
            }
        }
    }

    public void intersection(IlvDataInterval ilvDataInterval) {
        if (!ilvDataInterval.isEmpty() && this.intersects(ilvDataInterval)) {
            if (ilvDataInterval.isStrictlyBefore(this.getMin())) {
                this.setMin(ilvDataInterval.getMin());
            }
            if (ilvDataInterval.isStrictlyAfter(this.getMax())) {
                this.setMax(ilvDataInterval.getMax());
            }
        } else {
            this.empty();
        }
    }

    public double getLength() {
        return this.isEmpty() ? 0.0 : this.max - this.min;
    }

    public double getMiddle() {
        return this.isEmpty() ? 0.0 : (this.max + this.min) / 2.0;
    }

    public double clamp(double d2) {
        if (this.isEmpty()) {
            return d2;
        }
        return IlvMathUtil.clamp(d2, this.min, this.max);
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Can't clone");
        }
        return object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IlvDataInterval)) {
            return false;
        }
        IlvDataInterval ilvDataInterval = (IlvDataInterval)object;
        return this.min == ilvDataInterval.min && this.max == ilvDataInterval.max;
    }

    public String toString() {
        return this.isEmpty() ? "[EMPTY]" : "[" + this.min + "," + this.max + "]";
    }
}

