/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvAxisTransformer;
import ilog.views.chart.IlvAxisTransformerException;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;

abstract class IlvAbstractProjector
implements IlvChartProjector,
Cloneable,
Serializable {
    private boolean a;
    private transient Coefficient b;
    private transient Coefficient c;

    IlvAbstractProjector() {
    }

    final boolean a() {
        return this.a;
    }

    void a(boolean bl) {
        this.a = bl;
    }

    public void toDisplay(IlvDoublePoints ilvDoublePoints, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        Object object;
        IlvAxis ilvAxis = ilvCoordinateSystem.getXAxis();
        IlvAxis ilvAxis2 = ilvCoordinateSystem.getYAxis();
        try {
            object = ilvAxis.getTransformer();
            if (object != null) {
                ilvDoublePoints.c = ((IlvAxisTransformer)object).apply(ilvDoublePoints.getXValues(), ilvDoublePoints.b);
            }
            if ((object = ilvAxis2.getTransformer()) != null) {
                ilvDoublePoints.d = ((IlvAxisTransformer)object).apply(ilvDoublePoints.getYValues(), ilvDoublePoints.b);
            }
        }
        catch (IlvAxisTransformerException ilvAxisTransformerException) {
            ilvAxisTransformerException.printStackTrace();
        }
        object = this.b;
        Coefficient coefficient = this.c;
        if (object == null || coefficient == null) {
            object = new Coefficient();
            coefficient = new Coefficient();
            this.a(rectangle, ilvCoordinateSystem, (Coefficient)object, coefficient);
        }
        this.a(ilvDoublePoints, rectangle, (Coefficient)object, coefficient);
    }

    public void toData(IlvDoublePoints ilvDoublePoints, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        IlvAxis ilvAxis = ilvCoordinateSystem.getXAxis();
        IlvAxis ilvAxis2 = ilvCoordinateSystem.getYAxis();
        Coefficient coefficient = new Coefficient();
        Coefficient coefficient2 = new Coefficient();
        DataPos dataPos = new DataPos();
        this.a(rectangle, ilvAxis, dataPos);
        if (ilvAxis.isReversed()) {
            dataPos.reverse();
        }
        this.b(rectangle, ilvAxis, dataPos, coefficient);
        this.a(rectangle, ilvAxis2, dataPos);
        if (ilvAxis2.isReversed()) {
            dataPos.reverse();
        }
        this.b(rectangle, ilvAxis2, dataPos, coefficient2);
        this.a(ilvDoublePoints, rectangle, coefficient, coefficient2);
        try {
            IlvAxisTransformer ilvAxisTransformer = ilvAxis.getTransformer();
            if (ilvAxisTransformer != null) {
                ilvAxisTransformer.inverse(ilvDoublePoints.getXValues(), ilvDoublePoints.b);
            }
            if ((ilvAxisTransformer = ilvAxis2.getTransformer()) != null) {
                ilvAxisTransformer.inverse(ilvDoublePoints.getYValues(), ilvDoublePoints.b);
            }
        }
        catch (IlvAxisTransformerException ilvAxisTransformerException) {
            ilvAxisTransformerException.printStackTrace();
        }
    }

    public abstract void getOrigin(Rectangle var1, IlvDoublePoint var2);

    abstract void a(Rectangle var1, IlvAxis var2, DataPos var3);

    abstract void a(Rectangle var1, IlvAxis var2, DataPos var3, Coefficient var4);

    abstract void b(Rectangle var1, IlvAxis var2, DataPos var3, Coefficient var4);

    void a(IlvDoublePoints ilvDoublePoints, Rectangle rectangle, Coefficient coefficient, Coefficient coefficient2) {
        double d2 = coefficient.a;
        double d3 = coefficient.b;
        double d4 = coefficient2.a;
        double d5 = coefficient2.b;
        double[] dArray = ilvDoublePoints.getXValues();
        double[] dArray2 = ilvDoublePoints.getYValues();
        int n2 = ilvDoublePoints.size();
        while (--n2 >= 0) {
            dArray[n2] = dArray[n2] * d2 + d3;
            dArray2[n2] = dArray2[n2] * d4 + d5;
        }
    }

    public IlvDataWindow toDataWindow(Rectangle rectangle, Rectangle rectangle2, IlvCoordinateSystem ilvCoordinateSystem) {
        IlvDataWindow ilvDataWindow = new IlvDataWindow();
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(2);
        ilvDoublePoints.add(rectangle.x, rectangle.y);
        ilvDoublePoints.add(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        this.toData(ilvDoublePoints, rectangle2, ilvCoordinateSystem);
        if (ilvDoublePoints.getX(0) < ilvDoublePoints.getX(1)) {
            ilvDataWindow.xRange.set(ilvDoublePoints.getX(0), ilvDoublePoints.getX(1));
        } else {
            ilvDataWindow.xRange.set(ilvDoublePoints.getX(1), ilvDoublePoints.getX(0));
        }
        if (ilvDoublePoints.getY(0) < ilvDoublePoints.getY(1)) {
            ilvDataWindow.yRange.set(ilvDoublePoints.getY(0), ilvDoublePoints.getY(1));
        } else {
            ilvDataWindow.yRange.set(ilvDoublePoints.getY(1), ilvDoublePoints.getY(0));
        }
        return ilvDataWindow;
    }

    public Rectangle toRectangle(IlvDataWindow ilvDataWindow, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        Rectangle rectangle2 = new Rectangle();
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(2);
        ilvDoublePoints.add(ilvDataWindow.getXMin(), ilvDataWindow.getYMin());
        ilvDoublePoints.add(ilvDataWindow.getXMax(), ilvDataWindow.getYMax());
        this.toDisplay(ilvDoublePoints, rectangle, ilvCoordinateSystem);
        if (ilvDoublePoints.getX(0) > ilvDoublePoints.getX(1)) {
            rectangle2.x = (int)Math.floor(ilvDoublePoints.getX(1));
            rectangle2.width = (int)Math.floor(ilvDoublePoints.getX(0)) - rectangle2.x;
        } else {
            rectangle2.x = (int)Math.floor(ilvDoublePoints.getX(0));
            rectangle2.width = (int)Math.floor(ilvDoublePoints.getX(1)) - rectangle2.x;
        }
        if (ilvDoublePoints.getY(0) > ilvDoublePoints.getY(1)) {
            rectangle2.y = (int)Math.floor(ilvDoublePoints.getY(1));
            rectangle2.height = (int)Math.floor(ilvDoublePoints.getY(0)) - rectangle2.y;
        } else {
            rectangle2.y = (int)Math.floor(ilvDoublePoints.getY(0));
            rectangle2.height = (int)Math.floor(ilvDoublePoints.getY(1)) - rectangle2.y;
        }
        return rectangle2;
    }

    public Rectangle getProjectorRect(Rectangle rectangle, double d2, double d3, double d4) {
        return rectangle;
    }

    public Shape getShape(double d2, int n2, Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        IlvDataInterval ilvDataInterval = null;
        ilvDataInterval = n2 == 1 ? ilvCoordinateSystem.getYAxis().getVisibleRange() : ilvCoordinateSystem.getXAxis().getVisibleRange();
        return this.getShape(d2, ilvDataInterval, n2, rectangle, ilvCoordinateSystem);
    }

    public IlvAbstractProjector getLocalProjector(Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        IlvAbstractProjector ilvAbstractProjector = (IlvAbstractProjector)this.clone();
        ilvAbstractProjector.a(rectangle, ilvCoordinateSystem);
        return ilvAbstractProjector;
    }

    private void a(Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem) {
        this.b = new Coefficient();
        this.c = new Coefficient();
        this.a(rectangle, ilvCoordinateSystem, this.b, this.c);
    }

    private void a(Rectangle rectangle, IlvCoordinateSystem ilvCoordinateSystem, Coefficient coefficient, Coefficient coefficient2) {
        DataPos dataPos = new DataPos();
        this.a(rectangle, ilvCoordinateSystem.getXAxis(), dataPos);
        if (ilvCoordinateSystem.getXAxis().isReversed()) {
            dataPos.reverse();
        }
        this.a(rectangle, ilvCoordinateSystem.getXAxis(), dataPos, coefficient);
        this.a(rectangle, ilvCoordinateSystem.getYAxis(), dataPos);
        if (ilvCoordinateSystem.getYAxis().isReversed()) {
            dataPos.reverse();
        }
        this.a(rectangle, ilvCoordinateSystem.getYAxis(), dataPos, coefficient2);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract Shape getShape(double var1, IlvDataInterval var3, int var4, Rectangle var5, IlvCoordinateSystem var6);

    static class DataPos {
        double a;
        double b;

        DataPos() {
        }

        public final void reverse() {
            double d2 = this.a;
            this.a = this.b;
            this.b = d2;
        }
    }

    static class Coefficient {
        double a;
        double b;

        Coefficient() {
        }
    }
}

