/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.histnews.history;

import hk.com.realink.histnews.history.HistRaw;
import hk.com.realink.histnews.history.HistRecord;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class HistRecordParser {
    public static HistRecord getRootInterDailyHistRecord(HistRaw[] histRaws) {
        int startIdx;
        int i2;
        float open = 0.0f;
        float close = 0.0f;
        float high = 0.0f;
        float low = 0.0f;
        long maxTurnover = 0L;
        String companyCode = histRaws[0].companyCode;
        HistRecord rootHistRecord = new HistRecord(companyCode, 4);
        for (i2 = startIdx = 0; i2 < histRaws.length; ++i2) {
            if (!(histRaws[i2].close > 0.0f)) continue;
            startIdx = i2;
            if (histRaws[i2].high != 0.0f && histRaws[i2].low != 0.0f && histRaws[i2].open != 0.0f) break;
            histRaws[i2].high = histRaws[i2].close;
            histRaws[i2].low = histRaws[i2].close;
            histRaws[i2].open = histRaws[i2].close;
            break;
        }
        for (i2 = startIdx; i2 < histRaws.length; ++i2) {
            if (histRaws[i2].close > 0.0f) {
                startIdx = i2;
                if (histRaws[i2].high == 0.0f || histRaws[i2].low == 0.0f || histRaws[i2].open == 0.0f) {
                    histRaws[i2].high = histRaws[i2].close;
                    histRaws[i2].low = histRaws[i2].close;
                    histRaws[i2].open = histRaws[i2].close;
                } else if (histRaws[i2].close > histRaws[i2].high) {
                    histRaws[i2].high = histRaws[i2].close;
                } else if (histRaws[i2].close < histRaws[i2].low) {
                    histRaws[i2].low = histRaws[i2].close;
                }
            }
            HistRecord dayHistRecord = new HistRecord(companyCode);
            dayHistRecord.open = histRaws[i2].open;
            dayHistRecord.close = histRaws[i2].close;
            dayHistRecord.high = histRaws[i2].high;
            dayHistRecord.low = histRaws[i2].low;
            dayHistRecord.maxTurnover = histRaws[i2].maxTurnover;
            dayHistRecord.date = histRaws[i2].date;
            if (dayHistRecord.open > 0.0f) {
                open = dayHistRecord.open;
            } else {
                dayHistRecord.open = open;
            }
            if (dayHistRecord.close > 0.0f) {
                close = dayHistRecord.close;
            } else {
                dayHistRecord.close = close;
            }
            if (dayHistRecord.high > 0.0f) {
                high = dayHistRecord.high;
            } else {
                dayHistRecord.high = high;
            }
            if (dayHistRecord.low > 0.0f) {
                low = dayHistRecord.low;
            } else {
                dayHistRecord.low = low;
            }
            if (dayHistRecord.maxTurnover > 0L) {
                maxTurnover = dayHistRecord.maxTurnover;
            }
            rootHistRecord.addHistRecord(dayHistRecord);
        }
        rootHistRecord.setType(8);
        return rootHistRecord;
    }

    public static HistRecord getRootDailyHistRecord(HistRaw[] histRaws) {
        int startIdx;
        int i2;
        float open = 0.0f;
        float close = 0.0f;
        float high = 0.0f;
        float low = 0.0f;
        long maxTurnover = 0L;
        String companyCode = histRaws[0].companyCode;
        HistRecord rootHistRecord = new HistRecord(companyCode, 4);
        for (i2 = startIdx = 0; i2 < histRaws.length; ++i2) {
            if (!(histRaws[i2].close > 0.0f)) continue;
            startIdx = i2;
            if (histRaws[i2].high != 0.0f && histRaws[i2].low != 0.0f && histRaws[i2].open != 0.0f) break;
            histRaws[i2].high = histRaws[i2].close;
            histRaws[i2].low = histRaws[i2].close;
            histRaws[i2].open = histRaws[i2].close;
            break;
        }
        for (i2 = startIdx; i2 < histRaws.length; ++i2) {
            HistRecord lastStoredDayHistRecord;
            if (histRaws[i2].close > 0.0f) {
                startIdx = i2;
                if (histRaws[i2].high == 0.0f || histRaws[i2].low == 0.0f || histRaws[i2].open == 0.0f) {
                    histRaws[i2].high = histRaws[i2].close;
                    histRaws[i2].low = histRaws[i2].close;
                    histRaws[i2].open = histRaws[i2].close;
                } else if (histRaws[i2].close > histRaws[i2].high) {
                    histRaws[i2].high = histRaws[i2].close;
                } else if (histRaws[i2].close < histRaws[i2].low) {
                    histRaws[i2].low = histRaws[i2].close;
                }
            }
            HistRecord dayHistRecord = new HistRecord(companyCode);
            dayHistRecord.open = histRaws[i2].open;
            dayHistRecord.close = histRaws[i2].close;
            dayHistRecord.high = histRaws[i2].high;
            dayHistRecord.low = histRaws[i2].low;
            dayHistRecord.maxTurnover = histRaws[i2].maxTurnover;
            dayHistRecord.date = histRaws[i2].date;
            if (dayHistRecord.open > 0.0f) {
                open = dayHistRecord.open;
            } else {
                dayHistRecord.open = open;
            }
            if (dayHistRecord.close > 0.0f) {
                close = dayHistRecord.close;
            } else {
                dayHistRecord.close = close;
            }
            if (dayHistRecord.high > 0.0f) {
                high = dayHistRecord.high;
            } else {
                dayHistRecord.high = high;
            }
            if (dayHistRecord.low > 0.0f) {
                low = dayHistRecord.low;
            } else {
                dayHistRecord.low = low;
            }
            if (dayHistRecord.maxTurnover > 0L) {
                maxTurnover = dayHistRecord.maxTurnover;
            }
            if ((lastStoredDayHistRecord = rootHistRecord.getLastHistRecord()) == null && (lastStoredDayHistRecord = HistRecordParser.getFirstMondayHistRecord(companyCode, dayHistRecord)) != null) {
                rootHistRecord.addHistRecord(lastStoredDayHistRecord);
            }
            if (lastStoredDayHistRecord != null) {
                Collection c2 = HistRecordParser.getHoildayHistRecords(companyCode, lastStoredDayHistRecord, dayHistRecord);
                Iterator iterator = c2.iterator();
                while (iterator.hasNext()) {
                    rootHistRecord.addHistRecord((HistRecord)iterator.next());
                }
            }
            rootHistRecord.addHistRecord(dayHistRecord);
        }
        return rootHistRecord;
    }

    public static String toTimeString(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String s2 = sdf.format(new Date(time));
        return s2;
    }

    private static HistRecord getFirstMondayHistRecord(String companyCode, HistRecord curHistRecord) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date(curHistRecord.date));
        int dayOfWeek = curDate.get(7);
        if (dayOfWeek == 2) {
            return null;
        }
        Calendar lastDate = (Calendar)curDate.clone();
        int firstDayOfWeek = lastDate.get(7);
        if (firstDayOfWeek > 2) {
            for (int i2 = firstDayOfWeek; i2 > 2; --i2) {
                lastDate.add(5, -1);
            }
        }
        HistRecord h2 = new HistRecord(companyCode);
        h2.date = lastDate.getTime().getTime();
        return h2;
    }

    private static Collection getHoildayHistRecords(String companyCode, HistRecord lastHistRecord, HistRecord curHistRecord) {
        ArrayList<HistRecord> list = new ArrayList<HistRecord>();
        Calendar lastDate = Calendar.getInstance();
        lastDate.setTime(new Date(lastHistRecord.date));
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date(curHistRecord.date));
        while (HistRecordParser.isHolidayBetween(lastDate, curDate)) {
            if (lastDate.get(7) == 6) {
                lastDate.add(5, 3);
            } else {
                lastDate.add(5, 1);
            }
            HistRecord histRecord = new HistRecord(companyCode);
            histRecord.date = lastDate.getTime().getTime();
            list.add(histRecord);
        }
        return list;
    }

    private static boolean isHolidayBetween(Calendar _lastDate, Calendar curDate) {
        if (_lastDate.after(curDate)) {
            return false;
        }
        if (_lastDate.equals(curDate) || _lastDate == null) {
            return false;
        }
        Calendar lastDate = (Calendar)_lastDate.clone();
        if (lastDate.get(7) == 6) {
            lastDate.add(5, 3);
            return curDate.get(1) != lastDate.get(1) || curDate.get(2) != lastDate.get(2) || curDate.get(5) != lastDate.get(5);
        }
        lastDate.add(5, 1);
        return curDate.get(1) != lastDate.get(1) || curDate.get(2) != lastDate.get(2) || curDate.get(5) != lastDate.get(5);
    }
}

