/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.data;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class EliCal {
    public static float getYield(int m_ask, float strikePrice, String expiryDate) {
        try {
            float ask = (float)m_ask / 1000.0f;
            int numOfDays = EliCal.getOutstandingDays(expiryDate);
            if (numOfDays > 0) {
                return (strikePrice - ask) / ask * (365.0f / (float)numOfDays);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0f;
    }

    public static int getOutstandingDays(String expiryDate) {
        try {
            long expiryDateL = EliCal.toDateLong(expiryDate);
            long todayDate = new Date().getTime();
            long diff = expiryDateL - todayDate;
            Date diffDate = new Date(diff);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(diffDate);
            return cal.get(6);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static float getYield(int m_ask, float strikePrice, float outstandingDays) {
        try {
            float ask = (float)m_ask / 1000.0f;
            if (outstandingDays > 0.0f) {
                return (strikePrice - ask) / ask * (365.0f / outstandingDays);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0f;
    }

    private static long toDateLong(String dateStr) {
        int[] datas = new int[]{0, 0, 0};
        StringTokenizer strTok = new StringTokenizer(dateStr, "/");
        int counts = 0;
        for (int i2 = 0; i2 < datas.length; ++i2) {
            if (!strTok.hasMoreElements()) continue;
            try {
                datas[i2] = Integer.parseInt(strTok.nextToken().trim());
                ++counts;
                continue;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (counts == 3) {
            GregorianCalendar cal = new GregorianCalendar(datas[2] + 2000, datas[1] - 1, datas[0], 0, 0, 0);
            return cal.getTime().getTime();
        }
        return 0L;
    }
}

