/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.feed.toolkit.channel;

import hk.com.realink.feed.toolkit.RKDebug;
import hk.com.realink.feed.toolkit.channel.Channel;
import hk.com.realink.feed.toolkit.channel.DataChannel;
import hk.com.realink.feed.toolkit.channel.TMsg;
import hk.com.realink.feed.toolkit.pool.ObjectFIFO;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;

public class DataChannelBuff
extends DataChannel {
    private ObjectFIFO fifo = null;
    private Channel channel = null;
    private Thread thd = null;

    public DataChannelBuff(Channel m_channel, Hashtable m_shareObjHash, Hashtable m_initalObjHash, int bufferSize) throws IOException {
        super(m_channel, m_shareObjHash, m_initalObjHash);
        this.fifo = new ObjectFIFO(bufferSize);
        m_channel.addEventListener(this);
    }

    public DataChannelBuff(Channel m_channel, int bufferSize) throws IOException {
        super(m_channel, null, null);
        this.fifo = new ObjectFIFO(bufferSize);
    }

    public void addEventListener(Channel m_channel) {
        this.channel = m_channel;
    }

    public void readObject(Object message) {
        this.channel.readObject(message);
    }

    public synchronized void activate() {
        this.writeDefaultObject();
        if (!this.isActivate) {
            return;
        }
        this.thd = new Thread(new Runnable(){

            public void run() {
                while (DataChannelBuff.this.isActivate) {
                    try {
                        TMsg tmsg = (TMsg)DataChannelBuff.this.fifo.remove();
                        DataChannelBuff.super.writeObject(tmsg.id, tmsg.priority, tmsg.message);
                    }
                    catch (Exception e2) {
                        try {
                            DataChannelBuff.this.close();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace(System.out);
                        }
                    }
                    Thread.yield();
                }
            }
        });
        this.thd.start();
    }

    private synchronized void writeDefaultObject() {
        if (!this.isActivate) {
            return;
        }
        if (this.initalObjHash != null) {
            Iterator iter = this.initalObjHash.values().iterator();
            while (iter.hasNext()) {
                this.writeObject(0, new Integer(1), iter.next());
            }
        }
    }

    public void writeObject(int m_id, Object m_priority, Object m_message) {
        if (!this.isActivate) {
            return;
        }
        try {
            if (this.fifo.isFull()) {
                this.fifo.removeAll();
                String str = "[" + this.channel.getUserInfo().key + "] queue full";
                RKDebug.warning(null, str);
            }
            TMsg tmsg = new TMsg(m_id, m_priority, m_message);
            this.fifo.add(tmsg);
        }
        catch (Exception e2) {
            // empty catch block
        }
    }

    public void writeObject(Object message) {
        this.writeObject(0, new Integer(1), message);
    }

    public void writeObject(int m_id, Object message) {
        this.writeObject(m_id, new Integer(1), message);
    }

    public void close() throws IOException {
        try {
            this.fifo.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }
}

