/*
 * Decompiled with CFR 0.152.
 */
package omni.obj.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import omni.db.RecSeriesItem;
import omni.obj.client.Dataizable;
import omni.obj.client.Series;

public class SeriesMap
implements Dataizable {
    public HashMap seriesMap = new HashMap();
    public HashMap isidMap = new HashMap();

    public void clear() {
        this.seriesMap.clear();
        this.isidMap.clear();
    }

    public void readExternal(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            RecSeriesItem recSeriesItem = new RecSeriesItem();
            recSeriesItem.readExternal(dataInput);
            this.seriesMap.put(recSeriesItem.series.getKey(), recSeriesItem);
            this.isidMap.put(recSeriesItem.ins_id, recSeriesItem);
        }
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        int n2 = this.seriesMap.size();
        dataOutput.writeInt(n2);
        for (RecSeriesItem recSeriesItem : this.seriesMap.values()) {
            recSeriesItem.writeExternal(dataOutput);
        }
    }

    public RecSeriesItem getRecSeriesItem(Series series2) {
        return (RecSeriesItem)this.seriesMap.get(series2.getKey());
    }

    public RecSeriesItem putRecSeriesItem(RecSeriesItem recSeriesItem) {
        return this.seriesMap.put(recSeriesItem.series.getKey(), recSeriesItem);
    }

    public RecSeriesItem removeRecSeriesItem(RecSeriesItem recSeriesItem) {
        return (RecSeriesItem)this.seriesMap.remove(recSeriesItem.series.getKey());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.seriesMap.toString());
        stringBuffer.append(this.isidMap.toString());
        return stringBuffer.toString();
    }
}

