/*
 * Decompiled with CFR 0.152.
 */
package omni.obj.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import omni.obj.client.ACCESS;
import omni.obj.client.LISTEN;
import omni.obj.client.MsgReq;
import omni.obj.client.SERIES_DATA;
import omni.obj.client.Series;
import omni.obj.client.SeriesDataRes;

public class SeriesDataReq
implements MsgReq {
    private int access;
    private byte listen = 1;
    private byte filter = 0;
    private Series series = new Series();
    private String[] insIds = new String[0];
    private int seq = -1;
    private byte[] periods = new byte[0];
    private byte bidAskQueSize = (byte)5;
    private byte strikeUpLevel = 0;
    private byte strikeDownLevel = 0;
    private short strikePriceMid = 0;

    public SeriesDataReq() {
    }

    public SeriesDataReq(int n2) {
        this.access = n2;
    }

    public SeriesDataReq(int n2, byte by) {
        this.access = n2;
        this.listen = by;
    }

    public byte getFilter() {
        return this.filter;
    }

    public void setBidAskOneQue() {
        SeriesDataRes.isReadBidAskQueSize = true;
        this.bidAskQueSize = 1;
    }

    public byte getBidAskQueSize() {
        return this.bidAskQueSize;
    }

    public byte getStrikeUpLevel() {
        return this.strikeUpLevel;
    }

    public byte getStrikeDownLevel() {
        return this.strikeDownLevel;
    }

    public short getStrikePriceMid() {
        return this.strikePriceMid;
    }

    public void setSeq(int n2) {
        this.seq = n2;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setInsId(String[] stringArray) {
        this.filter = 0;
        this.insIds = stringArray;
    }

    public String[] getInsIds() {
        return this.insIds;
    }

    public void setSeries(Series series2, byte by) {
        this.filter = by;
        this.series = series2;
    }

    public void setSeries(Series series2, byte by, byte[] byArray) {
        this.filter = by;
        this.series = series2;
        if (byArray != null) {
            this.periods = byArray;
        }
    }

    public void setSeries(Series series2, byte by, byte[] byArray, byte by2, byte by3, short s2) {
        this.filter = by;
        this.series = series2;
        if (byArray != null) {
            this.periods = byArray;
        }
        this.strikeUpLevel = by2;
        this.strikeDownLevel = by3;
        this.strikePriceMid = s2;
    }

    public byte[] getPeriods() {
        return this.periods;
    }

    public Series getSeries() {
        return this.series;
    }

    public void setAccess(int n2) {
        this.access = n2;
    }

    public void setListen(byte by) {
        this.listen = by;
    }

    public int getAccess() {
        return this.access;
    }

    public byte getListen() {
        return this.listen;
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        int n2;
        dataOutput.writeInt(this.access);
        dataOutput.writeByte(this.listen);
        dataOutput.writeByte(this.filter);
        if (this.filter == 0) {
            dataOutput.writeShort(this.insIds.length);
            for (n2 = 0; n2 < this.insIds.length; ++n2) {
                dataOutput.writeUTF(this.insIds[n2]);
            }
        } else {
            this.series.writeExternal(dataOutput);
        }
        dataOutput.writeInt(this.seq);
        dataOutput.writeByte(this.periods.length);
        for (n2 = 0; n2 < this.periods.length; ++n2) {
            dataOutput.writeByte(this.periods[n2]);
        }
        dataOutput.writeByte(this.bidAskQueSize);
        dataOutput.writeByte(this.strikeUpLevel);
        dataOutput.writeByte(this.strikeDownLevel);
        dataOutput.writeShort(this.strikePriceMid);
    }

    public void readExternal(DataInput dataInput) throws IOException {
        int n2;
        this.access = dataInput.readInt();
        this.listen = dataInput.readByte();
        this.filter = dataInput.readByte();
        if (this.filter == 0) {
            n2 = dataInput.readShort();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(dataInput.readUTF());
            }
            this.insIds = arrayList.toArray(new String[0]);
        } else {
            this.series = new Series();
            this.series.readExternal(dataInput);
        }
        this.seq = dataInput.readInt();
        try {
            n2 = dataInput.readByte();
            this.periods = new byte[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                this.periods[i3] = dataInput.readByte();
            }
            this.bidAskQueSize = dataInput.readByte();
            this.strikeUpLevel = dataInput.readByte();
            this.strikeDownLevel = dataInput.readByte();
            this.strikePriceMid = dataInput.readShort();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("access=" + ACCESS.getDesc(this.access) + ", ");
        stringBuffer.append("listen=" + LISTEN.getDesc(this.listen) + ", ");
        stringBuffer.append("filter=" + SERIES_DATA.getDesc(this.filter) + ", ");
        stringBuffer.append("bidAskQueSize=" + this.bidAskQueSize + ", ");
        stringBuffer.append("strikeUpLevel=" + this.strikeUpLevel + ", ");
        stringBuffer.append("strikeDownLevel=" + this.strikeDownLevel + ", ");
        stringBuffer.append("strikeMidLevel=" + this.strikePriceMid + ", ");
        if (this.periods.length == 0) {
            stringBuffer.append("periods.length=0, ");
        } else {
            for (n2 = 0; n2 < this.periods.length; ++n2) {
                stringBuffer.append("periods[" + n2 + "]=" + SERIES_DATA.getDesc(this.periods[n2]) + ", ");
            }
        }
        for (n2 = 0; n2 < this.insIds.length; ++n2) {
            stringBuffer.append(this.insIds[n2]);
            stringBuffer.append(", ");
        }
        stringBuffer.append("seq=" + this.seq);
        return stringBuffer.toString();
    }
}

