/*
 * Decompiled with CFR 0.152.
 */
package omni.obj.client;

import hk.com.realink.feed.toolkit.d;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import omni.db.RecSeriesItem;
import omni.obj.client.Dataizable;
import omni.obj.client.Series;
import omni.obj.client.So;

public class SeriesData
implements Dataizable {
    public String insId = "";
    public Series series = new Series();
    public String eff_exp_date;
    public char putCallCode = (char)32;
    public So[] soBid = new So[]{new So(), new So(), new So(), new So(), new So()};
    public So[] soAsk = new So[]{new So(), new So(), new So(), new So(), new So()};
    public int last = 0;
    public int open = 0;
    public int high = 0;
    public int low = 0;
    public long volume = 0L;
    public long turnover = 0L;
    public int prevClosed = 0;
    public int prevChange = 0;
    public long prevUncovered = 0L;
    public long updateTime = 0L;
    byte bidAskQLen = (byte)5;
    public byte db_op;
    public int status;
    public static final byte DB_OP_INSERT = 1;
    public static final byte DB_OP_UPDATE = 2;
    public static final byte DB_OP_REMOVE = 3;
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_SUSPEND = 2;
    public static final int STATUS_ISSUED = 3;
    public static final int STATUS_DELIST = 4;
    public int last1 = 0;
    public int open1 = 0;
    public int high1 = 0;
    public int low1 = 0;
    public long volume1 = 0L;
    public long turnover1 = 0L;
    public short marketStatus = 0;

    public boolean isBidAskSoEqual(SeriesData seriesData, byte by) {
        SeriesData seriesData2 = this;
        if (!seriesData2.isSoEqual(seriesData2.soBid, seriesData.soBid, by)) {
            return false;
        }
        SeriesData seriesData3 = this;
        return seriesData3.isSoEqual(seriesData3.soAsk, seriesData.soAsk, by);
    }

    private boolean isSoEqual(So[] soArray, So[] soArray2, byte n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 < soArray.length && i2 < soArray2.length) {
                if (soArray[i2].isEqual(soArray2[i2])) continue;
                return false;
            }
            if (i2 >= soArray.length && i2 >= soArray2.length) break;
            return false;
        }
        return true;
    }

    public boolean isEqual(SeriesData seriesData, byte by) {
        if (!this.insId.equalsIgnoreCase(seriesData.insId)) {
            return false;
        }
        if (!this.isBidAskSoEqual(seriesData, by)) {
            return false;
        }
        if (this.last != seriesData.last) {
            return false;
        }
        if (this.open != seriesData.open) {
            return false;
        }
        if (this.high != seriesData.high) {
            return false;
        }
        if (this.low != seriesData.low) {
            return false;
        }
        if (this.volume != seriesData.volume) {
            return false;
        }
        if (this.turnover != seriesData.turnover) {
            return false;
        }
        if (this.prevClosed != seriesData.prevClosed) {
            return false;
        }
        if (this.prevChange != seriesData.prevChange) {
            return false;
        }
        if (this.prevUncovered != seriesData.prevUncovered) {
            return false;
        }
        if (this.db_op != seriesData.db_op) {
            return false;
        }
        if (this.last1 != seriesData.last1) {
            return false;
        }
        if (this.open1 != seriesData.open1) {
            return false;
        }
        if (this.high1 != seriesData.high1) {
            return false;
        }
        if (this.low1 != seriesData.low1) {
            return false;
        }
        if (this.volume1 != seriesData.volume1) {
            return false;
        }
        if (this.turnover1 != seriesData.turnover1) {
            return false;
        }
        return this.marketStatus == seriesData.marketStatus;
    }

    public static Calendar expiryDateToCalendar(short s2) {
        int[] nArray = SeriesData.expiryDateToYYMMDD(s2);
        Calendar calendar = Calendar.getInstance();
        calendar.set(nArray[0], nArray[1] - 1, nArray[2]);
        return calendar;
    }

    public static Calendar effExpDateToCalendar(String string) {
        Calendar calendar = null;
        try {
            if (string.length() == 8) {
                int n2 = Integer.parseInt(string.substring(0, 4));
                int n3 = Integer.parseInt(string.substring(4, 6));
                int n4 = Integer.parseInt(string.substring(6, 8));
                calendar = Calendar.getInstance();
                calendar.set(n2, n3 - 1, n4);
            }
        }
        catch (Exception exception) {
            System.out.printf(exception.toString(), new Object[0]);
            calendar = null;
        }
        return calendar;
    }

    public static int[] expiryDateToYYMMDD(short s2) {
        int[] nArray = new int[3];
        int n2 = s2 >> 9 & 0x7F;
        nArray[0] = (short)(n2 + 1989);
        nArray[1] = (short)(s2 >> 5 & 0xF);
        nArray[2] = (short)(s2 & 0x1F);
        return nArray;
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        int n2;
        dataOutput.writeUTF(this.insId);
        this.series.writeExternal(dataOutput);
        dataOutput.writeChar(this.putCallCode);
        for (n2 = 0; n2 < this.bidAskQLen; ++n2) {
            this.soBid[n2].writeExternal(dataOutput);
        }
        for (n2 = 0; n2 < this.bidAskQLen; ++n2) {
            this.soAsk[n2].writeExternal(dataOutput);
        }
        dataOutput.writeInt(this.last);
        dataOutput.writeInt(this.open);
        dataOutput.writeInt(this.high);
        dataOutput.writeInt(this.low);
        dataOutput.writeLong(this.volume);
        dataOutput.writeInt(this.prevClosed);
        dataOutput.writeInt(this.prevChange);
        dataOutput.writeLong(this.prevUncovered);
        dataOutput.writeLong(this.updateTime);
        dataOutput.writeLong(this.turnover);
        dataOutput.writeByte(this.db_op);
        dataOutput.writeUTF(this.eff_exp_date);
        if (RecSeriesItem.verNum == 1.0f) {
            dataOutput.writeInt(this.last1);
            dataOutput.writeInt(this.open1);
            dataOutput.writeInt(this.high1);
            dataOutput.writeInt(this.low1);
            dataOutput.writeLong(this.volume1);
            dataOutput.writeLong(this.turnover1);
        }
    }

    public void readExternal(DataInput dataInput) throws IOException {
        int n2;
        this.insId = dataInput.readUTF();
        this.series = new Series();
        this.series.readExternal(dataInput);
        this.putCallCode = dataInput.readChar();
        for (n2 = 0; n2 < this.bidAskQLen; ++n2) {
            this.soBid[n2] = new So();
            this.soBid[n2].readExternal(dataInput);
        }
        for (n2 = 0; n2 < this.bidAskQLen; ++n2) {
            this.soAsk[n2] = new So();
            this.soAsk[n2].readExternal(dataInput);
        }
        this.last = dataInput.readInt();
        this.open = dataInput.readInt();
        this.high = dataInput.readInt();
        this.low = dataInput.readInt();
        this.volume = dataInput.readLong();
        this.prevClosed = dataInput.readInt();
        this.prevChange = dataInput.readInt();
        this.prevUncovered = dataInput.readLong();
        this.updateTime = dataInput.readLong();
        this.turnover = dataInput.readLong();
        this.db_op = dataInput.readByte();
        this.eff_exp_date = dataInput.readUTF();
        if (RecSeriesItem.verNum == 1.0f) {
            this.last1 = dataInput.readInt();
            this.open1 = dataInput.readInt();
            this.high1 = dataInput.readInt();
            this.low1 = dataInput.readInt();
            this.volume1 = dataInput.readLong();
            this.turnover1 = dataInput.readLong();
        }
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("insId=").append(this.insId).append(", ");
        stringBuilder.append("series=").append(this.series.toString()).append(", ");
        stringBuilder.append("eff_exp_date=").append(this.eff_exp_date).append(", ");
        stringBuilder.append("putCallCode=").append(this.putCallCode).append(", ");
        stringBuilder.append(d.LR);
        stringBuilder.append("[BID]");
        for (n2 = 0; n2 < this.bidAskQLen; ++n2) {
            stringBuilder.append("[p=").append(d.pad("" + this.soBid[n2].premium, 11, "0"));
            stringBuilder.append(", d=").append(d.pad("" + this.soBid[n2].demand, 11, "0")).append("]");
        }
        stringBuilder.append(d.LR);
        stringBuilder.append("[ASK]");
        for (n2 = 0; n2 < this.bidAskQLen; ++n2) {
            stringBuilder.append("[p=").append(d.pad("" + this.soAsk[n2].premium, 11, "0"));
            stringBuilder.append(", d=").append(d.pad("" + this.soAsk[n2].demand, 11, "0")).append("]");
        }
        stringBuilder.append(d.LR);
        stringBuilder.append("(no=").append(this.last).append(", ");
        stringBuilder.append("op=").append(this.open).append(", ");
        stringBuilder.append("hi=").append(this.high).append(", ");
        stringBuilder.append("lo=").append(this.low).append(", ");
        stringBuilder.append("vo=").append(this.volume).append(", ");
        stringBuilder.append("tv=").append(this.turnover).append("), ");
        stringBuilder.append("(no1=").append(this.last1).append(", ");
        stringBuilder.append("op1=").append(this.open1).append(", ");
        stringBuilder.append("hi1=").append(this.high1).append(", ");
        stringBuilder.append("lo1=").append(this.low1).append(", ");
        stringBuilder.append("vo1=").append(this.volume1).append(", ");
        stringBuilder.append("tv1=").append(this.turnover1).append("), ");
        stringBuilder.append("pcl=").append(this.prevClosed).append(", ");
        stringBuilder.append("pchg=").append(this.prevChange).append(", ");
        stringBuilder.append("pUncovered=").append(this.prevUncovered).append(", ");
        stringBuilder.append("db_op=").append(this.db_op).append(", ");
        stringBuilder.append("status=").append(this.status).append(", ");
        stringBuilder.append("marketStatus=").append(this.marketStatus).append(", ");
        stringBuilder.append("updateTime=").append(this.updateTime);
        return stringBuilder.toString();
    }
}

