/*
 * Decompiled with CFR 0.152.
 */
package omni.obj.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import omni.obj.client.Dataizable;
import omni.obj.client.SeriesData;

public class Series
implements Dataizable {
    public byte country = 0;
    public byte market = 0;
    public byte instrument_group = 0;
    public byte modifier = 0;
    public short commodity = 0;
    public short expiration_date = 0;
    public int strike_price = 0;
    public short expirationYear = 0;
    public byte expirationMonth = 0;
    public byte expirationDay = 0;

    public Series() {
    }

    public Series(byte by, byte by2, byte by3, byte by4, short s2, short s3, int n2) {
        this.country = by;
        this.market = by2;
        this.instrument_group = by3;
        this.modifier = by4;
        this.commodity = s2;
        this.setExpirationDate(s3);
        this.strike_price = n2;
    }

    public void setExpirationDate(short s2) {
        this.expiration_date = s2;
        Calendar calendar = SeriesData.expiryDateToCalendar(this.expiration_date);
        this.expirationYear = (short)calendar.get(1);
        this.expirationMonth = (byte)(calendar.get(2) + 1);
        this.expirationDay = (byte)calendar.get(5);
    }

    public String getKey() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.country).append("-").append(this.market).append("-").append(this.instrument_group);
        stringBuilder.append("-").append(this.modifier).append("-").append(this.commodity);
        stringBuilder.append("-").append(this.expiration_date).append("-").append(this.strike_price);
        return stringBuilder.toString();
    }

    public String getInstrumentGroupKey() {
        return this.country + "-" + this.market + "-" + this.instrument_group;
    }

    public String getInstClassKey() {
        return this.country + "-" + this.market + "-" + this.instrument_group + "-" + this.modifier + "-" + this.commodity;
    }

    public String getMarketKey() {
        return this.country + "-" + this.market;
    }

    public String getUnderlyingKey() {
        return this.country + "-" + this.market + "-" + this.modifier + "-" + this.commodity;
    }

    public Integer getCommodityKey() {
        return new Integer(this.commodity);
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.country);
        dataOutput.writeByte(this.market);
        dataOutput.writeByte(this.instrument_group);
        dataOutput.writeByte(this.modifier);
        dataOutput.writeShort(this.commodity);
        dataOutput.writeShort(this.expiration_date);
        dataOutput.writeInt(this.strike_price);
    }

    public void readExternal(DataInput dataInput) throws IOException {
        this.country = dataInput.readByte();
        this.market = dataInput.readByte();
        this.instrument_group = dataInput.readByte();
        this.modifier = dataInput.readByte();
        this.commodity = dataInput.readShort();
        this.setExpirationDate(dataInput.readShort());
        this.strike_price = dataInput.readInt();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("country=").append(this.country).append(", ");
        stringBuilder.append("market=").append(this.market).append(", ");
        stringBuilder.append("commodity=").append(this.commodity).append(", ");
        stringBuilder.append("instrument_group=").append(this.instrument_group).append(", ");
        stringBuilder.append("modifier=").append(this.modifier).append(", ");
        stringBuilder.append("expiration_date=").append(this.expiration_date).append(", ");
        stringBuilder.append("expirationYear=").append(this.expirationYear).append(", ");
        stringBuilder.append("expirationMonth=").append(this.expirationMonth).append(", ");
        stringBuilder.append("expirationDay=").append(this.expirationDay).append(", ");
        stringBuilder.append("strike_price=").append(this.strike_price);
        return stringBuilder.toString();
    }
}

