/*
 * Decompiled with CFR 0.152.
 */
package omni.obj.client;

import java.util.Map;
import omdd.brdcast.obj.MarketStatus;
import omni.obj.client.MarketStatusMap;
import omni.obj.client.SeriesData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketStatusHdr {
    public static final int OPENALLOC = 1;
    public static final int CLOSE = 2;
    public static final int OPEN = 3;
    public static final int PREOPEN = 4;
    public static final int PREOPENALLOC = 5;
    public static final int PAUSE = 6;
    public static final int PRE_MKT_ACT = 7;
    public static final int CL_START = 8;
    public static final int CL_CLOSE = 9;
    public static final int AHT_CLOSE = 10;
    public static final int AHT_CLR_INFO = 11;
    public static final int AHT_INACT_T_ORDER = 12;
    public static final int ANT_NEXT_DAY = 13;
    public static final int AHT_OPEN = 14;
    public static final int AHT_OPEN_PL = 15;
    public static final int AHT_PRE_MKT_ACT = 16;
    public static final int OPEN_PL = 17;
    public static final int CLOSE_TODAY = 18;
    public static final int OPEN_DPL = 19;
    public static final int FAILOVER = 20;
    public static final int STYPE_REGULAR = 1;
    public static final int STYPE_ALL = 2;
    public static final int STYPE_AHFT = 3;
    public static final int CLOSE_TODAY_E = 21;
    public static final int AHT_CLOSE_E = 22;
    public static final int OPEN_DPL_VCM = 23;
    public static final int OPEN_VCM = 24;
    public static final int VCM_COOL_OFF_DPL = 25;
    public static final int VCM_COOL_OFF = 26;
    public static final int RESET_VCM = 27;
    public MarketStatusMap mkStatusMap = new MarketStatusMap();
    private static final int[] v1 = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27};
    private static final String[] v2 = new String[]{"OPENALLOC", "CLOSE", "OPEN", "PREOPEN", "PREOPENALLOC", "PAUSE", "PRE_MKT_ACT", "CL_START", "CL_CLOSE", "AHT_CLOSE", "AHT_CLR_INFO", "AHT_INACT_T_ORDER", "ANT_NEXT_DAY", "AHT_OPEN", "AHT_OPEN_PL", "AHT_PRE_MKT_ACT", "OPEN_PL", "CLOSE_TODAY", "OPEN_DPL", "FAILOVER", "CLOSE_TODAY_E", "AHT_CLOSE_E", "OPEN_DPL_VCM", "OPEN_VCM", "VCM_COOL_OFF_DPL", "VCM_COOL_OFF", "RESET_VCM"};
    private static final int[] vt = new int[]{1, 2, 3};
    private static final String[] vts = new String[]{"STYPE_REGULAR", "STYPE_ALL", "STYPE_AHFT"};

    public void setMarketStatusMap(MarketStatusMap marketStatusMap) {
        this.mkStatusMap.statusMap.putAll(marketStatusMap.statusMap);
    }

    public void clearMarketStatusMap() {
        this.mkStatusMap.statusMap.clear();
    }

    public Map<String, MarketStatus> getStatusMap() {
        return this.mkStatusMap.statusMap;
    }

    public String getDesc(int n2) {
        if (v1.length == v2.length) {
            for (int i2 = 0; i2 < v1.length; ++i2) {
                if (v1[i2] != n2) continue;
                return v2[i2];
            }
        }
        return "";
    }

    public String getStatusTypeDesc(int n2) {
        if (vt.length == vts.length) {
            for (int i2 = 0; i2 < vt.length; ++i2) {
                if (vt[i2] != n2) continue;
                return vts[i2];
            }
        }
        return "";
    }

    public String print(MarketStatus marketStatus) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[MARKET_STATUS]");
        if (marketStatus != null) {
            stringBuilder.append("stateLevel=").append(marketStatus.a);
            stringBuilder.append(", market=").append(marketStatus.b);
            stringBuilder.append(", instrument=").append(marketStatus.c);
            stringBuilder.append(", commodityCode=").append(marketStatus.e);
            stringBuilder.append(", orderBookId=").append(marketStatus.d);
            MarketStatusHdr marketStatusHdr = this;
            stringBuilder.append(", state=").append(marketStatus.g).append(":").append(this.getDesc(marketStatus.g)).append(":").append(marketStatusHdr.getStatusTypeDesc(marketStatusHdr.getStatusType(marketStatus.g)));
            stringBuilder.append(", secToStateChg=").append(marketStatus.f);
            stringBuilder.append(", priority=").append(marketStatus.h);
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }

    public int getStatusType(int n2) {
        int n3 = -1;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n3 = 1;
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                n3 = 2;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                n3 = 3;
            }
        }
        return n3;
    }

    public MarketStatus setMarketStatus(SeriesData seriesData) {
        MarketStatus marketStatus = null;
        short s2 = 0;
        int n2 = 0;
        for (MarketStatus marketStatus2 : this.mkStatusMap.statusMap.values()) {
            if (!this.isVaildSeries(seriesData, marketStatus2)) continue;
            if (marketStatus2.h > s2) {
                marketStatus = marketStatus2;
                s2 = marketStatus2.h;
                n2 = marketStatus2.a;
                continue;
            }
            if (marketStatus2.h != s2 || marketStatus2.a <= n2) continue;
            marketStatus = marketStatus2;
            s2 = marketStatus2.h;
            n2 = marketStatus2.a;
        }
        if (marketStatus != null) {
            seriesData.marketStatus = (short)marketStatus.g;
        }
        return marketStatus;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private boolean isVaildSeries(SeriesData seriesData, MarketStatus marketStatus) {
        boolean bl = false;
        int n2 = 0;
        block7: do {
            switch (n2 == 0 ? marketStatus.a : n2) {
                case 1: {
                    if (marketStatus.b != seriesData.series.market) return bl;
                    n2 = 99;
                    continue block7;
                }
                case 2: {
                    if (marketStatus.b != seriesData.series.market) return bl;
                    if (marketStatus.c != seriesData.series.instrument_group) return bl;
                    n2 = 99;
                    continue block7;
                }
                case 3: 
                case 5: {
                    if (marketStatus.b != seriesData.series.market) return bl;
                    if (marketStatus.c != seriesData.series.instrument_group) return bl;
                    if (marketStatus.e != seriesData.series.commodity) return bl;
                    n2 = 99;
                    continue block7;
                }
                case 4: {
                    return bl;
                }
                case 99: {
                    return true;
                }
            }
            return bl;
        } while (true);
        return bl;
    }
}

