/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows.queueBrokerColor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import leaseLineQuote.f;
import leaseLineQuote.multiWindows.GUI.LanguageControl;
import leaseLineQuote.multiWindows.MultiWindowsControl;
import leaseLineQuote.multiWindows.queueBrokerColor.BrokerColorChecker;
import leaseLineQuote.multiWindows.queueBrokerColor.BrokerColorListCellRenderer;
import leaseLineQuote.multiWindows.queueBrokerColor.BrokerColorListModel;
import leaseLineQuote.multiWindows.queueBrokerColor.BrokerColorSetting;
import leaseLineQuote.multiWindows.queueBrokerColor.CellButtonsMouseListener;
import leaseLineQuote.multiWindows.queueBrokerColor.DeleteCodeListener;

public class BrokerColorDialog
extends JDialog {
    private final BrokerColorChecker bcc = BrokerColorChecker.getInstance();
    private final BrokerColorListModel settingModel = new BrokerColorListModel();
    private JTextField BrokerCodeInfo;
    private JButton jButton1;
    private JColorChooser jColorChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JPanel previewPanel;

    public static void open() {
        BrokerColorDialog brokerColorDialog = new BrokerColorDialog(null, true);
        brokerColorDialog.setLocationRelativeTo(null);
        brokerColorDialog.setVisible(true);
    }

    public static void open(Short serializable) {
        BrokerColorDialog brokerColorDialog = new BrokerColorDialog(null, true);
        brokerColorDialog.setCode((short)serializable);
        brokerColorDialog.setLocationRelativeTo(null);
        serializable = brokerColorDialog.bcc.getColor((short)serializable);
        if (serializable != null) {
            brokerColorDialog.jColorChooser1.setColor((Color)serializable);
        }
        brokerColorDialog.setVisible(true);
    }

    public BrokerColorDialog(Frame object, boolean bl) {
        super((Frame)object, bl);
        this.initComponents();
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(10, this.jScrollPane1.getHorizontalScrollBar().getHeight()));
        this.jList1.setBackground(f.y);
        this.jList1.setCellRenderer(new BrokerColorListCellRenderer(new DeleteCodeListener(this){
            private /* synthetic */ BrokerColorDialog a;
            {
                this.a = brokerColorDialog;
            }

            @Override
            public final void deleteCode(Short s2) {
                this.a.deleteCode(s2);
            }
        }));
        object = this.jColorChooser1.getChooserPanels();
        this.jColorChooser1.setChooserPanels(new AbstractColorChooserPanel[]{object[0]});
        this.jColorChooser1.setPreviewPanel(this.previewPanel);
        this.jColorChooser1.getSelectionModel().addChangeListener(new ChangeListener(this){
            private /* synthetic */ BrokerColorDialog a;
            {
                this.a = brokerColorDialog;
            }

            @Override
            public final void stateChanged(ChangeEvent changeEvent) {
                this.a.updateColor();
            }
        });
        object = this.bcc.getCustSetting();
        for (Short s2 : object.keySet()) {
            Color color = (Color)object.get(s2);
            this.settingModel.add(s2, color);
        }
        this.updateColor();
        CellButtonsMouseListener cellButtonsMouseListener = new CellButtonsMouseListener();
        this.jList1.addMouseListener(cellButtonsMouseListener);
        this.updateLanguage();
    }

    public void updateLanguage() {
        if (LanguageControl.getLanguageID() == 1) {
            this.setTitle("Broker Code Color Setting");
            this.jButton1.setText("Add / Set");
            return;
        }
        this.setTitle("\u7d93\u7d00\u865f\u78bc\u984f\u8272\u8a2d\u5b9a");
        this.jButton1.setText("\u65b0\u589e / \u8a2d\u5b9a");
    }

    private void updateColor() {
        this.previewPanel.setBackground(f.y);
        Color color = this.jColorChooser1.getColor();
        this.jLabel1.setForeground(color);
        this.jLabel2.setBackground(color);
    }

    private void setPreviewCode(String string) {
        this.jLabel1.setText(string);
    }

    public void setCode(short s2) {
        String string = Short.toString(s2);
        this.setPreviewCode(string);
        this.BrokerCodeInfo.setText(string);
    }

    public Short getCode() {
        try {
            return Short.parseShort(this.BrokerCodeInfo.getText());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void initComponents() {
        this.previewPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel3 = new JPanel();
        this.jColorChooser1 = new JColorChooser();
        this.jPanel4 = new JPanel();
        this.BrokerCodeInfo = new JTextField();
        this.jButton1 = new JButton();
        this.previewPanel.setMinimumSize(new Dimension(120, 25));
        this.previewPanel.setPreferredSize(new Dimension(120, 25));
        this.previewPanel.setLayout(new FlowLayout(1, 10, 5));
        this.jLabel1.setFont(new Font("Arial", 0, 14));
        this.jLabel1.setText("4830");
        this.previewPanel.add(this.jLabel1);
        this.jLabel2.setFont(new Font("Arial", 0, 14));
        this.jLabel2.setText("             ");
        this.jLabel2.setOpaque(true);
        this.previewPanel.add(this.jLabel2);
        this.setDefaultCloseOperation(2);
        this.setTitle("Broker Code Color Setting");
        this.setMinimumSize(new Dimension(500, 250));
        this.setPreferredSize(new Dimension(540, 250));
        this.setResizable(false);
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setMaximumSize(new Dimension(95, 130));
        this.jScrollPane1.setMinimumSize(new Dimension(95, 130));
        this.jScrollPane1.setPreferredSize(new Dimension(95, 130));
        this.jList1.setModel(this.settingModel);
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(this){
            private /* synthetic */ BrokerColorDialog a;
            {
                this.a = brokerColorDialog;
            }

            @Override
            public final void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.a.jList1ValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Before");
        this.jPanel3.setLayout(new BorderLayout());
        this.jColorChooser1.setMinimumSize(new Dimension(300, 200));
        this.jColorChooser1.setPreferredSize(new Dimension(300, 200));
        this.jPanel3.add((Component)this.jColorChooser1, "Center");
        this.jPanel4.setLayout(new FlowLayout(1, 20, 5));
        this.BrokerCodeInfo.setMinimumSize(new Dimension(60, 24));
        this.BrokerCodeInfo.setPreferredSize(new Dimension(60, 24));
        this.BrokerCodeInfo.addKeyListener(new KeyAdapter(this){
            private /* synthetic */ BrokerColorDialog a;
            {
                this.a = brokerColorDialog;
            }

            @Override
            public final void keyReleased(KeyEvent keyEvent) {
                this.a.BrokerCodeInfoKeyReleased(keyEvent);
            }

            @Override
            public final void keyTyped(KeyEvent keyEvent) {
                this.a.BrokerCodeInfoKeyTyped(keyEvent);
            }
        });
        this.jPanel4.add(this.BrokerCodeInfo);
        this.jButton1.setText("Add / Set");
        this.jButton1.addActionListener(new ActionListener(this){
            private /* synthetic */ BrokerColorDialog a;
            {
                this.a = brokerColorDialog;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.a.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.jButton1);
        this.jPanel3.add((Component)this.jPanel4, "Last");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.pack();
    }

    private void BrokerCodeInfoKeyTyped(KeyEvent keyEvent) {
        String string;
        char c2 = keyEvent.getKeyChar();
        switch (c2) {
            case '\n': {
                this.addOrSetBroker();
                return;
            }
        }
        if (c2 < '0' || c2 > '9') {
            keyEvent.consume();
        }
        if (this.BrokerCodeInfo.getText().length() > 3 && ((string = this.BrokerCodeInfo.getSelectedText()) == null || this.BrokerCodeInfo.getSelectedText().length() <= 0)) {
            keyEvent.consume();
        }
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.addOrSetBroker();
    }

    private void addOrSetBroker() {
        try {
            short s2 = Short.parseShort(this.BrokerCodeInfo.getText());
            if (s2 > 0 && s2 <= 9999 && !this.bcc.isFixBroker(s2)) {
                Color color = this.jColorChooser1.getColor();
                if (!this.settingModel.set(s2, color)) {
                    this.settingModel.add(s2, color);
                }
                this.bcc.set(s2, color);
                this.BrokerCodeInfo.selectAll();
                MultiWindowsControl.getInstance().refreshColor();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void updateSelected() {
        BrokerColorSetting brokerColorSetting = (BrokerColorSetting)this.jList1.getSelectedValue();
        if (brokerColorSetting != null) {
            this.setCode(brokerColorSetting.code);
            this.jColorChooser1.setColor(brokerColorSetting.c);
            return;
        }
        this.setCode((short)0);
    }

    private void deleteCode(Short s2) {
        if (s2 != null) {
            this.settingModel.remove(s2);
            this.bcc.remove(s2);
        }
    }

    private void jList1ValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updateSelected();
        }
    }

    private void BrokerCodeInfoKeyReleased(KeyEvent serializable) {
        try {
            if (this.BrokerCodeInfo.getText().length() > 0) {
                BrokerColorDialog brokerColorDialog = this;
                brokerColorDialog.setPreviewCode(brokerColorDialog.BrokerCodeInfo.getText().trim());
            }
            return;
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
            return;
        }
    }

    public static void main(String[] objectArray) {
        try {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(BrokerColorDialog.class.getName()).log(Level.SEVERE, null, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(BrokerColorDialog.class.getName()).log(Level.SEVERE, null, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(BrokerColorDialog.class.getName()).log(Level.SEVERE, null, illegalAccessException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Logger.getLogger(BrokerColorDialog.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                BrokerColorDialog brokerColorDialog = new BrokerColorDialog((Frame)new JFrame(), true);
                brokerColorDialog.addWindowListener(new WindowAdapter(this){

                    @Override
                    public final void windowClosing(WindowEvent windowEvent) {
                    }
                });
                brokerColorDialog.setVisible(true);
            }
        });
    }
}

