/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows;

import hk.com.realink.casvcm.typeimple.VcmCasRes;
import hk.com.realink.quot.ams.StaticRoot;
import hk.com.realink.quot.typeimple.MarketRes;
import hk.com.realink.quot.typeimple.multiwin.MultiWinSctyReq;
import hk.com.realink.quot.typeimple.multiwin.MultiWinSctyRes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import leaseLineQuote.multiWindows.NewSty2StockFrame;
import leaseLineQuote.multiWindows.StockRequestItemInterface;

public class StockRequestProcess {
    private final Map<String, Set<NewSty2StockFrame>> code2FrameList = new HashMap<String, Set<NewSty2StockFrame>>();
    private final Map<NewSty2StockFrame, String> frame2CodeList = new HashMap<NewSty2StockFrame, String>();
    private final Set<StockRequestItemInterface> stockRequestItemList = new HashSet<StockRequestItemInterface>();
    private final HashSet<String> pageNumberSet = new HashSet();

    public StockRequestProcess() {
        this.pageNumberSet.clear();
    }

    public void addStockRequestItemInterface(StockRequestItemInterface stockRequestItemInterface) {
        if (stockRequestItemInterface != null) {
            this.stockRequestItemList.add(stockRequestItemInterface);
        }
    }

    public void removeStockRequestItemInterface(StockRequestItemInterface stockRequestItemInterface) {
        if (stockRequestItemInterface != null) {
            this.stockRequestItemList.remove(stockRequestItemInterface);
        }
    }

    public void updateIndex(MarketRes marketRes) {
        for (StockRequestItemInterface stockRequestItemInterface : this.stockRequestItemList) {
            try {
                stockRequestItemInterface.updateIndex(marketRes);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
    }

    public void updateMultiWinSctyRes(MultiWinSctyRes multiWinSctyRes) {
        for (StockRequestItemInterface stockRequestItemInterface : this.stockRequestItemList) {
            try {
                stockRequestItemInterface.updateMultiWinSctyRes(multiWinSctyRes);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
    }

    public void updateStatic(StaticRoot staticRoot) {
        for (StockRequestItemInterface stockRequestItemInterface : this.stockRequestItemList) {
            try {
                stockRequestItemInterface.updateStatic(staticRoot);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
    }

    public void updateVcmCas(VcmCasRes vcmCasRes) {
        for (StockRequestItemInterface stockRequestItemInterface : this.stockRequestItemList) {
            try {
                stockRequestItemInterface.updateVcmCas(vcmCasRes);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
    }

    public void addPageNumber(String string) {
        this.pageNumberSet.add(string);
    }

    public boolean isPageNumber(String string) {
        return this.pageNumberSet.contains(string);
    }

    private void addStockFrame(String string, NewSty2StockFrame newSty2StockFrame) {
        if (newSty2StockFrame != null) {
            this.removeStockFrame(newSty2StockFrame);
            this.frame2CodeList.put(newSty2StockFrame, string);
            Set<NewSty2StockFrame> set = this.code2FrameList.get(string);
            if (set == null) {
                set = new HashSet<NewSty2StockFrame>();
                this.code2FrameList.put(string, set);
            }
            set.add(newSty2StockFrame);
        }
    }

    private void removeStockFrame(NewSty2StockFrame newSty2StockFrame) {
        String string;
        if (newSty2StockFrame != null && (string = this.frame2CodeList.get(newSty2StockFrame)) != null) {
            this.frame2CodeList.remove(newSty2StockFrame);
            Set<NewSty2StockFrame> set = this.code2FrameList.get(string);
            if (set != null) {
                set.remove(newSty2StockFrame);
                if (set.size() == 0) {
                    this.code2FrameList.remove(string);
                }
            }
        }
    }

    private MultiWinSctyReq getStockRequest(String string) {
        if (this.isPageNumber(string)) {
            MultiWinSctyReq multiWinSctyReq = new MultiWinSctyReq(string, 1);
            multiWinSctyReq.addFrame(2);
            return multiWinSctyReq;
        }
        MultiWinSctyReq multiWinSctyReq = new MultiWinSctyReq(string, 2);
        Object object = this.code2FrameList.get(string);
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                NewSty2StockFrame object2 = (NewSty2StockFrame)((Object)object.next());
                if (object2.isMainFrame()) {
                    multiWinSctyReq.addFrame(2);
                }
                if (!multiWinSctyReq.isRequestFrame(4) && object2.isOrderFrame()) {
                    if (object2.getOrderQueueSize() > 5) {
                        multiWinSctyReq.addFrame(4);
                    } else {
                        multiWinSctyReq.addFrame(512);
                    }
                }
                if (object2.isQueueFrame()) {
                    multiWinSctyReq.addFrame(8);
                }
                if (object2.isTradeFrame()) {
                    multiWinSctyReq.addFrame(16);
                }
                if (object2.isGraphicFrame()) {
                    multiWinSctyReq.addFrame(32);
                }
                if (object2.isNoteFrame()) {
                    multiWinSctyReq.addFrame(128);
                }
                if (object2.isSctyNewsFrame()) {
                    multiWinSctyReq.addFrame(256);
                }
                if (!object2.isRelatedFrame()) continue;
                multiWinSctyReq.addFrame(64);
            }
        }
        for (StockRequestItemInterface stockRequestItemInterface : this.stockRequestItemList) {
            MultiWinSctyReq multiWinSctyReq2 = stockRequestItemInterface.getRequest(string);
            if (multiWinSctyReq2 == null) continue;
            if (multiWinSctyReq2.isRequestFrame(2)) {
                multiWinSctyReq.addFrame(2);
            }
            if (multiWinSctyReq2.isRequestFrame(4)) {
                multiWinSctyReq.addFrame(4);
            }
            if (multiWinSctyReq2.isRequestFrame(512)) {
                multiWinSctyReq.addFrame(512);
            }
            if (multiWinSctyReq2.isRequestFrame(8)) {
                multiWinSctyReq.addFrame(8);
            }
            if (multiWinSctyReq2.isRequestFrame(16)) {
                multiWinSctyReq.addFrame(16);
            }
            if (multiWinSctyReq2.isRequestFrame(32)) {
                multiWinSctyReq.addFrame(32);
            }
            if (multiWinSctyReq2.isRequestFrame(128)) {
                multiWinSctyReq.addFrame(128);
            }
            if (multiWinSctyReq2.isRequestFrame(256)) {
                multiWinSctyReq.addFrame(256);
            }
            if (!multiWinSctyReq2.isRequestFrame(64)) continue;
            multiWinSctyReq.addFrame(64);
        }
        if (multiWinSctyReq.haveRequestFrame()) {
            multiWinSctyReq.setListenMode(1);
        }
        return multiWinSctyReq;
    }

    public synchronized void add(String string, NewSty2StockFrame newSty2StockFrame) {
        this.addStockFrame(string, newSty2StockFrame);
    }

    public synchronized void remove(NewSty2StockFrame newSty2StockFrame) {
        this.removeStockFrame(newSty2StockFrame);
    }

    private void printList() {
        System.out.println();
        System.out.println("Start List");
        for (NewSty2StockFrame newSty2StockFrame : this.frame2CodeList.keySet()) {
            System.out.println(this.frame2CodeList.get(newSty2StockFrame) + " : " + newSty2StockFrame.getSctyCode() + " - " + newSty2StockFrame.isTradeWin());
        }
        System.out.println("End List");
        System.out.println();
    }

    public synchronized boolean isNeededStock(String string) {
        if (this.code2FrameList.containsKey(string)) {
            return true;
        }
        for (StockRequestItemInterface stockRequestItemInterface : this.stockRequestItemList) {
            if (!stockRequestItemInterface.isNeededStock(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isFrameRequestStock(String string) {
        return this.code2FrameList.containsKey(string);
    }

    public synchronized List<MultiWinSctyReq> getRequests() {
        String[] stringArray = this.getStockCodeList();
        ArrayList<MultiWinSctyReq> arrayList = new ArrayList<MultiWinSctyReq>();
        for (String string : stringArray) {
            arrayList.add(this.getStockRequest(string));
        }
        return arrayList;
    }

    public synchronized MultiWinSctyReq getRequest(String string) {
        return this.getStockRequest(string);
    }

    public String[] getStockCodeList() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(this.code2FrameList.keySet());
        for (StockRequestItemInterface stockRequestItemInterface : this.stockRequestItemList) {
            for (String string : stockRequestItemInterface.getStockCodeList()) {
                treeSet.add(string);
            }
        }
        TreeSet<String> treeSet2 = treeSet;
        return treeSet2.toArray(new String[treeSet2.size()]);
    }
}

