/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.multiWindows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import leaseLineQuote.StyledFont;
import leaseLineQuote.StyledFrame;
import leaseLineQuote.f;
import leaseLineQuote.multiWindows.GUI.CustomLayoutSettingInterface;
import leaseLineQuote.multiWindows.MultiWindowsControl;
import leaseLineQuote.multiWindows.control.DragControl;

public class CandleIFrame
extends StyledFrame
implements CustomLayoutSettingInterface {
    private final DragControl dc = new DragControl(this);
    private int sctyCode = 0;
    private StyledFrame styledFrame = null;
    private JFrame outerFrame = null;
    private boolean isOuter = false;
    private boolean isRequestOuter = false;
    private boolean lastIsOuter = false;
    private Point outerFramePoint = null;
    private Dimension outFrameDimension = null;
    private JButton CloseButton;
    private JButton OuterButton;
    private JPanel WinButtonPanel;
    private JPanel contentPanel;
    private JPanel topPanel;
    public JLabel typeLabel;

    public CandleIFrame() {
        this.initComponents();
        this.dc.putListener(this.typeLabel);
        this.CloseButton.setName("CandleIFrame");
        this.setResizable(true);
        this.setSize(800, 600);
        this.setLocation(0, 0);
        this.updateColor();
    }

    public void init(StyledFrame styledFrame) {
        if (styledFrame != null) {
            this.styledFrame = styledFrame;
            this.contentPanel.setBackground(Color.red);
            this.contentPanel.add((Component)styledFrame, "Center");
            styledFrame.setVisible(true);
        }
    }

    public void setSctyCode(int n2) {
        this.sctyCode = n2;
    }

    public void updateColor() {
        this.typeLabel.setBackground(f.H);
        this.typeLabel.setForeground(f.I);
        this.setBorder(BorderFactory.createLineBorder(f.aD, 1));
        this.getContentPane().setVisible(false);
        this.getContentPane().setVisible(true);
    }

    public void setEnglish() {
        this.typeLabel.setFont(StyledFont.PLAINFONT);
        this.typeLabel.setText("Candle Chart");
    }

    public void setChinese() {
        this.typeLabel.setFont(StyledFont.PLAIN_CHINESE);
        this.typeLabel.setText("\u9670\u967d\u71ed\u5716");
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.typeLabel = new JLabel();
        this.WinButtonPanel = new JPanel();
        this.OuterButton = new JButton();
        this.CloseButton = new JButton();
        this.contentPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.topPanel.setLayout(new BorderLayout());
        this.typeLabel.setHorizontalAlignment(0);
        this.typeLabel.setText("\u9670\u967d\u71ed\u5716");
        this.typeLabel.setBorder(BorderFactory.createBevelBorder(0));
        this.typeLabel.setOpaque(true);
        this.typeLabel.setRequestFocusEnabled(false);
        this.typeLabel.addMouseListener(new MouseAdapter(this){
            private /* synthetic */ CandleIFrame a;
            {
                this.a = candleIFrame;
            }

            @Override
            public final void mouseEntered(MouseEvent mouseEvent) {
                this.a.typeLabelMouseEntered(mouseEvent);
            }

            @Override
            public final void mouseExited(MouseEvent mouseEvent) {
                this.a.typeLabelMouseExited(mouseEvent);
            }
        });
        this.topPanel.add((Component)this.typeLabel, "Center");
        this.WinButtonPanel.setLayout(new FlowLayout(2, 0, 0));
        this.OuterButton.setFont(new Font("Arial", 0, 12));
        this.OuterButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/openbrower_1.gif")));
        this.OuterButton.setAlignmentY(0.0f);
        this.OuterButton.setBorder(null);
        this.OuterButton.setMargin(new Insets(0, 0, 0, 0));
        this.OuterButton.setOpaque(false);
        this.OuterButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/openbrower_2.gif")));
        this.OuterButton.addActionListener(new ActionListener(this){
            private /* synthetic */ CandleIFrame a;
            {
                this.a = candleIFrame;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.a.OuterButtonActionPerformed(actionEvent);
            }
        });
        this.WinButtonPanel.add(this.OuterButton);
        this.CloseButton.setFont(new Font("Arial", 0, 12));
        this.CloseButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/closewindow_1.gif")));
        this.CloseButton.setAlignmentY(0.0f);
        this.CloseButton.setBorder(null);
        this.CloseButton.setMargin(new Insets(0, 0, 0, 0));
        this.CloseButton.addActionListener(new ActionListener(this){
            private /* synthetic */ CandleIFrame a;
            {
                this.a = candleIFrame;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.a.CloseButtonActionPerformed(actionEvent);
            }
        });
        this.WinButtonPanel.add(this.CloseButton);
        this.topPanel.add((Component)this.WinButtonPanel, "East");
        this.getContentPane().add((Component)this.topPanel, "North");
        this.contentPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.pack();
    }

    private void typeLabelMouseEntered(MouseEvent mouseEvent) {
    }

    private void typeLabelMouseExited(MouseEvent mouseEvent) {
    }

    private void CloseButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.lastIsOuter = false;
    }

    private void OuterButtonActionPerformed(ActionEvent actionEvent) {
        if (this.isOuter) {
            this.outerFramePoint = this.outerFrame.getLocation();
            this.outFrameDimension = this.outerFrame.getSize();
            this.lastIsOuter = false;
            this.closeOuterFrame();
            return;
        }
        this.toOuterFrame(true);
    }

    @Override
    public void setVisible(boolean bl) {
        try {
            if (!this.isOuter) {
                super.setVisible(bl);
                if (bl) {
                    this.CloseButton.setVisible(true);
                    this.isRequestOuter = bl && this.lastIsOuter;
                    this.toFront();
                }
                if (this.styledFrame != null) {
                    this.styledFrame.setVisible(bl);
                }
                if (this.isRequestOuter) {
                    if (this.styledFrame != null) {
                        this.styledFrame.setVisible(true);
                    }
                    this.isRequestOuter = false;
                    this.toOuterFrame(false);
                }
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void setOnTop(boolean bl) {
        if (bl) {
            this.setLayer(JDesktopPane.DRAG_LAYER);
            return;
        }
        this.setLayer(JDesktopPane.DEFAULT_LAYER);
    }

    public boolean isDisplay() {
        return this.isOuter() || this.isVisible();
    }

    public boolean isOuter() {
        return this.isOuter;
    }

    private void toOuterFrame(boolean bl) {
        Serializable serializable;
        this.outerFrame = new JFrame();
        try {
            serializable = new ImageIcon(JFrame.class.getResource("/icon.gif"));
            this.outerFrame.setIconImage(serializable.getImage());
        }
        catch (Exception exception) {}
        this.outerFrame.setTitle(this.typeLabel.getText());
        if (!bl && this.outerFramePoint != null && this.outFrameDimension != null) {
            this.outerFrame.setSize(this.outFrameDimension);
            this.outerFrame.setLocation(this.outerFramePoint);
            this.outerFramePoint = null;
            this.outFrameDimension = null;
        } else {
            serializable = this.getSize();
            ((Dimension)serializable).width += 5;
            ((Dimension)serializable).height += 35;
            this.outerFrame.setSize((Dimension)serializable);
            if (this.outerFramePoint != null) {
                this.outerFrame.setLocation(this.outerFramePoint);
            }
        }
        this.CloseButton.setEnabled(false);
        this.outerFrame.addWindowListener(new WindowAdapter(this){
            private /* synthetic */ CandleIFrame a;
            {
                this.a = candleIFrame;
            }

            @Override
            public final void windowClosing(WindowEvent windowEvent) {
                this.a.outerFramePoint = this.a.outerFrame.getLocation();
                this.a.outFrameDimension = this.a.outerFrame.getSize();
                this.a.isRequestOuter = false;
                this.a.lastIsOuter = false;
                this.a.closeOuterFrame();
                this.a.setVisible(false);
                this.a.lastIsOuter = true;
            }
        });
        CandleIFrame.super.setVisible(false);
        this.outerFrame.setContentPane(this.getContentPane());
        this.outerFrame.setVisible(true);
        this.isOuter = true;
        this.lastIsOuter = true;
    }

    private void closeOuterFrame() {
        if (this.isOuter && this.outerFrame != null) {
            this.CloseButton.setEnabled(true);
            this.outerFrame.setVisible(false);
            CandleIFrame candleIFrame = this;
            candleIFrame.setContentPane(candleIFrame.outerFrame.getContentPane());
            if (this.outerFramePoint != null && this.outFrameDimension != null) {
                CandleIFrame.super.setLocation(0, 0);
                CandleIFrame candleIFrame2 = this;
                candleIFrame2.setSize(candleIFrame2.outFrameDimension);
            }
            CandleIFrame.super.setVisible(true);
            for (WindowListener windowListener : this.outerFrame.getWindowListeners()) {
                this.outerFrame.removeWindowListener(windowListener);
            }
            this.outerFrame.dispose();
            this.outerFrame = null;
        }
        this.isOuter = false;
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                new CandleIFrame().setVisible(true);
            }
        });
    }

    @Override
    public void setCustomLayoutSetting(Map map) {
        boolean bl = false;
        try {
            if (map.containsKey("CandleFrame_sctycode")) {
                this.sctyCode = (Integer)map.get("CandleFrame_sctycode");
            }
            if (map.containsKey("CandleFrame_isVisible")) {
                bl = (Boolean)map.get("CandleFrame_isVisible");
            }
            if (map.containsKey("CandleFrame_isOuter")) {
                this.isRequestOuter = (Boolean)map.get("CandleFrame_isOuter");
            }
            if (map.containsKey("CandleFrame_lastIsOuter")) {
                this.lastIsOuter = (Boolean)map.get("CandleFrame_lastIsOuter");
            }
            if (map.containsKey("CandleFrame_outFrameDimension")) {
                this.outFrameDimension = (Dimension)map.get("CandleFrame_outFrameDimension");
            }
            if (map.containsKey("CandleFrame_outerFramePoint")) {
                this.outerFramePoint = (Point)map.get("CandleFrame_outerFramePoint");
            }
        }
        catch (Exception exception) {
            this.sctyCode = 0;
        }
        if (bl || this.isRequestOuter) {
            MultiWindowsControl.getInstance().showCandleChart("" + this.sctyCode);
        }
    }

    @Override
    public Map getCustomLayoutSetting() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("CandleFrame_isVisible", this.isVisible());
        hashMap.put("CandleFrame_isOuter", this.isOuter);
        hashMap.put("CandleFrame_lastIsOuter", this.lastIsOuter);
        hashMap.put("CandleFrame_sctycode", this.sctyCode);
        hashMap.put("CandleFrame_outFrameDimension", this.outFrameDimension);
        hashMap.put("CandleFrame_outerFramePoint", this.outerFramePoint);
        return hashMap;
    }
}

