/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.quot.typeimple.industry;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class IndCatItem
implements Externalizable {
    private static final long serialVersionUID = -7978082220633570205L;
    private static final int NONE = 0;
    public static final int DATA_STATIC = 2;
    public static final int DATA_DYNAMI = 4;
    public static final int DATA_BIDASK = 8;
    public static final int DATA_HIGHLOW = 16;
    private int sctyCode = 0;
    private int dataListFlag = 0;
    private String chi = null;
    private String eng = null;
    private float prevClose = 0.0f;
    private float prevDiv = 0.0f;
    private float peRatio = 0.0f;
    private int nominalPrice_d3 = 0;
    private long sharesTraded = 0L;
    private long turnover = 0L;
    private int bid_bestPrice_d3 = 0;
    private int ask_bestPrice_d3 = 0;
    private float highestTradePrice = 0.0f;
    private float lowestTradePrice = 0.0f;

    public IndCatItem() {
    }

    public IndCatItem(int n2) {
        this.sctyCode = n2;
    }

    public void setSctyCode(int n2) {
        this.sctyCode = n2;
    }

    public void setStatic(String string, String string2, float f2, float f3, float f4) {
        this.addDataType(2);
        if (string != null) {
            this.chi = string;
        }
        if (string2 != null) {
            this.eng = string2;
        }
        this.prevClose = f2;
        this.prevDiv = f3;
        this.peRatio = f4;
    }

    public void setDynami(int n2, long l2, long l3) {
        this.addDataType(4);
        this.nominalPrice_d3 = n2;
        this.sharesTraded = l2;
        this.turnover = l3;
    }

    public void setBidAsk(int n2, int n3) {
        this.addDataType(8);
        this.bid_bestPrice_d3 = n2;
        this.ask_bestPrice_d3 = n3;
    }

    public void setHighLow(float f2, float f3) {
        this.addDataType(16);
        this.highestTradePrice = f2;
        this.lowestTradePrice = f3;
    }

    public int getSctyCode() {
        return this.sctyCode;
    }

    public String getChi() {
        return this.chi;
    }

    public String getEng() {
        return this.eng;
    }

    public float getPrevClose() {
        return this.prevClose;
    }

    public float getPrevDiv() {
        return this.prevDiv;
    }

    public float getPeRatio() {
        return this.peRatio;
    }

    public int getNominalPrice_d3() {
        return this.nominalPrice_d3;
    }

    public long getSharesTraded() {
        return this.sharesTraded;
    }

    public long getTurnover() {
        return this.turnover;
    }

    public int getBidBestPrice_d3() {
        return this.bid_bestPrice_d3;
    }

    public int getAskBestPrice_d3() {
        return this.ask_bestPrice_d3;
    }

    public float getHighestTradePrice() {
        return this.highestTradePrice;
    }

    public float getLowestTradePrice() {
        return this.lowestTradePrice;
    }

    protected void addDataType(int n2) {
        this.dataListFlag |= n2;
    }

    public boolean isDataExist(int n2) {
        return IndCatItem.isDataExist(this.dataListFlag, n2);
    }

    public int getDataListFlag() {
        return this.dataListFlag;
    }

    public void setDataListFlag(int n2) {
        this.dataListFlag = n2;
    }

    public static boolean isDataExist(int n2, int n3) {
        return (n2 & n3) > 0;
    }

    public void update(IndCatItem indCatItem) {
        if (this.sctyCode == indCatItem.sctyCode) {
            if (indCatItem.isDataExist(2)) {
                this.setStatic(indCatItem.chi, indCatItem.eng, indCatItem.prevClose, indCatItem.prevDiv, indCatItem.peRatio);
            }
            if (indCatItem.isDataExist(4)) {
                this.setDynami(indCatItem.nominalPrice_d3, indCatItem.sharesTraded, indCatItem.turnover);
            }
            if (indCatItem.isDataExist(8)) {
                this.setBidAsk(indCatItem.bid_bestPrice_d3, indCatItem.ask_bestPrice_d3);
            }
            if (indCatItem.isDataExist(16)) {
                this.setHighLow(indCatItem.highestTradePrice, indCatItem.lowestTradePrice);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.sctyCode);
        objectOutput.writeInt(this.dataListFlag);
        if (this.isDataExist(2)) {
            objectOutput.writeUTF(this.chi);
            objectOutput.writeUTF(this.eng);
            objectOutput.writeFloat(this.prevClose);
            objectOutput.writeFloat(this.prevDiv);
            objectOutput.writeFloat(this.peRatio);
        }
        if (this.isDataExist(4)) {
            objectOutput.writeInt(this.nominalPrice_d3);
            objectOutput.writeLong(this.sharesTraded);
            objectOutput.writeLong(this.turnover);
        }
        if (this.isDataExist(8)) {
            objectOutput.writeInt(this.bid_bestPrice_d3);
            objectOutput.writeInt(this.ask_bestPrice_d3);
        }
        if (this.isDataExist(16)) {
            objectOutput.writeFloat(this.highestTradePrice);
            objectOutput.writeFloat(this.lowestTradePrice);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.sctyCode = objectInput.readInt();
        this.dataListFlag = objectInput.readInt();
        if (this.isDataExist(2)) {
            this.chi = objectInput.readUTF();
            this.eng = objectInput.readUTF();
            this.prevClose = objectInput.readFloat();
            this.prevDiv = objectInput.readFloat();
            this.peRatio = objectInput.readFloat();
        }
        if (this.isDataExist(4)) {
            this.nominalPrice_d3 = objectInput.readInt();
            this.sharesTraded = objectInput.readLong();
            this.turnover = objectInput.readLong();
        }
        if (this.isDataExist(8)) {
            this.bid_bestPrice_d3 = objectInput.readInt();
            this.ask_bestPrice_d3 = objectInput.readInt();
        }
        if (this.isDataExist(16)) {
            this.highestTradePrice = objectInput.readFloat();
            this.lowestTradePrice = objectInput.readFloat();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("[IndCatItem] : ").append(this.sctyCode).append(", ").append(this.chi).append(", ").append(this.eng).append(", ").append(this.nominalPrice_d3).append(", ").append(this.prevClose).append(", ").append(this.bid_bestPrice_d3).append(", ").append(this.ask_bestPrice_d3).append(", ").append(this.highestTradePrice).append(", ").append(this.lowestTradePrice).append(", ").append(this.sharesTraded).append(", ").append(this.turnover).append(", ").append(this.prevDiv).append(", ").append(this.peRatio);
        return stringBuilder.toString();
    }
}

