/*
 * Decompiled with CFR 0.152.
 */
package hk.com.realink.quot.typeimple.brokertrade;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class StockStatus
implements Externalizable {
    private static final long serialVersionUID = -7973637547314652958L;
    public static final byte DATA_HAVE_BID = 1;
    public static final byte DATA_HAVE_BID_FIRST = 2;
    public static final byte DATA_HAVE_ASK = 4;
    public static final byte DATA_HAVE_ASK_FIRST = 8;
    private int code = 0;
    private byte status = 0;

    public StockStatus() {
    }

    public StockStatus(int n2) {
        this.code = n2;
    }

    public int getCode() {
        return this.code;
    }

    public byte getStatus() {
        return this.status;
    }

    public boolean isHave(byte by) {
        return (this.status & by) != 0;
    }

    public boolean isHaveBid() {
        return this.isHave((byte)1);
    }

    public boolean isHaveBidFirst() {
        return this.isHave((byte)2);
    }

    public boolean isHaveAsk() {
        return this.isHave((byte)4);
    }

    public boolean isHaveAskFirst() {
        return this.isHave((byte)8);
    }

    public void setData(byte by) {
        this.status = (byte)(this.status | by);
    }

    public void setDataBid() {
        if (this.isHaveBidFirst()) {
            this.removeDataBidFirst();
        }
        this.setData((byte)1);
    }

    public void setDataBidFirst() {
        this.setData((byte)3);
    }

    public void setDataAsk() {
        if (this.isHaveAskFirst()) {
            this.removeDataAskFirst();
        }
        this.setData((byte)4);
    }

    public void setDataAskFirst() {
        this.setData((byte)12);
    }

    public void removeData(byte by) {
        this.status = (byte)(this.status ^ by);
    }

    public void removeDataBid() {
        this.removeData((byte)3);
    }

    public void removeDataBidFirst() {
        this.removeData((byte)2);
    }

    public void removeDataAsk() {
        this.removeData((byte)12);
    }

    public void removeDataAskFirst() {
        this.removeData((byte)8);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append("[StockStatus] : ").append(this.code).append(" : (");
        if (this.isHaveBidFirst()) {
            stringBuilder.append("b+");
        } else if (this.isHaveBid()) {
            stringBuilder.append("b ");
        } else {
            stringBuilder.append("  ");
        }
        stringBuilder.append(',');
        if (this.isHaveAskFirst()) {
            stringBuilder.append("a+");
        } else if (this.isHaveAsk()) {
            stringBuilder.append("a ");
        } else {
            stringBuilder.append("  ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void combine(StockStatus stockStatus) {
        this.status = (byte)(this.status | stockStatus.status);
    }

    public static StockStatus combine(StockStatus stockStatus, StockStatus stockStatus2) {
        StockStatus stockStatus3 = new StockStatus(stockStatus.code);
        new StockStatus(stockStatus.code).status = (byte)(stockStatus.status | stockStatus2.status);
        return stockStatus3;
    }

    public static StockStatus copy(StockStatus stockStatus) {
        StockStatus stockStatus2 = new StockStatus(stockStatus.code);
        new StockStatus(stockStatus.code).status = stockStatus.status;
        return stockStatus2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.code);
        objectOutput.write(this.status);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.code = objectInput.readInt();
        this.status = (byte)objectInput.read();
    }
}

