/*
 * Decompiled with CFR 0.152.
 */
package bss.update.v1;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class CltInfoDetailMod
implements Externalizable,
Serializable,
Cloneable {
    private static final String VERSION = "1.3";
    public static final long serialVersionUID = 20030726L;
    public double unsettle = 0.0;
    public double accBalance = 0.0;
    public double netBalance = 0.0;
    public double avaBalance = 0.0;
    public double outChq = 0.0;
    public double hold = 0.0;
    public double totalMktValue = 0.0;
    public int noOfStk = 0;
    public int accType = 0;
    public String cltCode = null;
    public double rate = 0.0;

    public static final void Version() {
        System.out.println("Version : 1.3");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.unsettle = objectInput.readDouble();
        this.accBalance = objectInput.readDouble();
        this.netBalance = objectInput.readDouble();
        this.avaBalance = objectInput.readDouble();
        this.outChq = objectInput.readDouble();
        this.hold = objectInput.readDouble();
        this.totalMktValue = objectInput.readDouble();
        this.noOfStk = objectInput.readInt();
        this.accType = objectInput.readInt();
        this.cltCode = objectInput.readUTF();
        if (this.cltCode.equals("")) {
            this.cltCode = null;
        }
        this.rate = objectInput.readDouble();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.unsettle);
        objectOutput.writeDouble(this.accBalance);
        objectOutput.writeDouble(this.netBalance);
        objectOutput.writeDouble(this.avaBalance);
        objectOutput.writeDouble(this.outChq);
        objectOutput.writeDouble(this.hold);
        objectOutput.writeDouble(this.totalMktValue);
        objectOutput.writeInt(this.noOfStk);
        objectOutput.writeInt(this.accType);
        if (this.cltCode == null) {
            this.cltCode = "";
        }
        objectOutput.writeUTF(this.cltCode);
        objectOutput.writeDouble(this.rate);
    }

    public double getAvailBalance() {
        this.avaBalance = this.accBalance - this.outChq - this.unsettle * this.rate;
        return this.avaBalance;
    }

    public double getNetBalance() {
        this.netBalance = this.accBalance - this.unsettle + this.totalMktValue;
        return this.netBalance;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }
}

