/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvColor;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.IlvValueFormat;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.IlvSingleBarRenderer;
import java.awt.Color;
import java.awt.Paint;
import java.text.NumberFormat;
import leaseLineQuote.candle.cfgpanel.HiLoCfgPanel;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.core.CandlePanel;
import leaseLineQuote.candle.graph.indicator.TechnicalIndicator;

public class VolumeIndicator
extends TechnicalIndicator {
    IlvChartRenderer renderer;
    Color color;

    public VolumeIndicator(StockDataSource stockDS, Color color) {
        super(stockDS);
        this.color = color;
    }

    public void setName(String name) {
        this.renderer.setName(name);
    }

    @Override
    public void attach(IlvChart chart) {
        super.attach(chart);
        IlvStyle style = new IlvStyle(IlvColor.darker(this.color), (Paint)this.color);
        this.renderer = new IlvSingleBarRenderer(style, 100.0);
        this.renderer.setName("Volume");
        this.renderer.setRenderingHint(new IlvDataRenderingHint(){

            @Override
            public IlvStyle getStyle(IlvDisplayPoint dp, IlvStyle defaultStyle) {
                try {
                    CandlePanel candlePanel = CandlePanel.getInstance();
                    IlvChartRenderer ilvRr = candlePanel.getOverviewRenderer();
                    IlvDataSet openSet = ilvRr.getDataSource().getDataSet(2);
                    IlvDataSet closeSet = ilvRr.getDataSource().getDataSet(3);
                    if (openSet != null && closeSet != null) {
                        double open = openSet.getYData(dp.getIndex());
                        double close = closeSet.getYData(dp.getIndex());
                        if (close > open) {
                            return new IlvStyle(IlvColor.darker(HiLoCfgPanel.colorPos), (Paint)IlvColor.brighter(HiLoCfgPanel.colorPos));
                        }
                        if (open >= close) {
                            return new IlvStyle(IlvColor.darker(HiLoCfgPanel.colorNeg), (Paint)IlvColor.brighter(HiLoCfgPanel.colorNeg));
                        }
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace(System.out);
                }
                return defaultStyle;
            }
        });
        chart.addRenderer(this.renderer);
        chart.getYAxis(0).setDataMin(0.0);
        chart.getYScale(0).setSkipLabelMode(2);
        chart.getYScale(0).setLabelFormat(new IlvValueFormat(){
            NumberFormat fmt = NumberFormat.getNumberInstance();

            @Override
            public String formatValue(double value) {
                if (value < 10000.0) {
                    return this.fmt.format(value);
                }
                if (value < 1.0E7) {
                    return this.fmt.format(value / 1000.0) + "K";
                }
                if (value < 1.0E10) {
                    return this.fmt.format(value / 1000000.0) + "M";
                }
                return this.fmt.format(value / 1.0E9) + "B";
            }
        });
        this.refresh();
    }

    @Override
    public void detach() {
        if (this.chart == null) {
            return;
        }
        this.chart.removeRenderer(this.renderer);
        this.chart.getYAxis(0).setAutoDataMin(true);
        this.chart.getYAxis(0).setTransformer(null);
        this.chart.getYScale(0).setLabelFormat(null);
        this.chart.getYScale(0).setSkipLabelMode(1);
        this.renderer = null;
        super.detach();
    }

    @Override
    public void refresh() {
        IlvDataSet volumeDataSet = this.stockDS.getVolumeDataSet();
        if (volumeDataSet == null) {
            this.renderer.getDataSource().setDataSets(null);
        } else {
            this.renderer.getDataSource().setDataSets(new IlvDataSet[]{volumeDataSet});
        }
    }

    @Override
    public IlvDisplayPoint getHighlightedPoint(int dataIdx) {
        IlvDataSet dataSet = this.renderer.getDataSource().getDataSet(0);
        if (this.renderer != null && dataSet != null && dataSet.getDataCount() > 0) {
            return this.renderer.getDisplayPoint(dataSet, dataIdx);
        }
        return null;
    }

    @Override
    public void setColor(Color[] colors) {
    }

    @Override
    public void setCfg(Object cfg) {
    }

    @Override
    public String getName() {
        return this.renderer.getName();
    }

    @Override
    public IlvDataSet getMainDataSet() {
        return this.renderer == null || this.renderer.getDataSource().getDataSetCount() == 0 ? null : this.renderer.getDataSource().getDataSet(0);
    }
}

