/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.data.IlvAbstractDataSource;
import ilog.views.chart.data.IlvDataSet;
import leaseLineQuote.candle.graph.indicator.MovingAverageDataSet;
import leaseLineQuote.candle.graph.indicator.PeriodDataSet;
import leaseLineQuote.candle.graph.indicator.StochasticDataSet;

class StochasticDataSource
extends IlvAbstractDataSource {
    int period1;
    int period2;
    int period3;

    public StochasticDataSource(int period1, int period2, int period3) {
        this.period1 = period1;
        this.period2 = period2;
        this.period3 = period3;
    }

    public StochasticDataSource(IlvDataSet[] dataSets, int period1, int period2, int period3) {
        this(period1, period2, period3);
        this.setHLCDataSets(dataSets);
    }

    public void setHLCDataSets(IlvDataSet[] dataSets) {
        if (dataSets == null) {
            this.getDataSetList().setDataSets(null);
            return;
        }
        if (dataSets.length != 3) {
            throw new IllegalArgumentException("StochasticDataSource needs 3 data sets");
        }
        StochasticDataSet kDataSet = new StochasticDataSet(dataSets, this.period1);
        PeriodDataSet kds = kDataSet;
        if (this.period2 > 1) {
            kds = new MovingAverageDataSet(kDataSet, 1, this.period2);
            kds.setName(kDataSet.getName());
        }
        MovingAverageDataSet dds = new MovingAverageDataSet(kds, 1, this.period3);
        dds.setName("%D(" + this.period3 + ")");
        this.getDataSetList().setDataSets(new IlvDataSet[]{kds, dds});
    }
}

