/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.renderer.IlvPolylineChartRenderer;
import java.awt.Color;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.indicator.PriceChannelDataSource;
import leaseLineQuote.candle.graph.indicator.TechnicalIndicator;

public class PriceChannelIndicator
extends TechnicalIndicator {
    IlvChartRenderer renderer;
    PriceChannelDataSource dataSource;
    Color color;

    public PriceChannelIndicator(StockDataSource stockDS) {
        this(stockDS, 20, Color.BLUE);
    }

    public PriceChannelIndicator(StockDataSource stockDS, int period, Color color) {
        super(stockDS);
        this.color = color;
        this.dataSource = new PriceChannelDataSource(period);
    }

    @Override
    public void attach(IlvChart chart) {
        super.attach(chart);
        this.renderer = new IlvPolylineChartRenderer();
        this.renderer.setDataSource(this.dataSource);
        this.refresh();
        chart.addRenderer(this.renderer);
    }

    @Override
    public void detach() {
        if (this.chart != null) {
            this.chart.removeRenderer(this.renderer);
        }
        this.renderer = null;
        super.detach();
    }

    @Override
    public void setColor(Color[] colors) {
        this.color = colors[0];
        IlvStyle style = IlvStyle.createStroked(colors[0]);
        this.renderer.setStyles(new IlvStyle[]{style, style});
    }

    @Override
    public void setCfg(Object cfg) {
        try {
            float[] cfgs = (float[])cfg;
            this.dataSource = new PriceChannelDataSource((int)cfgs[0]);
            this.renderer.setDataSource(this.dataSource);
            this.refresh();
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }

    @Override
    public void refresh() {
        IlvDataSet highDataSet = this.stockDS.getHighDataSet();
        IlvDataSet lowDataSet = this.stockDS.getLowDataSet();
        IlvDataSet[] dataSets = null;
        if (highDataSet != null && lowDataSet != null) {
            dataSets = new IlvDataSet[]{highDataSet, lowDataSet};
        }
        this.dataSource.setHighLowDataSets(dataSets);
        if (this.renderer.getChildCount() == 2) {
            IlvStyle style = IlvStyle.createStroked(this.color);
            this.renderer.setStyles(new IlvStyle[]{style, style});
            this.renderer.getChild(0).setVisibleInLegend(false);
        }
    }

    @Override
    public String getName() {
        return "Price Channel";
    }
}

