/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.DataSetContentsEvent;
import leaseLineQuote.candle.graph.indicator.IndicatorData;
import leaseLineQuote.candle.graph.indicator.IndicatorDataSet;
import leaseLineQuote.candle.graph.indicator.IndicatorUtil;

public class OSCDataSet
extends IndicatorDataSet {
    static final int DEFAULT_PERIOD = 10;
    private int fastPeriod = 0;
    private int slowPeriod = 0;

    public OSCDataSet(IlvDataSet dataSet, int fastPeriod, int slowPeriod) {
        super(new IlvDataSet[]{dataSet});
        this.setMaxDataSetCount(1);
        this.setPeriods(fastPeriod, slowPeriod);
    }

    @Override
    protected String getIndicatorName() {
        return "OSC(" + this.fastPeriod + "," + this.fastPeriod + ")";
    }

    public int getFastPeriod() {
        return this.fastPeriod;
    }

    public int getSlowPeriod() {
        return this.slowPeriod;
    }

    public void setPeriods(int fastPeriod, int slowPeriod) {
        if (slowPeriod <= 0 || fastPeriod <= 0 || fastPeriod > slowPeriod) {
            throw new IllegalArgumentException("Invalid periods");
        }
        this.fastPeriod = fastPeriod;
        this.slowPeriod = slowPeriod;
        this.updateIndicatorData();
        this.fireDataSetContentsEvent(new DataSetContentsEvent(this));
    }

    public IlvDataSet getMainDataSet() {
        return this.getDataSet(0);
    }

    @Override
    protected double[] computeIndicatorData() {
        if (this.fastPeriod == 0 || this.slowPeriod == 0 || this.getDataSetCount() == 0) {
            return null;
        }
        IndicatorData data = IndicatorData.get(this.getDataSet(0));
        if (data == null) {
            return null;
        }
        double[] res = IndicatorUtil.computeOscillator(data, this.fastPeriod, this.slowPeriod, 2);
        return res;
    }
}

