/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.renderer.IlvSinglePolylineRenderer;
import java.awt.Color;
import java.awt.Paint;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.indicator.MovingAverageDataSet;
import leaseLineQuote.candle.graph.indicator.PeriodDataSet;
import leaseLineQuote.candle.graph.indicator.TechnicalIndicator;

public class MovingAverageIndicator
extends TechnicalIndicator {
    IlvChartRenderer renderer;
    PeriodDataSet avgDataSet;
    IlvStyle[] ilvStyle = new IlvStyle[1];

    public MovingAverageIndicator(StockDataSource stockDS, int avgType, int period, Color color) {
        super(stockDS);
        this.avgDataSet = new MovingAverageDataSet(avgType, period);
        this.ilvStyle[0] = new IlvStyle(color, (Paint)color);
    }

    @Override
    public void attach(IlvChart chart) {
        super.attach(chart);
        this.renderer = new IlvSinglePolylineRenderer(this.ilvStyle[0]);
        this.refresh();
        chart.addRenderer(this.renderer, this.avgDataSet);
    }

    @Override
    public void detach() {
        if (this.chart != null) {
            this.chart.removeRenderer(this.renderer);
        }
        this.renderer = null;
        super.detach();
    }

    @Override
    public void setColor(Color[] color) {
        this.ilvStyle[0] = new IlvStyle(color[0], (Paint)color[0]);
        this.renderer.setStyles(this.ilvStyle);
    }

    @Override
    public void setCfg(Object cfg) {
        float[] periods = (float[])cfg;
        this.avgDataSet.setPeriod((int)periods[0]);
    }

    @Override
    public void refresh() {
        IlvDataSet closeDataSet = this.stockDS.getCloseDataSet();
        if (closeDataSet == null) {
            if (this.avgDataSet.getDataSetCount() > 0) {
                this.avgDataSet.removeDataSet(0);
            }
        } else {
            this.avgDataSet.setDataSet(0, this.stockDS.getCloseDataSet());
        }
    }

    @Override
    public String getName() {
        return this.avgDataSet.getName();
    }

    @Override
    public IlvDataSet getMainDataSet() {
        return this.avgDataSet;
    }

    public static TechnicalIndicator createEMA(StockDataSource stockDS, int period, Color color) {
        return new MovingAverageIndicator(stockDS, 2, period, color);
    }

    public static TechnicalIndicator createSMA(StockDataSource stockDS, int period, Color color) {
        return new MovingAverageIndicator(stockDS, 1, period, color);
    }
}

