/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.data.IlvDataSet;
import leaseLineQuote.candle.graph.indicator.IndicatorData;
import leaseLineQuote.candle.graph.indicator.IndicatorUtil;
import leaseLineQuote.candle.graph.indicator.PeriodDataSet;

public class MovingAverageDataSet
extends PeriodDataSet {
    private int type;

    public MovingAverageDataSet(int type, int period) {
        this(null, type, period);
    }

    public MovingAverageDataSet(IlvDataSet dataSet, int type, int period) {
        IlvDataSet[] ilvDataSetArray;
        if (dataSet == null) {
            ilvDataSetArray = null;
        } else {
            IlvDataSet[] ilvDataSetArray2 = new IlvDataSet[1];
            ilvDataSetArray = ilvDataSetArray2;
            ilvDataSetArray2[0] = dataSet;
        }
        super(ilvDataSetArray, period);
        this.setMaxDataSetCount(1);
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Invalid average type: " + type);
        }
        this.type = type;
    }

    @Override
    protected String getIndicatorName() {
        String name = this.type == 1 ? "SMA(" : "EMA(";
        return name + this.getPeriod() + ")";
    }

    public final int getType() {
        return this.type;
    }

    @Override
    protected double[] computeIndicatorData() {
        if (this.getPeriod() == 0 || this.getDataSetCount() == 0) {
            return null;
        }
        IndicatorData data = IndicatorData.get(this.getDataSet(0));
        if (data == null) {
            return null;
        }
        return this.type == 1 ? IndicatorUtil.computeSMA(data, this.getPeriod()) : IndicatorUtil.computeEMA(data, this.getPeriod());
    }
}

