/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.indicator;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.renderer.IlvPolylineChartRenderer;
import java.awt.Color;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.graph.indicator.BollingerBandsDataSource;
import leaseLineQuote.candle.graph.indicator.TechnicalIndicator;

public class BollingerBandsIndicator
extends TechnicalIndicator {
    IlvChartRenderer renderer;
    BollingerBandsDataSource dataSource;
    int period;
    double coeff;
    Color color;

    public BollingerBandsIndicator(StockDataSource stockDS) {
        this(stockDS, 20, 2.0, Color.RED);
    }

    public BollingerBandsIndicator(StockDataSource stockDS, int period, double coeff, Color color) {
        super(stockDS);
        this.period = period;
        this.coeff = coeff;
        this.color = color;
        this.dataSource = new BollingerBandsDataSource(period, coeff);
    }

    @Override
    public void attach(IlvChart chart) {
        super.attach(chart);
        this.renderer = new IlvPolylineChartRenderer();
        this.renderer.setDataSource(this.dataSource);
        this.refresh();
        chart.addRenderer(this.renderer);
    }

    @Override
    public void setColor(Color[] colors) {
        this.color = colors[0];
        IlvStyle style = IlvStyle.createStroked(this.color);
        this.renderer.setStyles(new IlvStyle[]{style, style});
    }

    @Override
    public void setCfg(Object cfg) {
        float[] cfgs = (float[])cfg;
        this.period = (int)cfgs[0];
        this.coeff = cfgs[1];
        this.dataSource = new BollingerBandsDataSource(this.period, this.coeff);
        this.renderer.setDataSource(this.dataSource);
        this.refresh();
    }

    @Override
    public void detach() {
        if (this.chart != null) {
            this.chart.removeRenderer(this.renderer);
        }
        this.renderer = null;
        super.detach();
    }

    @Override
    public void refresh() {
        this.dataSource.setPriceDataSet(this.stockDS.getCloseDataSet());
        if (this.renderer != null && this.renderer.getChildCount() == 2) {
            IlvStyle style = IlvStyle.createStroked(this.color);
            this.renderer.setStyles(new IlvStyle[]{style, style});
            this.renderer.getChild(0).setVisibleInLegend(false);
        }
    }

    @Override
    public String getName() {
        return "Bollinger Bands";
    }
}

