/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custindicator;

import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.event.IlvListenerList;
import java.util.ArrayList;
import leaseLineQuote.candle.graph.custindicator.HistoryListener;

public class AxisZoomHistory {
    private int pos = -1;
    private ArrayList history = new ArrayList();
    private IlvListenerList historyListeners;

    public void add(IlvDataInterval itv) {
        if (this.pos < 0 || this.pos == this.history.size() - 1) {
            this.history.add(itv);
            ++this.pos;
        } else {
            this.history.set(++this.pos, itv);
            while (this.history.size() > this.pos + 1) {
                this.history.remove(this.pos + 1);
            }
        }
        this.fireHistoryEvent();
    }

    public void reset() {
        this.history.clear();
        this.pos = -1;
        this.fireHistoryEvent();
    }

    public IlvDataInterval previous() {
        IlvDataInterval itv = (IlvDataInterval)this.history.get(--this.pos);
        this.fireHistoryEvent();
        return itv;
    }

    public boolean hasPrevious() {
        return this.history.size() > 0 && this.pos > 0 && this.pos < this.history.size();
    }

    public IlvDataInterval next() {
        IlvDataInterval dw = (IlvDataInterval)this.history.get(++this.pos);
        this.fireHistoryEvent();
        return dw;
    }

    public boolean hasNext() {
        return this.history.size() > 0 && this.pos >= 0 && this.pos < this.history.size() - 1;
    }

    public void addHistoryListener(HistoryListener l2) {
        if (this.historyListeners == null) {
            this.historyListeners = new IlvListenerList();
        }
        this.historyListeners.add(l2);
    }

    public void removeHistoryListener(HistoryListener l2) {
        if (this.historyListeners == null) {
            return;
        }
        this.historyListeners.remove(l2);
        if (this.historyListeners.getListenerList().length == 0) {
            this.historyListeners = null;
        }
    }

    protected void fireHistoryEvent() {
        if (this.historyListeners == null) {
            return;
        }
        Object[] listeners = this.historyListeners.getListenerList();
        int length = listeners.length;
        for (int i2 = length - 1; i2 >= 0; --i2) {
            ((HistoryListener)listeners[i2]).navigationPerformed();
        }
    }
}

