/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.custdecoration;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDefaultStepsDefinition;
import ilog.views.chart.action.IlvChartAction;
import ilog.views.util.IlvImageUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class StockUtil {
    public static final double MIN_XLEN = 66.0;
    public static final int ANIMATION_STEPS = 6;

    public static void performAnimatedZoom(IlvChart chart, int yAxisIdx, IlvDataWindow w, int zoomSteps) {
        if (zoomSteps < 1) {
            chart.zoom(w, yAxisIdx);
            return;
        }
        IlvAxis xAxis = chart.getXAxis();
        IlvAxis yAxis = chart.getYAxis(yAxisIdx);
        IlvDataInterval xRange = xAxis.getVisibleRange();
        IlvDataInterval yRange = yAxis.getVisibleRange();
        IlvDataInterval newXRange = w.xRange;
        IlvDataInterval newYRange = w.yRange;
        chart.getChartArea().setDirectRedrawEnabled(true);
        xAxis.setAdjusting(true);
        yAxis.setAdjusting(true);
        int steps = zoomSteps + 1;
        double deltaXMin = (newXRange.min - xRange.min) / (double)steps;
        double deltaXMax = (newXRange.max - xRange.max) / (double)steps;
        double deltaYMin = (newYRange.min - yRange.min) / (double)steps;
        double deltaYMax = (newYRange.max - yRange.max) / (double)steps;
        IlvDataWindow dw = new IlvDataWindow(xRange, yRange);
        for (int i2 = 0; i2 < steps; ++i2) {
            dw.xRange.setMin(dw.getXMin() + deltaXMin);
            dw.xRange.setMax(dw.getXMax() + deltaXMax);
            dw.yRange.setMin(dw.getYMin() + deltaYMin);
            dw.yRange.setMax(dw.getYMax() + deltaYMax);
            chart.zoom(dw, yAxisIdx);
        }
        chart.zoom(w, yAxisIdx);
        chart.getChartArea().setDirectRedrawEnabled(false);
        xAxis.setAdjusting(false);
        yAxis.setAdjusting(false);
    }

    public static void performAnimatedZoom(IlvChart chart, int yAxisIdx, IlvDataInterval xRange, int zoomSteps) {
        IlvDataWindow w = new IlvDataWindow(xRange, StockUtil.getYDataRange(chart, yAxisIdx, xRange));
        StockUtil.performAnimatedZoom(chart, yAxisIdx, w, zoomSteps);
    }

    public static IlvDataInterval getYDataRange(IlvChart chart, int yAxisIdx, IlvDataInterval xRange) {
        IlvDataInterval res = new IlvDataInterval();
        Iterator iter = chart.getRendererIterator();
        IlvDataInterval tmpRange = null;
        while (iter.hasNext()) {
            IlvChartRenderer r2 = (IlvChartRenderer)iter.next();
            if (!r2.isViewable() || r2.getYAxisIdx() != yAxisIdx) continue;
            tmpRange = r2.getYRange(xRange, tmpRange);
            res.add(tmpRange);
        }
        IlvDefaultStepsDefinition.adjustRange(res);
        return res;
    }

    public static Icon loadIcon(String file, Class baseClass) {
        Image image = StockUtil.loadImage(file, baseClass);
        return image == null ? null : new ImageIcon(image);
    }

    public static Icon loadIcon(String file) {
        return StockUtil.loadIcon(file, StockUtil.class);
    }

    public static Image loadImage(String file, Class baseClass) {
        Image image = null;
        try {
            image = IlvImageUtil.getImageFromFile(baseClass, file);
        }
        catch (Exception x) {
            System.err.println("Error while loading image: " + x.getMessage());
        }
        return image;
    }

    public static Image loadImage(String file) {
        return StockUtil.loadImage(file, StockUtil.class);
    }

    private StockUtil() {
    }

    public static JButton addAction(JToolBar toolbar, IlvChartAction action) {
        String shortDescription;
        JButton button = toolbar.add(action);
        if (button.getIcon() != null) {
            button.setText(null);
        }
        button.setPreferredSize(new Dimension(22, 22));
        KeyStroke accelerator = action.getAccelerator();
        if (accelerator != null) {
            button.registerKeyboardAction(action, accelerator, 2);
        }
        if ((shortDescription = action.getShortDescription()) != null) {
            if (accelerator != null) {
                shortDescription = shortDescription + "|" + action.getAcceleratorText();
            }
            button.setToolTipText(shortDescription);
        }
        return button;
    }
}

