/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.graph.core;

import hk.com.realink.histnews.typeimple.HistRecordRes;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvColor;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDefaultStepsDefinition;
import ilog.views.chart.IlvLabelRenderer;
import ilog.views.chart.IlvLegend;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.IlvTimeUnit;
import ilog.views.chart.IlvValueFormat;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.event.AxisChangeEvent;
import ilog.views.chart.event.AxisListener;
import ilog.views.chart.event.AxisRangeEvent;
import ilog.views.chart.event.ChartDrawEvent;
import ilog.views.chart.event.ChartDrawListener;
import ilog.views.chart.graphic.IlvImageDecoration;
import ilog.views.chart.interactor.IlvChartEditPointInteractor;
import ilog.views.chart.interactor.IlvChartPanInteractor;
import ilog.views.chart.interactor.IlvChartXScrollInteractor;
import ilog.views.chart.interactor.IlvChartYScrollInteractor;
import ilog.views.chart.renderer.IlvHiLoChartRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import leaseLineQuote.candle.control.ControlPanel;
import leaseLineQuote.candle.control.HKIndexCode;
import leaseLineQuote.candle.control.UpdateCandle;
import leaseLineQuote.candle.datasource.StockDataSource;
import leaseLineQuote.candle.datasource.histrecord.HistRecordReader;
import leaseLineQuote.candle.graph.ChartColors;
import leaseLineQuote.candle.graph.ControlInterface;
import leaseLineQuote.candle.graph.FutureSelectedListener;
import leaseLineQuote.candle.graph.core.DateRange;
import leaseLineQuote.candle.graph.core.LowerDataStatusControl;
import leaseLineQuote.candle.graph.core.PercentDisplayer;
import leaseLineQuote.candle.graph.core.QuoteDisplayPanel;
import leaseLineQuote.candle.graph.core.UpperDataStatusControl;
import leaseLineQuote.candle.graph.custdecoration.SharedGrid;
import leaseLineQuote.candle.graph.custdecoration.StockUtil;
import leaseLineQuote.candle.graph.custdecoration.Stripes;
import leaseLineQuote.candle.graph.custdecoration.ThresholdLines;
import leaseLineQuote.candle.graph.custindicator.AutoYZoomInteractor;
import leaseLineQuote.candle.graph.custindicator.AxisZoomHistory;
import leaseLineQuote.candle.graph.custindicator.HighlightQuotesInteractor;
import leaseLineQuote.candle.graph.custindicator.Highlighter;
import leaseLineQuote.candle.graph.custindicator.freehand.FreeHandInteractor;
import leaseLineQuote.candle.graph.custindicator.horizontal.HorizLineInteractor;
import leaseLineQuote.candle.graph.custscales.CategoryTimeSteps;
import leaseLineQuote.candle.graph.indicator.BollingerBandsIndicator;
import leaseLineQuote.candle.graph.indicator.MACDIndicator;
import leaseLineQuote.candle.graph.indicator.MovingAverageIndicator;
import leaseLineQuote.candle.graph.indicator.PriceChannelIndicator;
import leaseLineQuote.candle.graph.indicator.RSIIndicator;
import leaseLineQuote.candle.graph.indicator.StochasticIndicator;
import leaseLineQuote.candle.graph.indicator.TechnicalIndicator;
import leaseLineQuote.candle.graph.indicator.VolumeIndicator;
import leaseLineQuote.candle.graph.indicator.WilliamsRIndicator;

public class CandlePanel
implements ChartColors,
ControlInterface {
    private static final int MAIN_WINDOW_DEFAULT_HEIGHT = 700;
    private static final int LOWER_CHART_COUNT = 3;
    public static final int RIGHT_MARGIN = 6;
    public static final String HIGHLIGHT_STATUS_KEY = "HIGHLIGHT_STATUS_KEY";
    public static final Font DEFAULT_FONT = new Font("Dialog", 0, 10);
    public static final int HLOC = 4;
    public static final int CANDLE = 5;
    public static NumberFormat numFmt;
    public static DateFormat dateFmt;
    public static DateFormat dateTimeFmt;
    private boolean isYAutoScale = false;
    private String currentCode = "-9";
    private int monthPeriodIdx = -1;
    private StockDataSource stockDS;
    private IlvChart mainChart;
    private IlvChart[] lowerCharts;
    private ArrayList upperIndicators = new ArrayList();
    private ArrayList lowerIndicators = new ArrayList();
    private IlvChartRenderer overviewRenderer;
    private IlvChartInteractor[][] upperInteractors;
    private IlvChartInteractor[][] lowerInteractors;
    private AxisZoomHistory zoomHistory = new AxisZoomHistory();
    private Highlighter highlighter;
    boolean antiAliasing = false;
    private ThresholdLines threshold;
    private ChartMessage loadingMessage;
    private QuoteDisplayPanel quoteDisplay;
    private PercentDisplayer percentDisplayer;
    private static CandlePanel candlePanel;
    private Hashtable upperIndicatorMap = new Hashtable();
    private Hashtable lowerIndicatorMap = new Hashtable();
    private Hashtable viewRangeHash = new Hashtable();
    public FutureSelectedListener futureSelectedListener;
    private boolean[] interactorEnable;
    public FreeHandInteractor freeHandInterator;
    public HorizLineInteractor horizLineInteractor;
    private String lastLoadedSymbol = "";
    private final LinkedBlockingQueue<ProcessData> processDataList = new LinkedBlockingQueue();
    private final ReentrantLock processLock = new ReentrantLock();
    private final Thread ProcessDataThread = new Thread("ProcessDataThread"){

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        12.interrupted();
                        pd = (ProcessData)CandlePanel.access$500(CandlePanel.this).take();
                        try {
                            CandlePanel.access$600(CandlePanel.this).lock();
                            CandlePanel.access$1100(CandlePanel.this, ProcessData.access$700(pd), ProcessData.access$800(pd), ProcessData.access$900(pd), ProcessData.access$1000(pd));
                        }
                        finally {
                            CandlePanel.access$600(CandlePanel.this).unlock();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    System.out.println("CandlePanel : ProcessData Interrupted : " + ie.getMessage());
                    continue;
                }
                catch (Exception e) {
                    System.out.println("CandlePanel : ProcessData Error : " + e.getMessage());
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    };

    private CandlePanel() {
        this.ProcessDataThread.setDaemon(true);
        this.ProcessDataThread.start();
        try {
            numFmt = new DecimalFormat("0.###");
            dateFmt = new SimpleDateFormat("dd/MM/yy (EEE)", Locale.ENGLISH);
            dateTimeFmt = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static CandlePanel getInstance() {
        if (candlePanel == null) {
            candlePanel = new CandlePanel();
        }
        return candlePanel;
    }

    public IlvChart getMainChart() {
        return this.mainChart;
    }

    public IlvChart[] getLowerCharts() {
        return this.lowerCharts;
    }

    public QuoteDisplayPanel getQuoteDisplayPanel() {
        return this.quoteDisplay;
    }

    public IlvChartRenderer getOverviewRenderer() {
        return this.overviewRenderer;
    }

    public TechnicalIndicator[] getUpperIndicators() {
        return this.upperIndicators.toArray(new TechnicalIndicator[0]);
    }

    public TechnicalIndicator[] getLowerIndicators() {
        return this.lowerIndicators.toArray(new TechnicalIndicator[0]);
    }

    @Override
    public void init(Container container) {
        container.setLayout(new BorderLayout());
        container.setBackground(CHART_BACKGROUND);
        this.stockDS = StockDataSource.getInstance();
        this.mainChart = this.createMainChart();
        this.percentDisplayer = new PercentDisplayer();
        this.setUpperChartRenderer(5);
        this.lowerCharts = this.createLowerCharts();
        this.createUpperInteractors();
        this.createLowerInteractors();
        JPanel top = new JPanel(new BorderLayout());
        container.add((Component)top, "North");
        JPanel lowerChartsPanel = new JPanel(new GridLayout(this.lowerCharts.length, 1, 0, 0));
        lowerChartsPanel.setOpaque(false);
        lowerChartsPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        for (int i2 = 0; i2 < this.lowerCharts.length; ++i2) {
            lowerChartsPanel.add(this.lowerCharts[i2]);
        }
        JSplitPane center = new JSplitPane(0, this.mainChart, lowerChartsPanel);
        center.setDividerLocation(300);
        center.setDividerSize(2);
        center.setOpaque(false);
        container.add((Component)center, "Center");
        this.setAntiAliasing(true);
    }

    public StockDataSource getStockDataSource() {
        return this.stockDS;
    }

    protected JComponent createLowerDataComponent(int lowerChartIdx, JComponent leftComponent) {
        LowerDataStatusControl hsc = LowerDataStatusControl.getInstance();
        JPanel panel = new JPanel();
        hsc.registerHeader(lowerChartIdx, panel);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(CHART_LOWER_HEADER);
        panel.add(leftComponent);
        return panel;
    }

    protected JComponent createUpperDataComponent() {
        UpperDataStatusControl usc = UpperDataStatusControl.getInstance();
        JPanel panel = new JPanel();
        usc.registerHeader(panel);
        panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(CHART_LOWER_HEADER);
        return panel;
    }

    protected IlvChart createMainChart() {
        IlvChart chart = this.createChart();
        try {
            URL url = ControlPanel.class.getResource("img/realinkbg.gif");
            IlvImageDecoration deco = new IlvImageDecoration(url, 0, 0);
            deco.setAnchor(8);
            deco.setDrawOrder(-3);
            chart.addDecoration(deco);
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
        chart.getXScale().setMajorTickVisible(true);
        chart.getXScale().setVisible(false);
        chart.getYScale(0).setTitle("Share price ($)", 270.0);
        chart.getYScale(0).getTitleRenderer().setFont(new Font("Dialog", 0, 12));
        chart.getYScale(0).setLabelFormat(new IlvValueFormat(){
            DecimalFormat fmt = new DecimalFormat("0.##");
            DecimalFormat fmt3 = new DecimalFormat("0.###");

            @Override
            public String formatValue(double value) {
                int width;
                int filler;
                String s2 = this.fmt.format(value);
                if (value < 10.0) {
                    s2 = this.fmt3.format(value);
                }
                if ((filler = (width = 8) - s2.length()) > 0) {
                    StringBuffer res = new StringBuffer(width);
                    for (int i2 = 0; i2 < filler; ++i2) {
                        res.append(' ');
                    }
                    return res.append(s2).toString();
                }
                return s2;
            }
        });
        Stripes stripes = new Stripes(chart.getYScale(0), MAIN_STRIPES);
        stripes.setDrawOrder(-3);
        chart.addDecoration(stripes);
        chart.getXAxis().addAxisListener(new AxisListener(){
            boolean oldAntiAliasing;

            @Override
            public void axisRangeChanged(AxisRangeEvent evt) {
                if (evt.isVisibleRangeEvent() && evt.isChangedEvent() && !evt.isAdjusting()) {
                    CandlePanel.this.xRangeChanged(false);
                } else if (evt.isVisibleRangeEvent() && !evt.isChangedEvent()) {
                    double min = evt.getNewMin();
                    double max = evt.getNewMax();
                    if (max - min < 66.0) {
                        double mid = (max + min) / 2.0;
                        evt.setNewMax(mid + 33.0);
                        evt.setNewMin(mid - 33.0);
                    }
                }
            }

            @Override
            public void axisChanged(AxisChangeEvent evt) {
                if (evt.getType() == 1) {
                    if (evt.isAdjusting()) {
                        if (CandlePanel.this.antiAliasing) {
                            CandlePanel.this.setAntiAliasing(true);
                            this.oldAntiAliasing = true;
                        }
                    } else {
                        if (this.oldAntiAliasing) {
                            CandlePanel.this.setAntiAliasing(true);
                            this.oldAntiAliasing = false;
                        }
                        CandlePanel.this.xRangeChanged(true);
                        CandlePanel.this.saveVisableRange();
                    }
                }
            }
        });
        JPanel header = new JPanel(new GridLayout(0, 1, 0, 0));
        header.setBackground(CHART_UPPER_HEADER);
        this.quoteDisplay = new QuoteDisplayPanel();
        header.add(this.quoteDisplay);
        header.add(this.createUpperDataComponent());
        IlvLegend legend = this.createLegend();
        chart.setLegend(legend);
        header.add(legend);
        chart.setHeader(header);
        return chart;
    }

    protected IlvChart[] createLowerCharts() {
        IlvChart[] charts = new IlvChart[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            charts[i2] = this.createLowerChart(i2);
        }
        return charts;
    }

    private IlvChart createLowerChart(int lowerChartIdx) {
        IlvChart chart = this.createChart();
        chart.synchronizeAxis(this.mainChart, 1, true);
        chart.setXScale(null);
        chart.setXGrid(new SharedGrid(this.mainChart.getXScale(), (Paint)GRID_COLOR));
        IlvLegend legend = this.createLegend();
        chart.setLegend(legend);
        chart.setHeader(this.createLowerDataComponent(lowerChartIdx, legend));
        return chart;
    }

    public void setAntiAliasing(boolean b2) {
        if (this.antiAliasing == b2) {
            return;
        }
        this.mainChart.setAntiAliasing(b2);
        this.mainChart.getChartArea().repaint();
        for (int i2 = 0; i2 < this.lowerCharts.length; ++i2) {
            this.lowerCharts[i2].setAntiAliasing(b2);
            this.lowerCharts[i2].getChartArea().repaint();
        }
        this.antiAliasing = b2;
    }

    public void startLoading(String code) {
        IlvDataWindow w = this.mainChart.getCoordinateSystem(0).getVisibleWindow();
        if (this.loadingMessage == null) {
            IlvLabelRenderer label = new IlvLabelRenderer();
            label.setFont(new Font("Courier New", 1, 18));
            label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(FOREGROUND), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
            label.setOpaque(true);
            label.setBackground(IlvColor.setAlpha(BACKGROUND, 0.8f));
            this.loadingMessage = new ChartMessage("Not Found : " + code, label);
        }
        this.mainChart.addChartDrawListener(this.loadingMessage);
        IlvChart.Area area = this.mainChart.getChartArea();
        if (area != null) {
            area.repaint();
        }
    }

    public void endLoading() {
        if (this.loadingMessage != null) {
            this.mainChart.removeChartDrawListener(this.loadingMessage);
            this.loadingMessage = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CandlePanel.this.mainChart.getChartArea().repaint();
            }
        });
    }

    private void primaryDataLoaded(String expectedSymbol) {
        if (this.stockDS.getDataSetCount() > 0) {
            boolean sameSymbol;
            String symbol = null;
            try {
                symbol = this.stockDS.getSymbol().toUpperCase();
            }
            catch (Exception e2) {
                e2.printStackTrace(System.out);
                return;
            }
            if (!symbol.equalsIgnoreCase(expectedSymbol)) {
                System.out.println("[WARNING]symbol=" + symbol + ", expectedSymbol=" + expectedSymbol);
            }
            if (!(sameSymbol = this.lastLoadedSymbol.equals(symbol))) {
                this.lastLoadedSymbol = symbol;
            }
            IlvDataSet[] dataSets = new IlvDataSet[]{this.stockDS.getHighDataSet(), this.stockDS.getLowDataSet(), this.stockDS.getOpenDataSet(), this.stockDS.getCloseDataSet()};
            for (int i2 = 0; i2 < dataSets.length; ++i2) {
                if (dataSets[i2] != null) continue;
                System.out.println("[ERROR]dataSet[" + i2 + "] null");
            }
            this.overviewRenderer.getDataSource().setDataSets(dataSets);
            if (HKIndexCode.isCode(symbol)) {
                this.overviewRenderer.setName(HKIndexCode.codeToEngName(symbol));
            } else {
                this.overviewRenderer.setName(symbol);
            }
            Color c_1 = new Color(0, 0, 0);
            Color c_dw = new Color(0, 0, 255);
            Color c_up = new Color(255, 0, 0);
            IlvStyle style1_ = IlvStyle.createStroked(c_1);
            IlvStyle style2_ = new IlvStyle(IlvColor.darker(c_up), (Paint)IlvColor.brighter(c_up));
            IlvStyle style3_ = new IlvStyle(IlvColor.darker(c_dw), (Paint)IlvColor.brighter(c_dw));
            this.overviewRenderer.setStyles(new IlvStyle[]{style1_, style1_, style2_, style3_});
            this.percentDisplayer.setActive(true);
        }
        this.updateIndicators();
        this.resetVisibleRange();
        this.updateXScale();
        this.loadVisableRange(false, ControlPanel.getInstance().isChgCode());
        ControlPanel.getInstance().setIsChgCode(true);
        this.zoomHistory.add(this.mainChart.getXAxis().getVisibleRange());
        this.endLoading();
    }

    public void loadVisableRange(boolean isInital, boolean isChgCode) {
        DateRange prevDateView;
        int num = 249;
        Date[] dates = this.stockDS.getDates();
        if (dates == null || dates.length == 0) {
            return;
        }
        int idxMin = dates.length - 1 - num;
        int idxMax = dates.length - 1;
        if (idxMin < 0) {
            idxMin = 0;
        }
        if ((prevDateView = (DateRange)this.viewRangeHash.get("MAIN_DATE")) != null && !isInital) {
            int idxMaxTmp = -1;
            int idxMinTmp = -1;
            for (int i2 = 0; i2 < dates.length; ++i2) {
                if (dates[i2].compareTo(prevDateView.dateMax) >= 0 && idxMaxTmp < 0) {
                    idxMaxTmp = i2;
                }
                if (dates[i2].compareTo(prevDateView.dateMin) >= 0 && idxMinTmp < 0) {
                    idxMinTmp = i2;
                }
                if (idxMaxTmp >= 0 && idxMinTmp >= 0) break;
            }
            if (idxMaxTmp > 0 && idxMinTmp > 0) {
                if (isChgCode) {
                    idxMax = idxMaxTmp;
                    idxMin = idxMinTmp;
                } else {
                    idxMax = idxMaxTmp;
                    if (idxMax < 0) {
                        idxMax = 0;
                    }
                    if ((idxMin = idxMax - prevDateView.totalItems + 1) < 0) {
                        idxMin = 0;
                    }
                }
            } else {
                System.out.println("[LOAD_DEFAULT]");
            }
        }
        IlvDataInterval newRange = new IlvDataInterval();
        newRange.setMax(idxMax + 1);
        newRange.setMin(idxMin);
        this.mainChart.getXAxis().setVisibleRange(newRange);
        this.xRangeChanged(false);
    }

    private void updateXScale() {
        Date[] dates = this.stockDS.getDates();
        if (dates == null) {
            this.mainChart.getXScale().setVisible(false);
            this.mainChart.getXScale().setStepsDefinition(new IlvDefaultStepsDefinition());
        } else {
            IlvTimeUnit unit = null;
            switch (this.stockDS.getPeriod()) {
                case 2: {
                    unit = IlvTimeUnit.MONTH;
                    break;
                }
                case 1: {
                    unit = IlvTimeUnit.WEEK;
                    break;
                }
                case 0: {
                    unit = IlvTimeUnit.DAY;
                    break;
                }
                case 3: {
                    unit = IlvTimeUnit.MINUTE;
                }
            }
            CategoryTimeSteps def = new CategoryTimeSteps(dates, unit, this.stockDS.getIntervalUnit());
            this.mainChart.getXScale().setStepsDefinition(def);
            this.mainChart.getXScale().setVisible(true);
        }
    }

    private void updateIndicators() {
        Iterator ite = this.lowerIndicators.iterator();
        while (ite.hasNext()) {
            ((TechnicalIndicator)ite.next()).refresh();
        }
        ite = this.upperIndicators.iterator();
        while (ite.hasNext()) {
            ((TechnicalIndicator)ite.next()).refresh();
        }
    }

    private void resetVisibleRange() {
        this.mainChart.getXAxis().setAutoVisibleRange(true);
        this.mainChart.getYAxis(0).setAutoVisibleRange(true);
        this.zoomHistory.reset();
    }

    @Override
    public synchronized void saveVisableRange() {
        Date[] dates;
        IlvDataInterval xRange = this.mainChart.getXAxis().getVisibleRange();
        if (xRange.isEmpty()) {
            System.out.println("[SAVE]visable range empty");
        }
        if ((dates = this.stockDS.getDates()) == null) {
            return;
        }
        int idxMax = (int)Math.round(Math.floor(xRange.getMax()));
        int idxMin = (int)Math.round(Math.ceil(xRange.getMin()));
        if (idxMax > dates.length - 1) {
            idxMax = dates.length - 1;
        }
        if (idxMin < 0) {
            idxMin = 0;
        }
        DateRange dateRange = new DateRange("MAIN_DATE", dates[idxMin], dates[idxMax], idxMax - idxMin + 1);
        this.viewRangeHash.put(dateRange.key, dateRange);
    }

    protected IlvLegend createLegend() {
        IlvLegend legend = new IlvLegend();
        legend.setLayout(new FlowLayout(0, 12, 2));
        legend.setPaintingBackground(false);
        legend.setBorder(null);
        legend.setForeground(LEGEND_FOREGROUND);
        legend.setMovable(false);
        legend.setFont(DEFAULT_FONT);
        legend.setSymbolSize(new Dimension(16, 12));
        return legend;
    }

    protected IlvChart createChart() {
        IlvChart chart = new IlvChart();
        chart.getXGrid().setMajorPaint(GRID_COLOR);
        chart.getXGrid().setDrawOrder(-2);
        chart.getYGrid(0).setMajorPaint(GRID_COLOR);
        chart.getYGrid(0).setDrawOrder(-2);
        chart.setForeground(SCALES_FOREGROUND);
        chart.setFont(DEFAULT_FONT);
        return chart;
    }

    private void createUpperInteractors() {
        this.interactorEnable = new boolean[]{true, true, true, true, true, true, true, true};
        this.upperInteractors = new IlvChartInteractor[1][8];
        HighlightQuotesInteractor highlightInter = new HighlightQuotesInteractor(){

            @Override
            public boolean isHandling(int x, int y) {
                return CandlePanel.this.interactorEnable[0];
            }

            @Override
            protected boolean isTarget(IlvChartRenderer r2) {
                return r2 == CandlePanel.this.overviewRenderer || r2.getParent() == CandlePanel.this.overviewRenderer;
            }
        };
        this.highlighter = new Highlighter();
        highlightInter.addChartInteractionListener(this.highlighter);
        AutoYZoomInteractor autoYZoomInter = new AutoYZoomInteractor(){

            @Override
            public boolean isHandling(int x, int y) {
                return CandlePanel.this.interactorEnable[1];
            }

            @Override
            protected void doIt() {
                IlvDataInterval oldRange = this.getXAxis().getVisibleRange();
                super.doIt();
                IlvDataInterval newRange = this.getXAxis().getVisibleRange();
                if (!oldRange.equals(newRange)) {
                    CandlePanel.this.zoomHistory.add(newRange);
                }
            }
        };
        autoYZoomInter.setXORGhost(false);
        autoYZoomInter.setGhostColor(new Color(50, 50, 50, 30));
        autoYZoomInter.setAnimationStep(6);
        IlvChartPanInteractor panInteractor = new IlvChartPanInteractor(){

            @Override
            public boolean isHandling(int x, int y) {
                return CandlePanel.this.interactorEnable[2];
            }
        };
        IlvChartXScrollInteractor xScrollInteractor = new IlvChartXScrollInteractor(){

            @Override
            public boolean isHandling(int x, int y) {
                return CandlePanel.this.interactorEnable[3];
            }
        };
        IlvChartYScrollInteractor yScrollInteractor = new IlvChartYScrollInteractor(){

            @Override
            public boolean isHandling(int x, int y) {
                return CandlePanel.this.interactorEnable[7];
            }
        };
        yScrollInteractor.setStep(1);
        this.freeHandInterator = new FreeHandInteractor(){

            @Override
            public boolean isHandling(int x, int y) {
                return CandlePanel.this.interactorEnable[4];
            }
        };
        IlvChartEditPointInteractor editPointInteractor = new IlvChartEditPointInteractor(){

            @Override
            public boolean isHandling(int x, int y) {
                return CandlePanel.this.interactorEnable[5];
            }

            @Override
            public Cursor getCursor() {
                return new Cursor(13);
            }
        };
        editPointInteractor.setYEditAllowed(true);
        editPointInteractor.setXEditAllowed(true);
        this.horizLineInteractor = new HorizLineInteractor(){

            @Override
            public boolean isHandling(int x, int y) {
                return CandlePanel.this.interactorEnable[6];
            }
        };
        this.upperInteractors[0][0] = highlightInter;
        this.upperInteractors[0][1] = autoYZoomInter;
        this.upperInteractors[0][2] = panInteractor;
        this.upperInteractors[0][3] = xScrollInteractor;
        this.upperInteractors[0][4] = this.freeHandInterator;
        this.upperInteractors[0][5] = editPointInteractor;
        this.upperInteractors[0][6] = this.horizLineInteractor;
        this.upperInteractors[0][7] = yScrollInteractor;
        this.mainChart.setInteractors(this.upperInteractors[0]);
    }

    public void setInteractorHighlightEnable(boolean enable) {
        this.interactorEnable[0] = enable;
    }

    public void setInteractorAutoYZoomEnable(boolean enable) {
        this.interactorEnable[1] = enable;
    }

    public void setInteractorPanEnable(boolean enable) {
        this.interactorEnable[2] = enable;
    }

    public void setInteractorXScrollEnable(boolean enable) {
        this.interactorEnable[3] = enable;
    }

    public void setInteractorFreeHandEnable(boolean enable) {
        this.interactorEnable[4] = enable;
    }

    public void setInteractorEditPointEnable(boolean enable) {
        this.interactorEnable[5] = enable;
    }

    private void createLowerInteractors() {
        this.lowerInteractors = new IlvChartInteractor[this.lowerCharts.length][];
        for (int i2 = 0; i2 < this.lowerCharts.length; ++i2) {
            this.lowerInteractors[i2] = new IlvChartInteractor[]{new IlvChartPanInteractor()};
            this.lowerCharts[i2].setInteractors(this.lowerInteractors[i2]);
        }
    }

    public void xRangeChanged(boolean isAxisChanged) {
        for (int i2 = 0; i2 < this.lowerCharts.length; ++i2) {
            IlvDataInterval xRange = this.lowerCharts[i2].getXAxis().getVisibleRange();
            if (xRange.isEmpty()) {
                return;
            }
            IlvDataInterval yRange = StockUtil.getYDataRange(this.lowerCharts[i2], 0, xRange);
            if (yRange.isEmpty()) continue;
            this.lowerCharts[i2].getYAxis(0).setVisibleRange(yRange);
        }
        if (!this.isYAutoScale && isAxisChanged) {
            return;
        }
        IlvDataInterval xRange = this.mainChart.getXAxis().getVisibleRange();
        if (xRange.isEmpty()) {
            return;
        }
        IlvDataInterval yRange = StockUtil.getYDataRange(this.mainChart, 0, xRange);
        if (!yRange.isEmpty()) {
            this.mainChart.getYAxis(0).setVisibleRange(yRange);
        }
    }

    private void setUpperChartRenderer(int representation) {
        boolean isCreateNewRenderer = false;
        IlvHiLoChartRenderer r2 = null;
        if (this.overviewRenderer == null) {
            isCreateNewRenderer = true;
        } else {
            IlvHiLoChartRenderer tmpRenderer = (IlvHiLoChartRenderer)this.overviewRenderer;
            int mode = tmpRenderer.getMode();
            isCreateNewRenderer = mode == 2 && representation == 5 ? false : mode != 3 || representation != 4;
            if (!isCreateNewRenderer) {
                return;
            }
        }
        if (isCreateNewRenderer) {
            switch (representation) {
                case 4: {
                    r2 = new IlvHiLoChartRenderer(3, 0, 70.0);
                    break;
                }
                case 5: {
                    r2 = new IlvHiLoChartRenderer(2, 0, 70.0);
                    break;
                }
                default: {
                    System.out.println("[SET_UPPER_RENDERER][ERROR]Overview renderer has unvaild representation.");
                    return;
                }
            }
            int idx = this.mainChart.getRenderers().indexOf(this.overviewRenderer);
            if (idx == -1) {
                this.mainChart.addRenderer(r2);
            } else {
                ((IlvChartRenderer)r2).setStyles(this.overviewRenderer.getStyles());
                r2.setName(this.overviewRenderer.getName());
                this.mainChart.setRenderer(idx, r2);
                this.xRangeChanged(true);
            }
            this.overviewRenderer = r2;
        }
    }

    static final Date getDefaultStartDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, -1);
        return cal.getTime();
    }

    public static void main(String[] args) {
    }

    public void setUnhighlight() {
        this.highlighter.unhighlight();
        UpperDataStatusControl usc = UpperDataStatusControl.getInstance();
        usc.setDatasToLabels(new LinkedHashMap());
        this.quoteDisplay.reset();
    }

    @Override
    public void loadQuote(String symbol, int monthPeriodIdx, int period, int amount) {
        this.ProcessDataThread.interrupt();
        this.processDataList.add(new ProcessData(symbol, monthPeriodIdx, period, amount));
    }

    private void _loadQuote(String symbol, int monthPeriodIdx, int period, int amount) {
        UpdateCandle uc = UpdateCandle.getInstance();
        uc.setData(symbol, monthPeriodIdx, period, amount);
        this.currentCode = symbol;
        this.monthPeriodIdx = monthPeriodIdx;
        try {
            int code;
            if (!HKIndexCode.isCode(this.currentCode) && (code = Integer.parseInt(this.currentCode)) <= 0) {
                return;
            }
        }
        catch (Exception code) {
            // empty catch block
        }
        this.stockDS.reset();
        this.endLoading();
        try {
            StockDataSource.LoadHook afterLoad = new StockDataSource.LoadHook(){

                @Override
                public void dataLoaded() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CandlePanel.this.processLock.lock();
                                CandlePanel.this.primaryDataLoaded(CandlePanel.this.currentCode);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace(System.out);
                            }
                            finally {
                                CandlePanel.this.processLock.unlock();
                            }
                        }
                    });
                }
            };
            boolean isFound = this.stockDS.loadData(this.currentCode, monthPeriodIdx, period, amount, afterLoad);
            if (!isFound) {
                this.startLoading(this.currentCode);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }

    @Override
    public void setYPanAllowed(boolean allowed) {
        this.isYAutoScale = !allowed;
        if (this.upperInteractors[0].length > 2 && this.upperInteractors[0][2] instanceof IlvChartPanInteractor) {
            ((IlvChartPanInteractor)this.upperInteractors[0][2]).setYPanAllowed(allowed);
        }
    }

    @Override
    public void setFitAction() {
        this.loadVisableRange(true, false);
        this.saveVisableRange();
        this.zoomHistory.reset();
        this.zoomHistory.add(this.mainChart.getXAxis().getVisibleRange());
    }

    @Override
    public boolean setForwardAction() {
        if (this.zoomHistory.hasPrevious()) {
            IlvDataInterval itv = this.zoomHistory.previous();
            StockUtil.performAnimatedZoom(this.mainChart, 0, itv, 6);
            return true;
        }
        return false;
    }

    @Override
    public boolean setBackwardAction() {
        if (this.zoomHistory.hasNext()) {
            IlvDataInterval itv = this.zoomHistory.next();
            StockUtil.performAnimatedZoom(this.mainChart, 0, itv, 6);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void setThreshold(boolean isVisible) {
        if (isVisible) {
            if (this.threshold == null) {
                Color upperColor = new Color(120, 220, 120);
                Color midColor = new Color(233, 150, 122);
                Color lowerColor = IlvColor.indianRed;
                this.threshold = new ThresholdLines(FOREGROUND, BACKGROUND, lowerColor, midColor, upperColor);
            }
            ThresholdLines.set(this.threshold, this.mainChart, 0);
            this.overviewRenderer.setRenderingHint(this.threshold);
        } else {
            ThresholdLines threshold = ThresholdLines.remove(this.mainChart, 0);
            this.overviewRenderer.setRenderingHint(null);
        }
    }

    @Override
    public synchronized void setThreshold(double min, double max) {
        this.threshold.adjustRange(min, max);
    }

    @Override
    public void setUpperIndicatorsColor(String type, int unit, Color[] color) {
        if (type.equals("MAIN_GRAPH")) {
            if (color != null) {
                IlvStyle style1_ = IlvStyle.createStroked(color[0]);
                IlvStyle style2_ = new IlvStyle(IlvColor.darker(color[1]), (Paint)IlvColor.brighter(color[1]));
                IlvStyle style3_ = new IlvStyle(IlvColor.darker(color[2]), (Paint)IlvColor.brighter(color[2]));
                this.setUpperChartRenderer(unit);
                this.overviewRenderer.setStyles(new IlvStyle[]{style1_, style1_, style2_, style3_});
            }
        } else {
            String key = type + ":" + unit;
            TechnicalIndicator indicator = (TechnicalIndicator)this.upperIndicatorMap.get(key);
            if (indicator != null && color != null) {
                indicator.setColor(color);
            }
        }
    }

    @Override
    public synchronized void createUpperIndicators(String type, int unit, Color color, Object cfg) {
        String key = type + ":" + unit;
        TechnicalIndicator indicator = null;
        if (type.equals("SMA")) {
            if (this.upperIndicatorMap.get(key) == null) {
                float[] cfgs = (float[])cfg;
                indicator = MovingAverageIndicator.createSMA(this.stockDS, (int)cfgs[0], color);
            }
        } else if (type.equals("EMA")) {
            if (this.upperIndicatorMap.get(key) == null) {
                float[] cfgs = (float[])cfg;
                indicator = MovingAverageIndicator.createEMA(this.stockDS, (int)cfgs[0], color);
            }
        } else if (type.equals("BB")) {
            if (this.upperIndicatorMap.get(key) == null) {
                float[] cfgs = (float[])cfg;
                indicator = new BollingerBandsIndicator(this.stockDS, (int)cfgs[0], cfgs[1], color);
            }
        } else if (type.equals("PC")) {
            float[] cfgs = (float[])cfg;
            if (this.upperIndicatorMap.get(key) == null) {
                indicator = new PriceChannelIndicator(this.stockDS, (int)cfgs[0], color);
            }
        } else {
            System.out.println("[WARNING]not such technical indicator type " + type);
        }
        if (indicator != null) {
            this.upperIndicatorMap.put(key, indicator);
            this.upperIndicators.add(indicator);
            indicator.attach(this.mainChart);
        }
    }

    @Override
    public synchronized void setUpperIndicatorsCfg(String type, int unit, Object cfg) {
        String key = type + ":" + unit;
        TechnicalIndicator indicator = (TechnicalIndicator)this.upperIndicatorMap.get(key);
        if (indicator != null && cfg != null) {
            indicator.setCfg(cfg);
        }
    }

    @Override
    public void removeUpperIndicators(String type, int unit) {
        String key = type + ":" + unit;
        TechnicalIndicator indicator = (TechnicalIndicator)this.upperIndicatorMap.remove(key);
        if (indicator != null) {
            this.upperIndicators.remove(indicator);
            indicator.detach();
        }
    }

    @Override
    public void setLowerIndicatorsColor(int index, String type, int unit, Color[] color) {
        String key = index + ":" + type + ":" + unit;
        TechnicalIndicator indicator = (TechnicalIndicator)this.lowerIndicatorMap.get(key);
        if (indicator != null && color != null) {
            indicator.setColor(color);
        }
    }

    @Override
    public synchronized void createLowerIndicators(int index, String type, int unit, Color[] colors, Object cfg) {
        try {
            String key = index + ":" + type + ":" + unit;
            System.out.println("candlePanel -- createLowerIndicators() -- key [" + key + "]");
            TechnicalIndicator indicator = null;
            if (type.equals("VOL")) {
                if (this.lowerIndicatorMap.get(key) == null) {
                    indicator = new VolumeIndicator(this.stockDS, colors[0]);
                }
            } else if (type.equals("RSI")) {
                if (this.lowerIndicatorMap.get(key) == null) {
                    indicator = new RSIIndicator(this.stockDS, colors[0], (int[])cfg);
                }
            } else if (type.equals("MACD")) {
                if (this.lowerIndicatorMap.get(key) == null) {
                    indicator = MACDIndicator.createMACD(this.stockDS, colors, (int[])cfg);
                }
            } else if (type.equals("WR")) {
                if (this.lowerIndicatorMap.get(key) == null) {
                    int[] vals = (int[])cfg;
                    indicator = new WilliamsRIndicator(this.stockDS, colors[0], vals[0]);
                }
            } else if (type.equals("KD") && this.lowerIndicatorMap.get(key) == null) {
                int[] cfgs = (int[])cfg;
                indicator = StochasticIndicator.createFastStochastic(this.stockDS, cfgs, colors);
            }
            if (indicator != null) {
                this.lowerIndicatorMap.put(key, indicator);
                this.lowerIndicators.add(index, indicator);
                ((TechnicalIndicator)indicator).attach(this.lowerCharts[index]);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void setStockDataSourcePeriod(int period, int amount) {
        System.out.println("candlePanel -- setStockDataSourcePeriod(" + period + "," + amount + ")");
        this.loadQuote(this.currentCode, this.monthPeriodIdx, period, amount);
    }

    public String getCurrentCode() {
        return this.currentCode;
    }

    @Override
    public void removeLowerIndicators(int index, String type, int unit) {
        String key = index + ":" + type + ":" + unit;
        TechnicalIndicator indicator = (TechnicalIndicator)this.lowerIndicatorMap.remove(key);
        if (indicator != null) {
            this.lowerIndicators.remove(indicator);
            indicator.detach();
        }
    }

    @Override
    public void setLowerIndicatorsCfg(int index, String type, int unit, Object cfg) {
        String key = index + ":" + type + ":" + unit;
        TechnicalIndicator indicator = (TechnicalIndicator)this.lowerIndicatorMap.get(key);
        if (indicator != null && cfg != null) {
            indicator.setCfg(cfg);
        }
    }

    @Override
    public void addFutureSelectedListener(FutureSelectedListener listener) {
        this.futureSelectedListener = listener;
    }

    @Override
    public void addHistRecordReaderListener(HistRecordReader.RequestListener listener) {
        HistRecordReader histRecordReader = HistRecordReader.getInstance();
        histRecordReader.setTimeout(6000);
        histRecordReader.setReqListener(listener);
    }

    @Override
    public void updateHistRecordRes(HistRecordRes histRecordRes) {
        HistRecordReader histRecordReader = HistRecordReader.getInstance();
        histRecordReader.dataResponse(histRecordRes);
    }

    static /* synthetic */ LinkedBlockingQueue access$500(CandlePanel x0) {
        return x0.processDataList;
    }

    static /* synthetic */ void access$1100(CandlePanel x0, String x1, int x2, int x3, int x4) {
        x0._loadQuote(x1, x2, x3, x4);
    }

    class ProcessData {
        private String symbol;
        private int monthPeriodIdx;
        private int period;
        private int amount;

        private ProcessData(String symbol, int monthPeriodIdx, int period, int amount) {
            this.symbol = symbol;
            this.monthPeriodIdx = monthPeriodIdx;
            this.period = period;
            this.amount = amount;
        }

        static /* synthetic */ String access$700(ProcessData x0) {
            return x0.symbol;
        }

        static /* synthetic */ int access$800(ProcessData x0) {
            return x0.monthPeriodIdx;
        }

        static /* synthetic */ int access$900(ProcessData x0) {
            return x0.period;
        }

        static /* synthetic */ int access$1000(ProcessData x0) {
            return x0.amount;
        }
    }

    private static class ChartMessage
    implements ChartDrawListener {
        private IlvLabelRenderer label;
        private String text;

        public ChartMessage(String text) {
            this(text, new IlvLabelRenderer());
        }

        public ChartMessage(String text, IlvLabelRenderer label) {
            this.text = text;
            this.label = label;
        }

        @Override
        public void beforeDraw(ChartDrawEvent evt) {
        }

        @Override
        public void afterDraw(ChartDrawEvent evt) {
            Graphics g2 = evt.getGraphics();
            IlvChart.Area area = evt.getChart().getChartArea();
            Rectangle r2 = area.getPlotRect();
            int x = (r2.x + r2.width) / 2;
            int y = (r2.y + r2.height) / 2;
            Rectangle clipBounds = g2.getClipBounds();
            if (clipBounds == null || this.label.getBounds(area, x, y, this.text, null).intersects(clipBounds)) {
                this.label.paintLabel(area, g2, this.text, x, y);
            }
        }
    }
}

