/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.datasource.histrecord;

import hk.com.realink.feed.toolkit.RKDebug;
import hk.com.realink.histnews.history.HistRaw;
import hk.com.realink.histnews.history.HistRecord;
import hk.com.realink.histnews.typeimple.HistRecordRes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import leaseLineQuote.candle.control.ControlPanel;
import leaseLineQuote.candle.control.HKIndexCode;
import leaseLineQuote.candle.datasource.histrecord.CandleCache;
import leaseLineQuote.candle.datasource.histrecord.StockData;

public class HistRecordReader {
    private static HistRecordReader histRecordReader;
    private RequestListener listener;
    private boolean reverse = false;
    private CandleCache candleCache = new CandleCache();
    private static final int WaitTick = 500;
    private static final Comparator<HistRaw> c;
    public static SimpleDateFormat yyyyMMddHHmmsdf;
    private static SimpleDateFormat sdf;
    private int timeout = 10000;
    private static final String[] indexCode;

    private void putCache(HistRecordRes res) {
        try {
            String key = HistRecordReader.getKey(res);
            if (HistRecordReader.isIndexRequest(res.getHistRecord().companyCode)) {
                this.candleCache.putCandle(key, res, 30000L);
            } else {
                HistRecordRes oldRes = this.getCache(key);
                if (oldRes != null) {
                    this.candleCache.putCandle(key, HistRecordReader.appendHistRecord(oldRes, res));
                } else {
                    this.candleCache.putCandle(key, res);
                }
            }
        }
        catch (Exception e2) {
            System.out.println("Put Cache Fail : " + e2.toString());
            for (StackTraceElement se : e2.getStackTrace()) {
                System.out.println(se);
            }
        }
    }

    private HistRecordRes getCache(String key) {
        return this.candleCache.getCandle(key);
    }

    private HistRecordRes waitCache(String key, int timeout) {
        HistRecordRes result = null;
        if (key != null) {
            result = this.getCache(key);
            for (int waitedTime = 0; result == null && waitedTime < timeout; waitedTime += 500) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result = this.getCache(key);
            }
        }
        return result;
    }

    private static final String getKey(String companyCode, int monthPeriodIdx, int period) {
        String result = HistRecordReader.isIndexRequest(companyCode) ? companyCode + ':' + monthPeriodIdx + '-' + (period == 3 ? 8 : 1) : companyCode + ':' + 0 + '-' + (period == 3 ? 8 : 1);
        System.out.println("Request Key : " + result);
        return result;
    }

    private static final String getKey(HistRecordRes res) {
        String result = res.getHistRecord().companyCode + ':' + res.getPeriod() + '-' + res.getHistRecord().getType();
        System.out.println("Response Key : " + result);
        return result;
    }

    private static final HistRecordRes appendHistRecord(HistRecordRes oldHRR, HistRecordRes newHRR) {
        try {
            ArrayList<HistRaw> result = new ArrayList<HistRaw>(oldHRR.getHistRaws().length + newHRR.getHistRaws().length);
            ArrayList<HistRaw> newData = new ArrayList<HistRaw>(Arrays.asList(newHRR.getHistRaws()));
            for (HistRaw hr : oldHRR.getHistRaws()) {
                result.add(hr);
                Date oldD = new Date(hr.date);
                Iterator ite = newData.iterator();
                while (ite.hasNext()) {
                    HistRaw nhr = (HistRaw)ite.next();
                    Date newD = new Date(nhr.date);
                    if (!yyyyMMddHHmmsdf.format(oldD).equals(yyyyMMddHHmmsdf.format(newD))) continue;
                    ite.remove();
                }
            }
            for (HistRaw hr : newData) {
                result.add(hr);
            }
            Collections.sort(result, c);
            oldHRR.setHistRaw(result.toArray(new HistRaw[0]));
            oldHRR.setAccessMode(4);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return oldHRR;
    }

    private HistRecordReader() {
    }

    public static HistRecordReader getInstance() {
        if (histRecordReader == null) {
            histRecordReader = new HistRecordReader();
        }
        return histRecordReader;
    }

    public void setReqListener(RequestListener listener) {
        this.listener = listener;
    }

    public void dataResponse(HistRecordRes rec) {
        this.putCache(rec);
    }

    public static void main(String[] args) {
    }

    private static void printLog(String code, StockData stockData) {
        if (stockData != null) {
            System.out.println("[Response]symbol=" + stockData.symbol + ", data(length)=" + stockData.data[0].length);
        } else {
            System.out.println("[Response]symbol=" + code + " not exist.");
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public static final boolean isIndexRequest(String companyCode) {
        for (String code : indexCode) {
            if (!code.equals(companyCode)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isMinChart() {
        return 3 == ControlPanel.getInstance().getFrequency();
    }

    public static final boolean isMinChart(int period) {
        return 3 == period;
    }

    public long getMaxDate(HistRecordRes res) {
        HistRaw[] hr = res.getHistRaws();
        if (hr == null || hr.length == 0) {
            return -1L;
        }
        long date1 = hr[0].date;
        long date2 = hr[hr.length - 1].date;
        return date1 > date2 ? date1 : date2;
    }

    public synchronized StockData readData(String companyCode, int monthPeriodIdx, int period, int amount) {
        String key = HistRecordReader.getKey(companyCode, monthPeriodIdx, period);
        HistRecordRes res = this.getCache(key);
        boolean result = false;
        if (res == null) {
            result = period == 3 && !HistRecordReader.isIndexRequest(companyCode) ? this.listener.requestAgentMessage(companyCode, period, monthPeriodIdx, -1L) : this.listener.request(companyCode, monthPeriodIdx, HistRecordReader.isIndexRequest(companyCode));
        } else if (period == 3) {
            if (HistRecordReader.isIndexRequest(companyCode)) {
                result = this.listener.request(companyCode, monthPeriodIdx, true);
            } else {
                long date = this.getMaxDate(res);
                System.out.println("Cache Time : " + date);
                result = date > 0L ? this.listener.requestAgentMessage(companyCode, period, monthPeriodIdx, date) : this.listener.requestAgentMessage(companyCode, period, monthPeriodIdx, -1L);
            }
            if (result) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception date) {
                    // empty catch block
                }
            }
        }
        if (res == null && !result) {
            return null;
        }
        res = this.waitCache(key, this.timeout);
        if (res != null) {
            HistRecord histRecord = res.getHistRecord();
            int type = histRecord.getType();
            HistRecord periodRecord = null;
            if (type == 8) {
                periodRecord = histRecord.getTypeHistRecord(8, amount);
            } else if (period == 2) {
                periodRecord = histRecord.getTypeHistRecord(3, amount);
            } else if (period == 1) {
                periodRecord = histRecord.getTypeHistRecord(2, amount);
            } else if (period == 0 || period == -1) {
                periodRecord = histRecord.getTypeHistRecord(1, amount);
            } else if (HistRecordReader.isMinChart(period)) {
                periodRecord = histRecord.getTypeHistRecord(8, amount);
            } else {
                return null;
            }
            ArrayList<HistRecord> resultList = new ArrayList<HistRecord>();
            HistRecord[] recs = periodRecord.toArray();
            for (int i2 = 0; i2 < recs.length; ++i2) {
                if (!(recs[i2].close > 0.0f)) continue;
                resultList.add(recs[i2]);
            }
            recs = resultList.toArray(new HistRecord[0]);
            if (HistRecordReader.isMinChart(period)) {
                return this.getStockData(periodRecord.companyCode, recs, 3);
            }
            if (type == 8) {
                return this.getStockData(periodRecord.companyCode, recs, 3);
            }
            return this.getStockData(periodRecord.companyCode, recs, 0);
        }
        return null;
    }

    public synchronized StockData readData_bak(String companyCode, int monthPeriodIdx, int period, int amount) {
        HistRecordRes res = null;
        String key = HistRecordReader.getKey(companyCode, monthPeriodIdx, period);
        long date = -1L;
        res = this.getCache(key);
        if (res == null || HistRecordReader.isIndexRequest(companyCode) || HistRecordReader.isMinChart(period)) {
            boolean result = false;
            result = period == 3 ? (HistRecordReader.isIndexRequest(companyCode) ? this.listener.request(companyCode, monthPeriodIdx, true) : (res != null ? ((date = this.getMaxDate(res)) > 0L ? this.listener.requestAgentMessage(companyCode, period, monthPeriodIdx, date) : this.listener.requestAgentMessage(companyCode, period, monthPeriodIdx, -1L)) : this.listener.requestAgentMessage(companyCode, period, monthPeriodIdx, -1L))) : this.listener.request(companyCode, monthPeriodIdx, false);
            if (!result) {
                return null;
            }
            try {
                HistRecordRes resOld = res;
                res = this.waitCache(key, this.timeout);
                if (!HistRecordReader.isIndexRequest(companyCode) && HistRecordReader.isMinChart(period) && resOld != null) {
                    res = res != null ? HistRecordReader.appendHistRecord(resOld, res) : resOld;
                }
                if (res.getAccessMode() == 1 || res.getAccessMode() == 4) {
                    if (!res.getHistRecord().companyCode.equalsIgnoreCase(companyCode)) {
                        return null;
                    }
                } else {
                    return null;
                }
                this.candleCache.putCandle(key, res);
            }
            catch (Exception ex) {
                RKDebug.exception(ex);
                return null;
            }
        }
        HistRecord histRecord = res.getHistRecord();
        int type = histRecord.getType();
        HistRecord periodRecord = null;
        if (type == 8) {
            periodRecord = histRecord.getTypeHistRecord(8, amount);
        } else if (period == 2) {
            periodRecord = histRecord.getTypeHistRecord(3, amount);
        } else if (period == 1) {
            periodRecord = histRecord.getTypeHistRecord(2, amount);
        } else if (period == 0 || period == -1) {
            periodRecord = histRecord.getTypeHistRecord(1, amount);
        } else if (HistRecordReader.isMinChart(period)) {
            periodRecord = histRecord.getTypeHistRecord(8, amount);
        } else {
            return null;
        }
        ArrayList<HistRecord> resultList = new ArrayList<HistRecord>();
        HistRecord[] recs = periodRecord.toArray();
        for (int i2 = 0; i2 < recs.length; ++i2) {
            if (!(recs[i2].close > 0.0f)) continue;
            resultList.add(recs[i2]);
        }
        recs = resultList.toArray(new HistRecord[0]);
        if (HistRecordReader.isMinChart(period)) {
            return this.getStockData(periodRecord.companyCode, recs, 3);
        }
        if (type == 8) {
            return this.getStockData(periodRecord.companyCode, recs, 3);
        }
        return this.getStockData(periodRecord.companyCode, recs, 0);
    }

    private synchronized StockData getStockData(String symbol, HistRecord[] histRecs, int intervalUnit) {
        int i2;
        String[] desc = new String[]{"Open", "High", "Low", "Close", "Volume"};
        double[][] data = new double[desc.length][];
        for (int i3 = 0; i3 < data.length; ++i3) {
            data[i3] = new double[histRecs.length];
        }
        Object[] dates = new Date[histRecs.length];
        for (i2 = 0; i2 < histRecs.length; ++i2) {
            dates[i2] = new Date(histRecs[i2].date);
            data[0][i2] = histRecs[i2].open;
            data[1][i2] = histRecs[i2].high;
            data[2][i2] = histRecs[i2].low;
            data[3][i2] = histRecs[i2].close;
            data[4][i2] = histRecs[i2].maxTurnover;
            if (HKIndexCode.isCode(symbol) || histRecs[i2].maxTurnover != 0L) continue;
            data[0][i2] = histRecs[i2].close;
            data[1][i2] = histRecs[i2].close;
            data[2][i2] = histRecs[i2].close;
            data[3][i2] = histRecs[i2].close;
            data[4][i2] = histRecs[i2].maxTurnover;
        }
        if (this.reverse) {
            HistRecordReader.reverseArray(dates, dates.length);
            for (i2 = 0; i2 < data.length; ++i2) {
                HistRecordReader.reverseArray((Object[])data, data[i2].length);
            }
        }
        return new StockData(symbol, desc, (Date[])dates, data, intervalUnit);
    }

    private static void reverseArray(Object[] array, int count) {
        int start = 0;
        for (int end = count - 1; start < end; ++start, --end) {
            Object tmp = array[start];
            array[start] = array[end];
            array[end] = tmp;
        }
    }

    static {
        c = new Comparator<HistRaw>(){

            @Override
            public int compare(HistRaw o1, HistRaw o2) {
                if (o1.date > o2.date) {
                    return 1;
                }
                if (o1.date == o2.date) {
                    return 0;
                }
                if (o1.date < o2.date) {
                    return -1;
                }
                return 0;
            }
        };
        yyyyMMddHHmmsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        sdf = new SimpleDateFormat("yyyyMMddHHmm");
        indexCode = new String[]{"HSI", "MHI", "HHI"};
    }

    public static interface RequestListener {
        public boolean request(String var1, int var2, boolean var3);

        public boolean requestAgentMessage(String var1, int var2, int var3, long var4);
    }
}

