/*
 * Decompiled with CFR 0.152.
 */
package leaseLineQuote.candle.cfgpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import leaseLineQuote.ColorButton;
import leaseLineQuote.IntegerTextField;
import leaseLineQuote.StyledFont;
import leaseLineQuote.UserProfile;
import leaseLineQuote.candle.CandleNewFrame;
import leaseLineQuote.candle.cfgpanel.CandleConfigFrame;
import leaseLineQuote.candle.cfgpanel.CfgPanel;
import leaseLineQuote.candle.graph.ControlInterface;

public class RsiCfgPanel
extends JPanel
implements CfgPanel {
    private int valRsiA = 9;
    private int valRsiB = 14;
    private int valRsiUp = 80;
    private int valRsiDown = 20;
    private IntegerTextField rsiInputA;
    private IntegerTextField rsiInputB;
    private IntegerTextField rsiInputUp;
    private IntegerTextField rsiInputDown;
    private JLabel lblRsiA;
    private JLabel lblRsiB;
    private JLabel lblRsiUp;
    private JLabel lblRsiDown;
    private ColorButton colorRsiA;
    private ColorButton colorRsiB;
    private JCheckBox chkRSI_A;
    private JCheckBox chkRSI_B;
    private Color valColorD;
    private Color valColorE;
    private JLabel lblColorD;
    private JLabel lblColorE;
    private CandleConfigFrame parentFrame;
    private static RsiCfgPanel rsiPanel;
    private ControlInterface ctrInf;
    private int chartIdx = 1;
    private boolean isStartup = true;

    private RsiCfgPanel(CandleConfigFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.createRsiPanel();
    }

    @Override
    public String getKey() {
        return "RSI";
    }

    public static RsiCfgPanel getInstance(CandleConfigFrame parentFrame) {
        if (rsiPanel == null) {
            rsiPanel = new RsiCfgPanel(parentFrame);
        }
        return rsiPanel;
    }

    public void setChinese() {
        this.lblRsiA.setText("\u5f37\u5f31\u6307\u6578 1: ");
        this.lblRsiB.setText("\u5f37\u5f31\u6307\u6578 2: ");
        this.lblRsiUp.setText("\u5f37\u5f31\u6307\u6578 \u4e0a\u7dda: ");
        this.lblRsiDown.setText("\u5f37\u5f31\u6307\u6578 \u4e0b\u7dda: ");
        this.lblRsiA.setFont(StyledFont.PLAIN_CHINESE);
        this.lblRsiB.setFont(StyledFont.PLAIN_CHINESE);
        this.lblRsiUp.setFont(StyledFont.PLAIN_CHINESE);
        this.lblRsiDown.setFont(StyledFont.PLAIN_CHINESE);
        this.lblColorD.setFont(StyledFont.PLAIN_CHINESE);
        this.lblColorE.setFont(StyledFont.PLAIN_CHINESE);
        this.lblColorD.setText("\u8272\u5f69\uff1a");
        this.lblColorE.setText("\u8272\u5f69\uff1a");
    }

    public void setEnglish() {
        this.lblRsiA.setText("RSI 1: ");
        this.lblRsiB.setText("RSI 2: ");
        this.lblRsiUp.setText("RSI Up: ");
        this.lblRsiDown.setText("RSI Down: ");
        this.lblColorD.setText("Color: ");
        this.lblColorE.setText("Color: ");
        this.lblColorD.setFont(StyledFont.PLAINFONT);
        this.lblColorE.setFont(StyledFont.PLAINFONT);
        this.lblRsiA.setFont(StyledFont.PLAINFONT);
        this.lblRsiB.setFont(StyledFont.PLAINFONT);
        this.lblRsiUp.setFont(StyledFont.PLAINFONT);
        this.lblRsiDown.setFont(StyledFont.PLAINFONT);
    }

    private void createRsiPanel() {
        this.lblColorD = new JLabel("Color: ");
        this.lblColorD.setBounds(new Rectangle(165, 10, 63, 16));
        this.lblColorD.setForeground(Color.black);
        this.lblColorD.setFont(StyledFont.PLAINFONT);
        this.lblColorE = new JLabel("Color: ");
        this.lblColorE.setBounds(new Rectangle(165, 38, 63, 16));
        this.lblColorE.setForeground(Color.black);
        this.lblColorE.setFont(StyledFont.PLAINFONT);
        this.lblRsiA = new JLabel("RSI 1: ");
        this.lblRsiA.setBounds(new Rectangle(5, 10, 100, 16));
        this.lblRsiA.setForeground(Color.black);
        this.lblRsiA.setFont(StyledFont.PLAINFONT);
        this.lblRsiB = new JLabel("RSI 2: ");
        this.lblRsiB.setBounds(new Rectangle(5, 38, 100, 16));
        this.lblRsiB.setForeground(Color.black);
        this.lblRsiB.setFont(StyledFont.PLAINFONT);
        this.lblRsiDown = new JLabel("RSI Down: ");
        this.lblRsiDown.setBounds(new Rectangle(5, 94, 100, 16));
        this.lblRsiDown.setForeground(Color.black);
        this.lblRsiDown.setFont(StyledFont.PLAINFONT);
        this.lblRsiUp = new JLabel("RSI Up: ");
        this.lblRsiUp.setBounds(new Rectangle(5, 66, 100, 16));
        this.lblRsiUp.setForeground(Color.black);
        this.lblRsiUp.setFont(StyledFont.PLAINFONT);
        this.chkRSI_A = new JCheckBox("", true);
        this.chkRSI_A.setBounds(new Rectangle(240, 8, 21, 21));
        this.chkRSI_B = new JCheckBox("", true);
        this.chkRSI_B.setBounds(new Rectangle(240, 36, 21, 21));
        this.rsiInputA = new IntegerTextField(3);
        this.rsiInputA.setBounds(new Rectangle(110, 7, 33, 23));
        this.rsiInputA.setText("9");
        this.rsiInputB = new IntegerTextField(3);
        this.rsiInputB.setBounds(new Rectangle(110, 35, 33, 23));
        this.rsiInputB.setText("14");
        this.rsiInputUp = new IntegerTextField(3);
        this.rsiInputUp.setBounds(new Rectangle(110, 63, 33, 23));
        this.rsiInputUp.setText("80");
        this.rsiInputDown = new IntegerTextField(3);
        this.rsiInputDown.setBounds(new Rectangle(110, 91, 33, 23));
        this.rsiInputDown.setText("20");
        this.valColorD = Color.cyan.darker();
        this.valColorE = Color.blue.darker();
        this.colorRsiA = new ColorButton(this.valColorD, (JFrame)this.parentFrame);
        this.colorRsiA.setBounds(new Rectangle(215, 13, 10, 10));
        this.colorRsiB = new ColorButton(this.valColorE, (JFrame)this.parentFrame);
        this.colorRsiB.setBounds(new Rectangle(215, 41, 10, 10));
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.lblRsiA, null);
        this.add((Component)this.rsiInputA, null);
        this.add((Component)this.lblColorD, null);
        this.add((Component)this.colorRsiA, null);
        this.add((Component)this.chkRSI_A, null);
        this.add((Component)this.lblRsiB, null);
        this.add((Component)this.rsiInputB, null);
        this.add((Component)this.lblColorE, null);
        this.add((Component)this.colorRsiB, null);
        this.add((Component)this.chkRSI_B, null);
        this.add((Component)this.lblRsiDown, null);
        this.add((Component)this.rsiInputDown, null);
        this.add((Component)this.lblRsiUp, null);
        this.add((Component)this.rsiInputUp, null);
    }

    @Override
    public void unshowLines() {
        this.ctrInf.removeLowerIndicators(this.chartIdx, "RSI", 0);
        this.ctrInf.removeLowerIndicators(this.chartIdx, "RSI", 1);
    }

    @Override
    public void showLines(int chartIdx) {
        this.chartIdx = chartIdx;
        this.ctrInf.createLowerIndicators(chartIdx, "RSI", 0, new Color[]{this.valColorD}, new int[]{this.valRsiDown, this.valRsiUp, this.valRsiA});
        this.ctrInf.createLowerIndicators(chartIdx, "RSI", 1, new Color[]{this.valColorE}, new int[]{this.valRsiDown, this.valRsiUp, this.valRsiB});
    }

    @Override
    public void processConfirm() {
        this.processSetting();
        this.storeSetting();
    }

    private void processSetting() {
        this.ctrInf = CandleNewFrame.getControlInterface();
        try {
            this.valRsiUp = Integer.parseInt(this.rsiInputUp.getText());
            if (this.valRsiUp >= 100 || this.valRsiUp <= 0) {
                this.valRsiUp = 70;
            }
        }
        catch (Exception e2) {
            this.valRsiUp = 70;
        }
        try {
            this.valRsiDown = Integer.parseInt(this.rsiInputDown.getText());
            if (this.valRsiDown >= 100 || this.valRsiDown <= 0) {
                this.valRsiDown = 30;
            }
        }
        catch (Exception e3) {
            this.valRsiDown = 30;
        }
        if (this.chkRSI_A.isSelected()) {
            this.valColorD = this.colorRsiA.getBackground();
            try {
                this.valRsiA = Integer.parseInt(this.rsiInputA.getText());
            }
            catch (Exception e4) {
                this.valRsiA = 9;
            }
            if (this.isStartup) {
                this.ctrInf.createLowerIndicators(1, "RSI", 0, new Color[]{Color.RED.darker()}, new int[]{20, 80, 9});
            } else {
                this.ctrInf.setLowerIndicatorsColor(1, "RSI", 0, new Color[]{this.valColorD});
                this.ctrInf.setLowerIndicatorsCfg(1, "RSI", 0, new int[]{this.valRsiDown, this.valRsiUp, this.valRsiA});
            }
        }
        if (this.chkRSI_B.isSelected()) {
            this.valColorE = this.colorRsiB.getBackground();
            try {
                this.valRsiB = Integer.parseInt(this.rsiInputB.getText());
            }
            catch (Exception e5) {
                this.valRsiB = 14;
            }
            if (this.isStartup) {
                this.ctrInf.createLowerIndicators(1, "RSI", 1, new Color[]{this.valColorE}, new int[]{this.valRsiDown, this.valRsiUp, this.valRsiB});
            } else {
                this.ctrInf.setLowerIndicatorsColor(1, "RSI", 1, new Color[]{this.valColorE});
                this.ctrInf.setLowerIndicatorsCfg(1, "RSI", 1, new int[]{this.valRsiDown, this.valRsiUp, this.valRsiB});
            }
        }
        this.isStartup = false;
    }

    private void storeSetting() {
        UserProfile.put((Object)"RsiCfgPanel:valRsiA", (Object)new Integer(this.valRsiA));
        UserProfile.put((Object)"RsiCfgPanel:valColorD", (Object)this.valColorD);
        UserProfile.put((Object)"RsiCfgPanel:valRsiUp", (Object)new Integer(this.valRsiUp));
        UserProfile.put((Object)"RsiCfgPanel:valRsiDown", (Object)new Integer(this.valRsiDown));
        UserProfile.put((Object)"RsiCfgPanel:valRsiB", (Object)new Integer(this.valRsiB));
        UserProfile.put((Object)"RsiCfgPanel:valColorE", (Object)this.valColorE);
        UserProfile.put((Object)"RsiCfgPanel:chkRsiA", (Object)new Boolean(this.chkRSI_A.isSelected()));
        UserProfile.put((Object)"RsiCfgPanel:chkRsiB", (Object)new Boolean(this.chkRSI_B.isSelected()));
    }

    public void loadSetting() {
        Integer vRsiA = (Integer)UserProfile.get((Object)"RsiCfgPanel:valRsiA");
        Color vColorD = (Color)UserProfile.get((Object)"RsiCfgPanel:valColorD");
        Integer vRsiUp = (Integer)UserProfile.get((Object)"RsiCfgPanel:valRsiUp");
        Integer vRsiDown = (Integer)UserProfile.get((Object)"RsiCfgPanel:valRsiDown");
        Integer vRsiB = (Integer)UserProfile.get((Object)"RsiCfgPanel:valRsiB");
        Color vColorE = (Color)UserProfile.get((Object)"RsiCfgPanel:valColorE");
        Boolean chkRsiA = (Boolean)UserProfile.get((Object)"RsiCfgPanel:chkRsiA");
        Boolean chkRsiB = (Boolean)UserProfile.get((Object)"RsiCfgPanel:chkRsiB");
        if (vRsiA != null && vColorD != null && vRsiUp != null && vRsiDown != null && vRsiB != null && vColorE != null && chkRsiA != null && chkRsiB != null) {
            this.rsiInputUp.setText(vRsiUp.toString());
            this.rsiInputDown.setText(vRsiDown.toString());
            this.chkRSI_A.setSelected(chkRsiA);
            this.colorRsiA.setBackground(vColorD);
            this.rsiInputA.setText(vRsiA.toString());
            this.chkRSI_B.setSelected(chkRsiB);
            this.colorRsiB.setBackground(vColorE);
            this.rsiInputB.setText(vRsiB.toString());
        }
        this.processSetting();
    }
}

