/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public final class IlvJHiddenPrintWindowFactory {
    private static boolean a;

    public static Container createHiddenPrintWindow() {
        if (a) {
            return new LightweightJHiddenPrintWindow();
        }
        return new JHiddenPrintWindow();
    }

    private IlvJHiddenPrintWindowFactory() {
    }

    static {
        try {
            Method method = GraphicsEnvironment.class.getMethod("isHeadless", null);
            if (method != null) {
                a = (Boolean)method.invoke(null, null);
            }
        }
        catch (Exception exception) {
            a = false;
        }
    }

    private static final class JHiddenPrintWindow
    extends JWindow {
        private boolean a = false;

        public JHiddenPrintWindow() {
            this.getContentPane().setLayout(null);
            Runnable runnable = new Runnable(){

                public void run() {
                    JHiddenPrintWindow.this.addNotify();
                    JHiddenPrintWindow.this.a = true;
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        protected void addImpl(Component component, Object object, int n2) {
            if (this.isRootPaneCheckingEnabled()) {
                this.getContentPane().add(component, object, n2);
                this.pack();
            } else {
                super.addImpl(component, object, n2);
            }
        }

        public boolean isVisible() {
            return this.a;
        }

        public boolean isShowing() {
            return this.a;
        }
    }

    private static final class LightweightJHiddenPrintWindow
    extends JPanel {
        private boolean a;

        public LightweightJHiddenPrintWindow() {
            this.setSize(10, 10);
            this.setLayout(null);
            Runnable runnable = new Runnable(){

                public void run() {
                    LightweightJHiddenPrintWindow.this.addNotify();
                    LightweightJHiddenPrintWindow.this.a = true;
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        public boolean isVisible() {
            return this.a;
        }

        public boolean isShowing() {
            return this.a;
        }
    }
}

