/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import ilog.views.util.IlvColorUtil;
import ilog.views.util.beans.editor.Messages;
import ilog.views.util.swing.color.IlvColorChooserPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import javax.swing.JColorChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IlvColorPropertyEditor
extends PropertyEditorSupport {
    static MyJColorChooser a = null;
    Color b = Color.black;

    public String getJavaInitializationString() {
        Color color = (Color)this.getValue();
        return "new Color(" + color.getRed() + "," + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")";
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Color color = (Color)this.getValue();
        if (color == null) {
            return;
        }
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public String getAsText() {
        Color color = (Color)this.getValue();
        if (color == null) {
            return "";
        }
        return IlvColorPropertyEditor.color2Text(color);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.b = IlvColorPropertyEditor.text2Color(string);
        super.setValue(this.b);
    }

    public static final String color2Text(Color color) {
        return IlvColorUtil.toHumanReadableString(color);
    }

    public static final Color text2Color(String string) throws IllegalArgumentException {
        return IlvColorUtil.toColor(string);
    }

    public void setValue(Object object) {
        this.b = (Color)object;
        super.setValue(object);
        if (a != null) {
            a.setRef(null);
            a.setColor(this.b);
            a.setRef(this);
        }
    }

    public Object getValue() {
        return this.b;
    }

    public Component getCustomEditor() {
        if (a == null) {
            a = new MyJColorChooser();
            a.putClientProperty("__PSheetDialogTitleKey", Messages.BUNDLE.getString("ColorEditor.Title"));
            a.addChooserPanel(new IlvColorChooserPanel());
            a.getSelectionModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    a.setValue(a.getSelectionModel().getSelectedColor());
                }
            });
        }
        a.setRef(null);
        a.setColor(this.b);
        a.setRef(this);
        return a;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    static class MyJColorChooser
    extends JColorChooser {
        IlvColorPropertyEditor a;

        MyJColorChooser() {
        }

        public void setRef(IlvColorPropertyEditor ilvColorPropertyEditor) {
            this.a = ilvColorPropertyEditor;
        }

        public IlvColorPropertyEditor getRef() {
            return this.a;
        }

        public void setValue(Color color) {
            if (this.a != null) {
                this.a.setValue(color);
            }
        }
    }
}

