/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChart3DView;
import ilog.views.chart.IlvChartDrawable;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvGrid;
import ilog.views.chart.IlvLabelRenderer;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.util.IlvDoubleArray;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvArrayPool;
import ilog.views.chart.view3d.Ilv3DBounds;
import ilog.views.chart.view3d.Ilv3DPoints;
import ilog.views.chart.view3d.Ilv3DUtil;
import ilog.views.chart.view3d.Ilv3DVector;
import ilog.views.chart.view3d.IlvChart3DScene;
import ilog.views.chart.view3d.IlvPolyhedron;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class IlvChart3DWalls
extends IlvPolyhedron {
    private static final IlvStyle a = IlvStyle.createStroked(IlvGrid.getDefaultGridColor());
    private static final int b = 10;
    public static final int BACK_IDX = 0;
    public static final int LEFT_IDX = 1;
    public static final int RIGHT_IDX = 2;
    public static final int BOTTOM_IDX = 4;
    public static final int TOP_IDX = 3;
    private IlvLabelRenderer c = new IlvLabelRenderer();
    private boolean d = true;
    private boolean e = true;
    private IlvStyle f = null;

    public IlvChart3DWalls(IlvChart3DScene ilvChart3DScene) {
        super(ilvChart3DScene);
        this.renderingMode = 1;
        Ilv3DBounds ilv3DBounds = new Ilv3DBounds(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0);
        this.setVertices(Ilv3DUtil.createCubeVertices(ilv3DBounds.xMin, ilv3DBounds.yMin, ilv3DBounds.xMax, ilv3DBounds.yMax, ilv3DBounds.zMax, ilv3DBounds.zMin, null), ilv3DBounds.getCenter());
        IlvPolyhedron.Face[] faceArray = new IlvPolyhedron.Face[]{new IlvPolyhedron.Face(this, new int[]{7, 4, 5, 6}), new IlvPolyhedron.Face(this, new int[]{4, 0, 1, 5}), new IlvPolyhedron.Face(this, new int[]{3, 7, 6, 2}), new IlvPolyhedron.Face(this, new int[]{0, 4, 7, 3}), new IlvPolyhedron.Face(this, new int[]{1, 2, 6, 5})};
        this.setFaces(faceArray);
    }

    private IlvChart3DView b() {
        return ((IlvChart3DScene)this.getScene()).get3DView();
    }

    public IlvStyle getStyle() {
        return this.b().getChart().getChartArea().getPlotStyle();
    }

    public boolean isFaceVisible(IlvPolyhedron.Face face) {
        return face.getNormal((boolean)true).z <= 0.0;
    }

    public void draw(Graphics graphics, int n2) {
        IlvChart3DView ilvChart3DView = this.b();
        IlvChart ilvChart = ilvChart3DView.getChart();
        IlvStyle ilvStyle = this.getStyle();
        if (ilvStyle != null && ilvStyle.isFillOn()) {
            super.draw(graphics, 0);
        }
        Iterator iterator = ilvChart.getDrawableIterator();
        while (iterator.hasNext()) {
            IlvChartDrawable ilvChartDrawable = (IlvChartDrawable)iterator.next();
            if (!ilvChartDrawable.isVisible() || !ilvChartDrawable.has3DSupport() || ilvChart.isPrinting() && !ilvChart.getPrintContext().isVisible(ilvChartDrawable)) continue;
            ilvChartDrawable.draw(graphics);
        }
        this.drawZGrid(graphics);
        if (ilvStyle != null && ilvStyle.isStrokeOn()) {
            super.draw(graphics, 1);
        }
    }

    public void update() {
        Ilv3DBounds ilv3DBounds = ((IlvChart3DScene)this.getScene()).a();
        this.vtx = Ilv3DUtil.createCubeVertices(ilv3DBounds.xMin, ilv3DBounds.yMin, ilv3DBounds.xMax, ilv3DBounds.yMax, ilv3DBounds.zMax, ilv3DBounds.zMin, this.vtx);
        this.updateGeometry();
    }

    public double getCrossingValue(IlvAxis ilvAxis) {
        IlvChart ilvChart = this.b().getChart();
        if (ilvAxis.isXAxis()) {
            IlvPolyhedron.Face face;
            IlvAxis ilvAxis2 = ilvChart.getYAxis(0);
            IlvPolyhedron.Face face2 = face = ilvChart.isProjectorReversed() ? this.getFace(1) : this.getFace(4);
            if (this.isFaceVisible(face)) {
                return ilvAxis2.isReversed() ? ilvAxis2.getVisibleMax() : ilvAxis2.getVisibleMin();
            }
            return ilvAxis2.isReversed() ? ilvAxis2.getVisibleMin() : ilvAxis2.getVisibleMax();
        }
        IlvPolyhedron.Face face = ilvChart.isProjectorReversed() ? this.getFace(4) : this.getFace(1);
        IlvAxis ilvAxis3 = ilvChart.getXAxis();
        if (this.isFaceVisible(face)) {
            return ilvAxis3.isReversed() ? ilvAxis3.getVisibleMax() : ilvAxis3.getVisibleMin();
        }
        return ilvAxis3.isReversed() ? ilvAxis3.getVisibleMin() : ilvAxis3.getVisibleMax();
    }

    public void drawGridlines(Graphics graphics, IlvAxis ilvAxis, IlvDoubleArray ilvDoubleArray, IlvStyle ilvStyle) {
        boolean bl = this.getStyle() != null && this.getStyle().isStrokeOn();
        int n2 = ilvDoubleArray.size();
        Ilv3DPoints ilv3DPoints = this.getGridPoints(ilvAxis, ilvDoubleArray);
        this.b().getChart().toDisplay(ilv3DPoints);
        double[] dArray = ilv3DPoints.getXValues();
        double[] dArray2 = ilv3DPoints.getYValues();
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            double d2 = ilvDoubleArray.get(n3);
            if (!bl || d2 != ilvAxis.getVisibleMin() && d2 != ilvAxis.getVisibleMax()) {
                System.arraycopy(dArray, n4, dArray3, 0, 3);
                System.arraycopy(dArray2, n4, dArray4, 0, 3);
                ilvStyle.drawPolyline(graphics, dArray3, dArray4, 3);
            }
            ++n3;
            n4 += 3;
        }
    }

    public Ilv3DPoints getGridPoints(IlvAxis ilvAxis, IlvDoubleArray ilvDoubleArray) {
        Ilv3DPoints ilv3DPoints;
        block5: {
            double d2;
            double d3;
            int n2;
            IlvChart3DView ilvChart3DView;
            block4: {
                ilvChart3DView = this.b();
                n2 = ilvDoubleArray.size();
                ilv3DPoints = new Ilv3DPoints(3 * n2);
                d3 = ilvChart3DView.getFrontDepth();
                d2 = ilvChart3DView.getBackDepth();
                if (!ilvAxis.isXAxis()) break block4;
                IlvAxis ilvAxis2 = ilvChart3DView.getChart().getYAxis(0);
                double d4 = ilvAxis2.getVisibleMin();
                double d5 = ilvAxis2.getVisibleMax();
                boolean bl = this.getCrossingValue(ilvAxis) == d4;
                for (int i2 = 0; i2 < n2; ++i2) {
                    double d6 = ilvDoubleArray.get(i2);
                    if (bl) {
                        ilv3DPoints.add(d6, d4, d3);
                        ilv3DPoints.add(d6, d4, d2);
                        ilv3DPoints.add(d6, d5, d2);
                        continue;
                    }
                    ilv3DPoints.add(d6, d4, d2);
                    ilv3DPoints.add(d6, d5, d2);
                    ilv3DPoints.add(d6, d5, d3);
                }
                break block5;
            }
            if (!ilvAxis.isYAxis()) break block5;
            IlvAxis ilvAxis3 = ilvChart3DView.getChart().getXAxis();
            double d7 = ilvAxis3.getVisibleMin();
            double d8 = ilvAxis3.getVisibleMax();
            boolean bl = this.getCrossingValue(ilvAxis) == d7;
            for (int i3 = 0; i3 < n2; ++i3) {
                double d9 = ilvDoubleArray.get(i3);
                if (bl) {
                    ilv3DPoints.add(d7, d9, d3);
                    ilv3DPoints.add(d7, d9, d2);
                    ilv3DPoints.add(d8, d9, d2);
                    continue;
                }
                ilv3DPoints.add(d7, d9, d2);
                ilv3DPoints.add(d8, d9, d2);
                ilv3DPoints.add(d8, d9, d3);
            }
        }
        return ilv3DPoints;
    }

    public Ilv3DPoints getGridPoints(IlvAxis ilvAxis, double d2, Ilv3DPoints ilv3DPoints) {
        if (ilv3DPoints == null) {
            ilv3DPoints = new Ilv3DPoints(3);
        } else {
            ilv3DPoints.setSize(0);
        }
        IlvChart3DView ilvChart3DView = this.b();
        double d3 = ilvChart3DView.getFrontDepth();
        double d4 = ilvChart3DView.getBackDepth();
        boolean bl = false;
        if (ilvAxis.isXAxis()) {
            IlvAxis ilvAxis2 = ilvChart3DView.getChart().getYAxis(0);
            double d5 = ilvAxis2.getVisibleMin();
            double d6 = ilvAxis2.getVisibleMax();
            if (this.getCrossingValue(ilvAxis) == d5) {
                ilv3DPoints.add(d2, d5, d3);
                ilv3DPoints.add(d2, d5, d4);
                ilv3DPoints.add(d2, d6, d4);
            } else {
                ilv3DPoints.add(d2, d5, d4);
                ilv3DPoints.add(d2, d6, d4);
                ilv3DPoints.add(d2, d6, d3);
            }
        } else if (ilvAxis.isYAxis()) {
            IlvAxis ilvAxis3 = ilvChart3DView.getChart().getXAxis();
            double d7 = ilvAxis3.getVisibleMin();
            double d8 = ilvAxis3.getVisibleMax();
            if (this.getCrossingValue(ilvAxis) == d7) {
                ilv3DPoints.add(d7, d2, d3);
                ilv3DPoints.add(d7, d2, d4);
                ilv3DPoints.add(d8, d2, d4);
            } else {
                ilv3DPoints.add(d7, d2, d4);
                ilv3DPoints.add(d8, d2, d4);
                ilv3DPoints.add(d8, d2, d3);
            }
        }
        return ilv3DPoints;
    }

    public Rectangle2D getZAnnotationBounds() {
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        IlvChart.Area area = this.b().getChart().getChartArea();
        Ilv3DVector[] ilv3DVectorArray = null;
        IlvLabelRenderer ilvLabelRenderer = this.b().getZAnnotationRenderer();
        Iterator iterator = this.b().getZLayers().iterator();
        while (iterator.hasNext()) {
            IlvChart3DView.ZLayer zLayer = (IlvChart3DView.ZLayer)iterator.next();
            Iterator iterator2 = zLayer.getRenderers().iterator();
            String string = null;
            while (string == null && iterator2.hasNext()) {
                string = ((IlvSingleChartRenderer)iterator2.next()).getZAnnotationText();
            }
            if (string == null) continue;
            double d2 = (zLayer.getZMin() + zLayer.getZMax()) / 2.0;
            ilv3DVectorArray = this.a(d2, ilv3DVectorArray);
            Dimension2D dimension2D = ilvLabelRenderer.getSize2D(area, string, true, true);
            double d3 = IlvGraphicUtil.pointAngleDeg(ilv3DVectorArray[1].x, ilv3DVectorArray[1].y, ilv3DVectorArray[2].x, ilv3DVectorArray[2].y);
            IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilv3DVectorArray[2].x, ilv3DVectorArray[2].y);
            ilvDoublePoint = IlvGraphicUtil.computeTextLocation(ilvDoublePoint, d3, 10, dimension2D.getWidth(), dimension2D.getHeight());
            ((Rectangle2D)double_).setRect(ilvDoublePoint.x - dimension2D.getWidth() / 2.0, ilvDoublePoint.y - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
            rectangle2D = IlvGraphicUtil.addToRect(rectangle2D, double_);
        }
        return rectangle2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawZGrid(Graphics graphics) {
        if (!this.isZAnnotationVisible() && !this.isZGridVisible()) {
            return;
        }
        IlvChart3DView ilvChart3DView = this.b();
        IlvChart.Area area = ilvChart3DView.getChart().getChartArea();
        Ilv3DVector[] ilv3DVectorArray = null;
        IlvLabelRenderer ilvLabelRenderer = ilvChart3DView.getZAnnotationRenderer();
        Iterator iterator = ilvChart3DView.getZLayers().iterator();
        IlvChart3DView.ZLayer zLayer = null;
        Object object = IlvArrayPool.getDoubleCoordsLock();
        synchronized (object) {
            while (iterator.hasNext()) {
                Object object2;
                double d2;
                IlvChart3DView.ZLayer zLayer2 = (IlvChart3DView.ZLayer)iterator.next();
                if (zLayer != null && this.isZGridVisible()) {
                    d2 = (zLayer.getZMax() + zLayer2.getZMin()) / 2.0;
                    ilv3DVectorArray = this.a(d2, ilv3DVectorArray);
                    object2 = Ilv3DUtil.a(ilv3DVectorArray, 0, 2, false, true);
                    this.a().drawPolyline(graphics, (double[])object2[0], (double[])object2[1], 3);
                }
                zLayer = zLayer2;
                if (!this.isZAnnotationVisible()) continue;
                d2 = (zLayer2.getZMin() + zLayer2.getZMax()) / 2.0;
                object2 = zLayer2.getRenderers().iterator();
                String string = null;
                while (string == null && object2.hasNext()) {
                    string = ((IlvSingleChartRenderer)object2.next()).getZAnnotationText();
                }
                if (string == null) continue;
                ilv3DVectorArray = this.a(d2, ilv3DVectorArray);
                Dimension2D dimension2D = ilvLabelRenderer.getSize2D(area, string, true, true);
                double d3 = IlvGraphicUtil.pointAngleDeg(ilv3DVectorArray[1].x, ilv3DVectorArray[1].y, ilv3DVectorArray[2].x, ilv3DVectorArray[2].y);
                IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilv3DVectorArray[2].x, ilv3DVectorArray[2].y);
                ilvDoublePoint = IlvGraphicUtil.computeTextLocation(ilvDoublePoint, d3, 10, dimension2D.getWidth(), dimension2D.getHeight());
                ilvLabelRenderer.paintLabel(area, graphics, string, ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor());
            }
        }
    }

    private Ilv3DVector[] a(double d2, Ilv3DVector[] ilv3DVectorArray) {
        int[] nArray = null;
        nArray = this.isFaceVisible(this.getFace(1)) ? (this.isFaceVisible(this.getFace(4)) ? new int[]{0, 1, 2} : new int[]{1, 0, 3}) : (this.isFaceVisible(this.getFace(4)) ? new int[]{3, 2, 1} : new int[]{2, 3, 0});
        if (ilv3DVectorArray == null) {
            ilv3DVectorArray = new Ilv3DVector[]{this.getVertices()[nArray[0]].copy(), this.getVertices()[nArray[1]].copy(), this.getVertices()[nArray[2]].copy()};
            ilv3DVectorArray[0].z = d2;
            ilv3DVectorArray[1].z = d2;
            ilv3DVectorArray[2].z = d2;
        } else {
            Ilv3DVector ilv3DVector = this.getVertices()[nArray[0]];
            ilv3DVectorArray[0].set(ilv3DVector.x, ilv3DVector.y, d2);
            ilv3DVector = this.getVertices()[nArray[1]];
            ilv3DVectorArray[1].set(ilv3DVector.x, ilv3DVector.y, d2);
            ilv3DVector = this.getVertices()[nArray[2]];
            ilv3DVectorArray[2].set(ilv3DVector.x, ilv3DVector.y, d2);
        }
        this.getScene().getTransform().transform(1, ilv3DVectorArray, ilv3DVectorArray, 3);
        return ilv3DVectorArray;
    }

    public void setZAnnotationRenderer(IlvLabelRenderer ilvLabelRenderer) {
        this.c = ilvLabelRenderer;
    }

    public final IlvLabelRenderer getZAnnotationRenderer() {
        return this.c;
    }

    public void setZAnnotationVisible(boolean bl) {
        this.d = bl;
    }

    public final boolean isZAnnotationVisible() {
        return this.d;
    }

    public void setZGridVisible(boolean bl) {
        this.e = bl;
    }

    public final boolean isZGridVisible() {
        return this.e;
    }

    public void setZGridStroke(Stroke stroke) {
        this.f = this.a().setStroke(stroke);
    }

    public final Stroke getZGridStroke() {
        return this.a().getStroke();
    }

    public void setZGridPaint(Paint paint) {
        this.f = this.a().setStrokePaint(paint);
    }

    public final Paint getZGridPaint() {
        return this.a().getStrokePaint();
    }

    final IlvStyle a() {
        if (this.f == null) {
            IlvGrid ilvGrid = this.b().getChart().getXGrid();
            if (ilvGrid == null) {
                ilvGrid = this.b().getChart().getYGrid(0);
            }
            return ilvGrid == null ? a : ilvGrid.getMajorStyle();
        }
        return this.f;
    }

    public boolean isCulling() {
        return false;
    }
}

