/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.renderer.IlvSinglePolylineRenderer;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.view3d.Ilv3DVector;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.chart.view3d.IlvChart3DScene;
import ilog.views.chart.view3d.IlvPolyhedron;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;

public class IlvChart3DLine
extends IlvChart3DObject {
    public IlvChart3DLine(IlvChart3DScene ilvChart3DScene, IlvDoublePoints ilvDoublePoints, double[] dArray, IlvSingleChartRenderer ilvSingleChartRenderer, int n2) {
        this(ilvChart3DScene, ilvDoublePoints.getX(0), ilvDoublePoints.getY(0), ilvDoublePoints.getX(1), ilvDoublePoints.getY(1), dArray, ilvSingleChartRenderer, n2);
    }

    public IlvChart3DLine(IlvChart3DScene ilvChart3DScene, double d2, double d3, double d4, double d5, double[] dArray, IlvSingleChartRenderer ilvSingleChartRenderer, int n2) {
        super(ilvChart3DScene, ilvSingleChartRenderer, n2);
        Ilv3DVector[] ilv3DVectorArray = new Ilv3DVector[]{new Ilv3DVector(d2, d3, dArray[0]), new Ilv3DVector(d4, d5, dArray[0]), new Ilv3DVector(d4, d5, dArray[1]), new Ilv3DVector(d2, d3, dArray[1])};
        this.setVertices(ilv3DVectorArray, null);
        this.setFaces(new IlvPolyhedron.Face[]{new IlvPolyhedron.Face(this, new int[]{0, 3, 2, 1})});
    }

    public final IlvChart3DLine setGeometry(IlvDoublePoints ilvDoublePoints, double[] dArray, int n2) {
        return this.setGeometry(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0), ilvDoublePoints.getX(1), ilvDoublePoints.getY(1), dArray, n2);
    }

    public final IlvChart3DLine setGeometry(double d2, double d3, double d4, double d5, double[] dArray, int n2) {
        this.dataIdx = n2;
        Ilv3DVector[] ilv3DVectorArray = this.getVertices();
        ilv3DVectorArray[0].set(d2, d3, dArray[0]);
        ilv3DVectorArray[1].set(d4, d5, dArray[0]);
        ilv3DVectorArray[2].set(d4, d5, dArray[1]);
        ilv3DVectorArray[3].set(d2, d3, dArray[1]);
        this.updateGeometry();
        this.applyTransform(this.getScene().getTransform(), 1);
        this.getScene().sortValid = false;
        return this;
    }

    protected Ilv3DVector computeFaceNormal(IlvPolyhedron.Face face) {
        return this.a(face, null);
    }

    public IlvStyle getStyle() {
        IlvStyle ilvStyle = super.getStyle();
        if (!ilvStyle.isStrokeOn()) {
            return new IlvStyle(ilvStyle.getStrokePaint());
        }
        Paint paint = ((IlvSinglePolylineRenderer)this.getRenderer()).get3DOutlinePaint();
        return paint == null ? new IlvStyle(ilvStyle.getStrokePaint()) : new IlvStyle(ilvStyle.getStroke(), paint, ilvStyle.getStrokePaint());
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        Ilv3DVector ilv3DVector = this.getFace(0).getCenter(true);
        return new Point(IlvGraphicUtil.toInt(ilv3DVector.x), IlvGraphicUtil.toInt(ilv3DVector.y));
    }

    public boolean isCulling() {
        return false;
    }
}

