/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.servlet;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import ilog.views.chart.servlet.IlvImageEncoder;
import ilog.views.chart.servlet.IlvServletParameters;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class IlvJPEGEncoder
implements IlvImageEncoder {
    public static final String QUALITY_PARAM = "quality";
    private float a = 0.75f;

    public final void setJPEGQuality(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("quality must be in [0-1] range");
        }
        this.a = f2;
    }

    public final float getJPEGQuality() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(BufferedImage bufferedImage, HttpServletResponse httpServletResponse, IlvServletParameters ilvServletParameters) throws IOException, ServletException {
        float f2 = ilvServletParameters.getFloat(QUALITY_PARAM, this.getJPEGQuality());
        httpServletResponse.setContentType("image/JPEG");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        Class clazz = JPEGCodec.class;
        synchronized (clazz) {
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)servletOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(f2, false);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
        }
        servletOutputStream.close();
    }
}

