/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.interactor;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvCategoryStepsDefinition;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvDefaultStepsDefinition;
import ilog.views.chart.IlvScale;
import ilog.views.chart.IlvStepsDefinition;
import ilog.views.chart.IlvTimeStepsDefinition;
import java.awt.event.KeyEvent;

public abstract class IlvChartScrollInteractor
extends IlvChartInteractor {
    static final int a = 2;
    public static final int POSITIVE_DIR = 1;
    public static final int NEGATIVE_DIR = 2;
    private int b;
    private int c;

    public IlvChartScrollInteractor(int n2, int n3, int n4) {
        this(0, n2, n3, n4);
    }

    public IlvChartScrollInteractor(int n2, int n3, int n4, int n5) {
        super(n2, n3);
        this.b = n4;
        this.c = n5;
        this.enableEvents(8L);
        this.setXORGhost(false);
    }

    public final int getPositiveDirectionKey() {
        return this.b;
    }

    public final void setPositiveDirectionKey(int n2) {
        this.b = n2;
    }

    public final int getNegativeDirectionKey() {
        return this.getEventMask();
    }

    public final void setNegativeDirectionKey(int n2) {
        this.setEventMask(n2);
    }

    public final int getStep() {
        return this.c;
    }

    public final void setStep(int n2) {
        this.c = n2;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        if (n2 == this.getNegativeDirectionKey() || n2 == this.b) {
            if (keyEvent.getID() == 401) {
                this.getXAxis().setAdjusting(true);
                this.getYAxis().setAdjusting(true);
                if (n2 == this.getNegativeDirectionKey()) {
                    this.scroll(2);
                } else {
                    this.scroll(1);
                }
                keyEvent.consume();
            } else if (keyEvent.getID() == 402) {
                this.getXAxis().setAdjusting(false);
                this.getYAxis().setAdjusting(false);
                keyEvent.consume();
            }
        }
    }

    protected double getDelta() {
        IlvScale ilvScale = this.getChart().getScale(this.getAxis());
        double d2 = this.getAxis().getVisibleRange().getLength() * (double)this.getStep() / 100.0;
        if (ilvScale != null) {
            IlvStepsDefinition ilvStepsDefinition = ilvScale.getStepsDefinition();
            if (ilvStepsDefinition instanceof IlvDefaultStepsDefinition) {
                d2 = ((IlvDefaultStepsDefinition)ilvStepsDefinition).getStepUnit() * (double)this.getStep();
            } else if (ilvStepsDefinition instanceof IlvTimeStepsDefinition) {
                d2 = ((IlvTimeStepsDefinition)ilvStepsDefinition).getUnit().getMillis() * (double)this.getStep();
            } else if (ilvStepsDefinition instanceof IlvCategoryStepsDefinition) {
                d2 = this.getStep();
            }
        }
        return d2;
    }

    protected abstract void scroll(int var1);

    protected abstract IlvAxis getAxis();
}

